/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.geom.AffineTransform;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.util.Matrix;

public class PDTilingPattern
extends PDAbstractPattern
implements PDContentStream {
    public static final int PAINT_COLORED = 1;
    public static final int PAINT_UNCOLORED = 2;
    public static final int TILING_CONSTANT_SPACING = 1;
    public static final int TILING_NO_DISTORTION = 2;
    public static final int TILING_CONSTANT_SPACING_FASTER_TILING = 3;

    public PDTilingPattern() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 1);
    }

    public PDTilingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 1;
    }

    @Override
    public void setLength(int length) {
        this.getCOSDictionary().setInt(COSName.LENGTH, length);
    }

    @Override
    public int getLength() {
        return this.getCOSDictionary().getInt(COSName.LENGTH, 0);
    }

    @Override
    public void setPaintType(int paintType) {
        this.getCOSDictionary().setInt(COSName.PAINT_TYPE, paintType);
    }

    public int getPaintType() {
        return this.getCOSDictionary().getInt(COSName.PAINT_TYPE, 0);
    }

    public void setTilingType(int tilingType) {
        this.getCOSDictionary().setInt(COSName.TILING_TYPE, tilingType);
    }

    public int getTilingType() {
        return this.getCOSDictionary().getInt(COSName.TILING_TYPE, 0);
    }

    public void setXStep(float xStep) {
        this.getCOSDictionary().setFloat(COSName.X_STEP, xStep);
    }

    public float getXStep() {
        return this.getCOSDictionary().getFloat(COSName.X_STEP, 0.0f);
    }

    public void setYStep(float yStep) {
        this.getCOSDictionary().setFloat(COSName.Y_STEP, yStep);
    }

    public float getYStep() {
        return this.getCOSDictionary().getFloat(COSName.Y_STEP, 0.0f);
    }

    @Override
    public COSStream getContentStream() {
        return (COSStream)this.getCOSObject();
    }

    @Override
    public PDResources getResources() {
        PDResources retval = null;
        COSDictionary resources = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            retval = new PDResources(resources);
        }
        return retval;
    }

    public void setResources(PDResources resources) {
        if (resources != null) {
            this.getCOSDictionary().setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.getCOSDictionary().removeItem(COSName.RESOURCES);
        }
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSDictionary().removeItem(COSName.BBOX);
        } else {
            this.getCOSDictionary().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    @Override
    public Matrix getMatrix() {
        Matrix matrix = null;
        COSArray array = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            matrix = new Matrix();
            matrix.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            matrix.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            matrix.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            matrix.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            matrix.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            matrix.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        } else {
            matrix = new Matrix();
        }
        return matrix;
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSDictionary().setItem(COSName.MATRIX, (COSBase)matrix);
    }
}

