/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExternalGraphicsState;
import org.apache.pdfbox.util.Matrix;

public class PDShadingPattern
extends PDAbstractPattern {
    private PDExternalGraphicsState extendedGraphicsState;
    private PDShading shading;
    private COSArray matrix = null;

    public PDShadingPattern() {
        this.getCOSDictionary().setInt(COSName.PATTERN_TYPE, 2);
    }

    public PDShadingPattern(COSDictionary resourceDictionary) {
        super(resourceDictionary);
    }

    @Override
    public int getPatternType() {
        return 2;
    }

    public Matrix getMatrix() {
        Matrix returnMatrix = null;
        if (this.matrix == null) {
            this.matrix = (COSArray)this.getCOSDictionary().getDictionaryObject(COSName.MATRIX);
        }
        if (this.matrix != null) {
            returnMatrix = new Matrix();
            returnMatrix.setValue(0, 0, ((COSNumber)this.matrix.get(0)).floatValue());
            returnMatrix.setValue(0, 1, ((COSNumber)this.matrix.get(1)).floatValue());
            returnMatrix.setValue(1, 0, ((COSNumber)this.matrix.get(2)).floatValue());
            returnMatrix.setValue(1, 1, ((COSNumber)this.matrix.get(3)).floatValue());
            returnMatrix.setValue(2, 0, ((COSNumber)this.matrix.get(4)).floatValue());
            returnMatrix.setValue(2, 1, ((COSNumber)this.matrix.get(5)).floatValue());
        }
        return returnMatrix;
    }

    public void setMatrix(AffineTransform transform) {
        this.matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            this.matrix.add(new COSFloat((float)v));
        }
        this.getCOSDictionary().setItem(COSName.MATRIX, (COSBase)this.matrix);
    }

    public PDExternalGraphicsState getExtendedGraphicsState() {
        COSDictionary dictionary;
        if (this.extendedGraphicsState == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.EXT_G_STATE)) != null) {
            this.extendedGraphicsState = new PDExternalGraphicsState(dictionary);
        }
        return this.extendedGraphicsState;
    }

    public void setExtendedGraphicsState(PDExternalGraphicsState extendedGraphicsState) {
        this.extendedGraphicsState = extendedGraphicsState;
        if (extendedGraphicsState != null) {
            this.getCOSDictionary().setItem(COSName.EXT_G_STATE, (COSObjectable)extendedGraphicsState);
        } else {
            this.getCOSDictionary().removeItem(COSName.EXT_G_STATE);
        }
    }

    public PDShading getShading() throws IOException {
        COSDictionary dictionary;
        if (this.shading == null && (dictionary = (COSDictionary)this.getCOSDictionary().getDictionaryObject(COSName.SHADING)) != null) {
            this.shading = PDShading.create(dictionary);
        }
        return this.shading;
    }

    public void setShading(PDShading shadingResources) {
        this.shading = shadingResources;
        if (shadingResources != null) {
            this.getCOSDictionary().setItem(COSName.SHADING, (COSObjectable)shadingResources);
        } else {
            this.getCOSDictionary().removeItem(COSName.SHADING);
        }
    }
}

