/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;

public abstract class PDAbstractPattern
implements COSObjectable {
    public static final int TYPE_TILING_PATTERN = 1;
    public static final int TYPE_SHADING_PATTERN = 2;
    private COSDictionary patternDictionary;

    public static PDAbstractPattern create(COSDictionary resourceDictionary) throws IOException {
        PDAbstractPattern pattern;
        int patternType = resourceDictionary.getInt(COSName.PATTERN_TYPE, 0);
        switch (patternType) {
            case 1: {
                pattern = new PDTilingPattern(resourceDictionary);
                break;
            }
            case 2: {
                pattern = new PDShadingPattern(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown pattern type " + patternType);
            }
        }
        return pattern;
    }

    public PDAbstractPattern() {
        this.patternDictionary = new COSDictionary();
        this.patternDictionary.setName(COSName.TYPE, COSName.PATTERN.getName());
    }

    public PDAbstractPattern(COSDictionary resourceDictionary) {
        this.patternDictionary = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.patternDictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.patternDictionary;
    }

    public void setFilter(String filter) {
        this.patternDictionary.setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public String getFilter() {
        return this.patternDictionary.getNameAsString(COSName.FILTER);
    }

    public void setLength(int length) {
        this.patternDictionary.setInt(COSName.LENGTH, length);
    }

    public int getLength() {
        return this.patternDictionary.getInt(COSName.LENGTH, 0);
    }

    public void setPaintType(int paintType) {
        this.patternDictionary.setInt(COSName.PAINT_TYPE, paintType);
    }

    public String getType() {
        return COSName.PATTERN.getName();
    }

    public void setPatternType(int patternType) {
        this.patternDictionary.setInt(COSName.PATTERN_TYPE, patternType);
    }

    public abstract int getPatternType();
}

