/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;

public final class TIFFInputStream
extends InputStream {
    private static final List<String> FAX_FILTERS = new ArrayList<String>();
    private int currentOffset;
    private byte[] tiffheader;
    private InputStream datastream;
    private final byte[] basicHeader = new byte[]{73, 73, 42, 0, 8, 0, 0, 0, 0, 0};
    private int additionalOffset;

    public static void writeToOutputStream(PDImage image, OutputStream out) throws IOException {
        InputStream faxInput = image.getStream().getPartiallyFilteredStream(FAX_FILTERS);
        COSStream cosStream = (COSStream)image.getStream().getCOSObject();
        TIFFInputStream data = new TIFFInputStream(faxInput, cosStream);
        IOUtils.copy(data, out);
    }

    private TIFFInputStream(InputStream rawstream, COSDictionary options) {
        this.buildHeader(options);
        this.currentOffset = 0;
        this.datastream = rawstream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public int read() throws IOException {
        if (this.currentOffset < this.tiffheader.length) {
            return this.tiffheader[this.currentOffset++];
        }
        return this.datastream.read();
    }

    @Override
    public int read(byte[] data) throws IOException {
        if (this.currentOffset < this.tiffheader.length) {
            int length = Math.min(this.tiffheader.length - this.currentOffset, data.length);
            if (length > 0) {
                System.arraycopy(this.tiffheader, this.currentOffset, data, 0, length);
            }
            this.currentOffset += length;
            return length;
        }
        return this.datastream.read(data);
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        if (this.currentOffset < this.tiffheader.length) {
            int length = Math.min(this.tiffheader.length - this.currentOffset, len);
            if (length > 0) {
                System.arraycopy(this.tiffheader, this.currentOffset, data, off, length);
            }
            this.currentOffset += length;
            return length;
        }
        return this.datastream.read(data, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.currentOffset < this.tiffheader.length) {
            long length = Math.min((long)(this.tiffheader.length - this.currentOffset), n);
            this.currentOffset = (int)((long)this.currentOffset + length);
            return length;
        }
        return this.datastream.skip(n);
    }

    private void buildHeader(COSDictionary options) {
        int numOfTags = 10;
        int maxAdditionalData = 24;
        int ifdSize = 134;
        this.tiffheader = new byte[ifdSize + 24];
        Arrays.fill(this.tiffheader, (byte)0);
        System.arraycopy(this.basicHeader, 0, this.tiffheader, 0, this.basicHeader.length);
        this.additionalOffset = ifdSize;
        short cols = 1728;
        short rows = 0;
        short blackis1 = 0;
        int comptype = 3;
        long t4options = 0L;
        COSArray decode = (COSArray)options.getDictionaryObject(COSName.DECODE);
        if (decode != null && decode.getInt(0) == 1) {
            blackis1 = 1;
        }
        COSBase dicOrArrayParms = options.getDictionaryObject(COSName.DECODE_PARMS);
        COSDictionary decodeParms = null;
        if (dicOrArrayParms instanceof COSDictionary) {
            decodeParms = (COSDictionary)dicOrArrayParms;
        } else {
            COSArray parmsArray = (COSArray)dicOrArrayParms;
            if (parmsArray.size() == 1) {
                decodeParms = (COSDictionary)parmsArray.getObject(0);
            } else {
                for (int i = 0; i < parmsArray.size() && decodeParms == null; ++i) {
                    COSDictionary dic = (COSDictionary)parmsArray.getObject(i);
                    if (dic == null || dic.getDictionaryObject(COSName.COLUMNS) == null && dic.getDictionaryObject(COSName.ROWS) == null) continue;
                    decodeParms = dic;
                }
            }
        }
        if (decodeParms != null) {
            int k;
            cols = (short)decodeParms.getInt(COSName.COLUMNS, (int)cols);
            rows = (short)decodeParms.getInt(COSName.ROWS, (int)rows);
            if (decodeParms.getBoolean(COSName.BLACK_IS_1, false)) {
                blackis1 = 1;
            }
            if ((k = decodeParms.getInt(COSName.K, 0)) < 0) {
                comptype = 4;
            }
            if (k > 0) {
                comptype = 3;
                t4options = 1L;
            }
        }
        if (rows == 0) {
            rows = (short)options.getInt(COSName.HEIGHT, (int)rows);
        }
        this.addTag(256, cols);
        this.addTag(257, rows);
        this.addTag(259, (short)comptype);
        this.addTag(262, blackis1);
        this.addTag(273, this.tiffheader.length);
        this.addTag(279, options.getInt(COSName.LENGTH));
        this.addTag(282, 300L, 1L);
        this.addTag(283, 300L, 1L);
        if (comptype == 3) {
            this.addTag(292, t4options);
        }
        this.addTag(305, "PDFBOX");
    }

    private void addTag(int tag, long value) {
        byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
        int offset = (count - 1) * 12 + 10;
        this.tiffheader[offset] = (byte)(tag & 0xFF);
        this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
        this.tiffheader[offset + 2] = 4;
        this.tiffheader[offset + 4] = 1;
        this.tiffheader[offset + 8] = (byte)(value & 0xFFL);
        this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFFL);
        this.tiffheader[offset + 10] = (byte)(value >> 16 & 0xFFL);
        this.tiffheader[offset + 11] = (byte)(value >> 24 & 0xFFL);
    }

    private void addTag(int tag, short value) {
        byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
        int offset = (count - 1) * 12 + 10;
        this.tiffheader[offset] = (byte)(tag & 0xFF);
        this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
        this.tiffheader[offset + 2] = 3;
        this.tiffheader[offset + 4] = 1;
        this.tiffheader[offset + 8] = (byte)(value & 0xFF);
        this.tiffheader[offset + 9] = (byte)(value >> 8 & 0xFF);
    }

    private void addTag(int tag, String value) {
        byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
        int offset = (count - 1) * 12 + 10;
        this.tiffheader[offset] = (byte)(tag & 0xFF);
        this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
        this.tiffheader[offset + 2] = 2;
        int len = value.length() + 1;
        this.tiffheader[offset + 4] = (byte)(len & 0xFF);
        this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
        this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
        this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
        this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
        try {
            System.arraycopy(value.getBytes("US-ASCII"), 0, this.tiffheader, this.additionalOffset, value.length());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Incompatible VM without US-ASCII encoding", e);
        }
        this.additionalOffset += len;
    }

    private void addTag(int tag, long numerator, long denominator) {
        byte count = this.tiffheader[8] = (byte)(this.tiffheader[8] + 1);
        int offset = (count - 1) * 12 + 10;
        this.tiffheader[offset] = (byte)(tag & 0xFF);
        this.tiffheader[offset + 1] = (byte)(tag >> 8 & 0xFF);
        this.tiffheader[offset + 2] = 5;
        this.tiffheader[offset + 4] = 1;
        this.tiffheader[offset + 8] = (byte)(this.additionalOffset & 0xFF);
        this.tiffheader[offset + 9] = (byte)(this.additionalOffset >> 8 & 0xFF);
        this.tiffheader[offset + 10] = (byte)(this.additionalOffset >> 16 & 0xFF);
        this.tiffheader[offset + 11] = (byte)(this.additionalOffset >> 24 & 0xFF);
        this.tiffheader[this.additionalOffset++] = (byte)(numerator & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 8 & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 16 & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(numerator >> 24 & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(denominator & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 8 & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 16 & 0xFFL);
        this.tiffheader[this.additionalOffset++] = (byte)(denominator >> 24 & 0xFFL);
    }

    static {
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE.getName());
        FAX_FILTERS.add(COSName.CCITTFAX_DECODE_ABBREVIATION.getName());
    }
}

