/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.MissingImageReaderException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.image.ImageFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.w3c.dom.Element;

public final class JPEGFactory
extends ImageFactory {
    private JPEGFactory() {
    }

    public static PDImageXObject createFromStream(PDDocument document, InputStream stream) throws IOException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(IOUtils.toByteArray(stream));
        BufferedImage awtImage = JPEGFactory.readJPEG(byteStream);
        byteStream.reset();
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, awtImage.getWidth(), awtImage.getHeight(), awtImage.getColorModel().getComponentSize(0), JPEGFactory.getColorSpaceFromAWT(awtImage));
        if (awtImage.getColorModel().hasAlpha()) {
            throw new UnsupportedOperationException("alpha channel not implemented");
        }
        return pdImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readJPEG(InputStream stream) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        ImageReader reader = null;
        while (readers.hasNext() && !(reader = readers.next()).canReadRaster()) {
        }
        if (reader == null) {
            throw new MissingImageReaderException("Cannot read JPEG image: a suitable JAI I/O image filter is not installed");
        }
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(stream);
            reader.setInput(iis);
            ImageIO.setUseCache(false);
            BufferedImage bufferedImage = reader.read(0);
            return bufferedImage;
        }
        finally {
            if (iis != null) {
                iis.close();
            }
            reader.dispose();
        }
    }

    public static PDImageXObject createFromImage(PDDocument document, BufferedImage image) throws IOException {
        return JPEGFactory.createFromImage(document, image, 0.75f);
    }

    public static PDImageXObject createFromImage(PDDocument document, BufferedImage image, float quality) throws IOException {
        return JPEGFactory.createFromImage(document, image, quality, 72);
    }

    public static PDImageXObject createFromImage(PDDocument document, BufferedImage image, float quality, int dpi) throws IOException {
        return JPEGFactory.createJPEG(document, image, quality, dpi);
    }

    private static BufferedImage getAlphaImage(BufferedImage image) throws IOException {
        if (!image.getColorModel().hasAlpha()) {
            return null;
        }
        if (image.getTransparency() == 2) {
            throw new UnsupportedOperationException("BITMASK Transparency JPEG compression is not useful, use LosslessImageFactory instead");
        }
        WritableRaster alphaRaster = image.getAlphaRaster();
        BufferedImage alphaImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        alphaImage.setData(alphaRaster);
        return alphaImage;
    }

    private static PDImageXObject createJPEG(PDDocument document, BufferedImage image, float quality, int dpi) throws IOException {
        BufferedImage awtColorImage = JPEGFactory.getColorImage(image);
        BufferedImage awtAlphaImage = JPEGFactory.getAlphaImage(image);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JPEGFactory.encodeImageToJPEGStream(awtColorImage, quality, dpi, baos);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(baos.toByteArray());
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, awtColorImage.getWidth(), awtColorImage.getHeight(), awtColorImage.getColorModel().getComponentSize(0), JPEGFactory.getColorSpaceFromAWT(awtColorImage));
        if (awtAlphaImage != null) {
            PDImageXObject xAlpha = JPEGFactory.createFromImage(document, awtAlphaImage, quality);
            pdImage.getCOSStream().setItem(COSName.SMASK, (COSObjectable)xAlpha);
        }
        return pdImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeImageToJPEGStream(BufferedImage image, float quality, int dpi, OutputStream out) throws IOException {
        ImageOutputStream ios = null;
        ImageWriter imageWriter = null;
        try {
            imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ios = ImageIO.createImageOutputStream(out);
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParam = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParam.setCompressionMode(2);
            jpegParam.setCompressionQuality(quality);
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(image);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, jpegParam);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            imageWriter.write(data, new IIOImage(image, null, null), jpegParam);
        }
        finally {
            IOUtils.closeQuietly(out);
            if (ios != null) {
                ios.close();
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }
}

