/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.form;

import java.awt.geom.AffineTransform;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.apache.pdfbox.util.Matrix;

public class PDFormXObject
extends PDXObject
implements PDContentStream {
    private String name;
    private PDGroup group;

    public PDFormXObject(PDStream stream) {
        super(stream, COSName.FORM);
    }

    public PDFormXObject(PDStream stream, String name) {
        super(stream, COSName.FORM);
        this.name = name;
    }

    public PDFormXObject(PDDocument document) {
        super(document, COSName.FORM);
    }

    public int getFormType() {
        return this.getCOSStream().getInt(COSName.FORMTYPE, 1);
    }

    public void setFormType(int formType) {
        this.getCOSStream().setInt(COSName.FORMTYPE, formType);
    }

    public PDGroup getGroup() {
        COSDictionary dic;
        if (this.group == null && (dic = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.GROUP)) != null) {
            this.group = new PDGroup(dic);
        }
        return this.group;
    }

    @Override
    public COSStream getContentStream() {
        return this.getCOSStream();
    }

    @Override
    public PDResources getResources() {
        COSDictionary resources = (COSDictionary)this.getCOSStream().getDictionaryObject(COSName.RESOURCES);
        if (resources != null) {
            return new PDResources(resources);
        }
        return null;
    }

    public void setResources(PDResources resources) {
        this.getCOSStream().setItem(COSName.RESOURCES, (COSObjectable)resources);
    }

    @Override
    public PDRectangle getBBox() {
        PDRectangle retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.BBOX);
        if (array != null) {
            retval = new PDRectangle(array);
        }
        return retval;
    }

    public void setBBox(PDRectangle bbox) {
        if (bbox == null) {
            this.getCOSStream().removeItem(COSName.BBOX);
        } else {
            this.getCOSStream().setItem(COSName.BBOX, (COSBase)bbox.getCOSArray());
        }
    }

    @Override
    public Matrix getMatrix() {
        Matrix retval = null;
        COSArray array = (COSArray)this.getCOSStream().getDictionaryObject(COSName.MATRIX);
        if (array != null) {
            retval = new Matrix();
            retval.setValue(0, 0, ((COSNumber)array.get(0)).floatValue());
            retval.setValue(0, 1, ((COSNumber)array.get(1)).floatValue());
            retval.setValue(1, 0, ((COSNumber)array.get(2)).floatValue());
            retval.setValue(1, 1, ((COSNumber)array.get(3)).floatValue());
            retval.setValue(2, 0, ((COSNumber)array.get(4)).floatValue());
            retval.setValue(2, 1, ((COSNumber)array.get(5)).floatValue());
        } else {
            retval = new Matrix();
        }
        return retval;
    }

    public void setMatrix(AffineTransform transform) {
        COSArray matrix = new COSArray();
        double[] values = new double[6];
        transform.getMatrix(values);
        for (double v : values) {
            matrix.add(new COSFloat((float)v));
        }
        this.getCOSStream().setItem(COSName.MATRIX, (COSBase)matrix);
    }

    public int getStructParents() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENTS, 0);
    }

    public void setStructParents(int structParent) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENTS, structParent);
    }
}

