/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public class PDDeviceNProcess {
    private COSDictionary dictionary;

    public PDDeviceNProcess() {
        this.dictionary = new COSDictionary();
    }

    public PDDeviceNProcess(COSDictionary attributes) {
        this.dictionary = attributes;
    }

    public COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cosColorSpace = this.dictionary.getDictionaryObject(COSName.COLORSPACE);
        if (cosColorSpace == null) {
            return null;
        }
        return PDColorSpace.create(cosColorSpace);
    }

    public List<String> getComponents() {
        ArrayList<String> components = new ArrayList<String>();
        COSArray cosComponents = (COSArray)this.dictionary.getDictionaryObject(COSName.COMPONENTS);
        if (cosComponents == null) {
            return components;
        }
        for (COSBase name : cosComponents) {
            components.add(((COSName)name).getName());
        }
        return components;
    }

    public String toString() {
        String str = "Process{";
        try {
            str = str + this.getColorSpace();
            for (String c : this.getComponents()) {
                str = str + " \"" + c + "\"";
            }
        }
        catch (IOException e) {
            str = str + "ERROR";
        }
        str = str + "}";
        return str;
    }
}

