/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;
import org.apache.pdfbox.util.Matrix;

public class PDCalRGB
extends PDCIEBasedColorSpace {
    protected COSDictionary dictionary;
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)this);

    public PDCalRGB() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.CALRGB);
        this.array.add(this.dictionary);
    }

    public PDCalRGB(COSArray rgb) {
        this.array = rgb;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    @Override
    public String getName() {
        return COSName.CALRGB.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        return new float[]{value[0], value[1], value[2]};
    }

    public final PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.WHITE_POINT);
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.WHITE_POINT, (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public final PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.BLACK_POINT);
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.BLACK_POINT, (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public final PDGamma getGamma() {
        COSArray gamma = (COSArray)this.dictionary.getDictionaryObject(COSName.GAMMA);
        if (gamma == null) {
            gamma = new COSArray();
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            gamma.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.GAMMA, (COSBase)gamma);
        }
        return new PDGamma(gamma);
    }

    public final Matrix getGammaMatrix() {
        COSArray matrix = (COSArray)this.dictionary.getDictionaryObject(COSName.MATRIX);
        if (matrix == null) {
            return new Matrix();
        }
        return new Matrix(matrix);
    }

    public final void setWhitepoint(PDTristimulus whitepoint) {
        COSBase wpArray = whitepoint.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.WHITE_POINT, wpArray);
        }
    }

    public final void setBlackPoint(PDTristimulus blackpoint) {
        COSBase bpArray = null;
        if (blackpoint != null) {
            bpArray = blackpoint.getCOSObject();
        }
        this.dictionary.setItem(COSName.BLACK_POINT, bpArray);
    }

    public final void setGamma(PDGamma gamma) {
        COSArray array = null;
        if (gamma != null) {
            array = gamma.getCOSArray();
        }
        this.dictionary.setItem(COSName.GAMMA, (COSBase)array);
    }

    public final void setGammaMatrix(Matrix matrix) {
        COSArray matrixArray = null;
        if (matrix != null) {
            matrixArray = matrix.toCOSArray();
        }
        this.dictionary.setItem(COSName.MATRIX, (COSBase)matrixArray);
    }
}

