/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

class PDTrueTypeFontEmbedder {
    private final Encoding fontEncoding;
    private final TrueTypeFont ttf;
    private final PDFontDescriptor fontDescriptor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PDTrueTypeFontEmbedder(PDDocument document, COSDictionary dict, InputStream ttfStream) throws IOException {
        PDFontDescriptor fd;
        dict.setItem(COSName.SUBTYPE, (COSBase)COSName.TRUE_TYPE);
        PDStream stream = new PDStream(document, ttfStream, false);
        stream.getStream().setInt(COSName.LENGTH1, stream.getByteArray().length);
        stream.addCompression();
        WinAnsiEncoding encoding = new WinAnsiEncoding();
        this.fontEncoding = encoding;
        dict.setItem(COSName.ENCODING, encoding.getCOSObject());
        InputStream stream2 = null;
        try {
            stream2 = stream.createInputStream();
            this.ttf = new TTFParser().parse(stream2);
            fd = this.createFontDescriptor(dict, this.ttf);
        }
        finally {
            IOUtils.closeQuietly(stream2);
        }
        fd.setFontFile2(stream);
        dict.setItem(COSName.FONT_DESC, (COSObjectable)fd);
        this.fontDescriptor = fd;
    }

    private PDFontDescriptor createFontDescriptor(COSDictionary dict, TrueTypeFont ttf) throws IOException {
        PDFontDescriptor fd = new PDFontDescriptor();
        NamingTable naming = ttf.getNaming();
        List records = naming.getNameRecords();
        for (NameRecord nr : records) {
            if (nr.getNameId() == 6) {
                dict.setName(COSName.BASE_FONT, nr.getString());
                fd.setFontName(nr.getString());
                continue;
            }
            if (nr.getNameId() != 1) continue;
            fd.setFontFamily(nr.getString());
        }
        OS2WindowsMetricsTable os2 = ttf.getOS2Windows();
        boolean isSymbolic = false;
        switch (os2.getFamilyClass()) {
            case 12: {
                isSymbolic = true;
                break;
            }
            case 10: {
                fd.setScript(true);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                fd.setSerif(true);
            }
        }
        switch (os2.getWidthClass()) {
            case 1: {
                fd.setFontStretch("UltraCondensed");
                break;
            }
            case 2: {
                fd.setFontStretch("ExtraCondensed");
                break;
            }
            case 3: {
                fd.setFontStretch("Condensed");
                break;
            }
            case 4: {
                fd.setFontStretch("SemiCondensed");
                break;
            }
            case 5: {
                fd.setFontStretch("Normal");
                break;
            }
            case 6: {
                fd.setFontStretch("SemiExpanded");
                break;
            }
            case 7: {
                fd.setFontStretch("Expanded");
                break;
            }
            case 8: {
                fd.setFontStretch("ExtraExpanded");
                break;
            }
            case 9: {
                fd.setFontStretch("UltraExpanded");
            }
        }
        fd.setFontWeight(os2.getWeightClass());
        fd.setSymbolic(isSymbolic);
        fd.setNonSymbolic(!isSymbolic);
        HeaderTable header = ttf.getHeader();
        PDRectangle rect = new PDRectangle();
        float scaling = 1000.0f / (float)header.getUnitsPerEm();
        rect.setLowerLeftX((float)header.getXMin() * scaling);
        rect.setLowerLeftY((float)header.getYMin() * scaling);
        rect.setUpperRightX((float)header.getXMax() * scaling);
        rect.setUpperRightY((float)header.getYMax() * scaling);
        fd.setFontBoundingBox(rect);
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        fd.setAscent((float)hHeader.getAscender() * scaling);
        fd.setDescent((float)hHeader.getDescender() * scaling);
        GlyphTable glyphTable = ttf.getGlyph();
        GlyphData[] glyphs = glyphTable.getGlyphs();
        PostScriptTable ps = ttf.getPostScript();
        fd.setFixedPitch(ps.getIsFixedPitch() > 0L);
        fd.setItalicAngle(ps.getItalicAngle());
        String[] names = ps.getGlyphNames();
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i].equals("H")) {
                    fd.setCapHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
                }
                if (!names[i].equals("x")) continue;
                fd.setXHeight(glyphs[i].getBoundingBox().getUpperRightY() / scaling);
            }
        }
        fd.setStemV(fd.getFontBoundingBox().getWidth() * 0.13f);
        CmapTable cmapTable = ttf.getCmap();
        CmapSubtable uniMap = cmapTable.getSubtable(0, 4);
        if (uniMap == null) {
            uniMap = cmapTable.getSubtable(0, 3);
        }
        if (uniMap == null) {
            uniMap = cmapTable.getSubtable(3, 1);
        }
        if (uniMap == null) {
            uniMap = cmapTable.getSubtable(3, 0);
        }
        if (uniMap == null) {
            throw new IllegalArgumentException("ttf: no suitable cmap for font '" + ttf.getNaming().getFontFamily() + "', found: " + Arrays.toString(cmapTable.getCmaps()));
        }
        if (this.getFontEncoding() == null) {
            return fd;
        }
        Map<Integer, String> codeToName = this.getFontEncoding().getCodeToNameMap();
        int firstChar = Collections.min(codeToName.keySet());
        int lastChar = Collections.max(codeToName.keySet());
        HorizontalMetricsTable hMet = ttf.getHorizontalMetrics();
        int[] widthValues = hMet.getAdvanceWidth();
        boolean isMonospaced = fd.isFixedPitch() || widthValues.length == 1;
        int nWidths = lastChar - firstChar + 1;
        ArrayList<Integer> widths = new ArrayList<Integer>(nWidths);
        int defaultWidth = Math.round((float)widthValues[0] * scaling);
        for (int i = 0; i < nWidths; ++i) {
            widths.add(defaultWidth);
        }
        for (Map.Entry<Integer, String> e : codeToName.entrySet()) {
            String c;
            int charCode;
            int gid;
            String name = e.getValue();
            if (name.equals(".notdef") || (gid = uniMap.getGlyphId(charCode = (c = GlyphList.getAdobeGlyphList().toUnicode(name)).codePointAt(0))) == 0) continue;
            if (isMonospaced) {
                widths.set(e.getKey() - firstChar, defaultWidth);
                continue;
            }
            widths.set(e.getKey() - firstChar, Math.round((float)widthValues[gid] * scaling));
        }
        dict.setItem(COSName.WIDTHS, (COSBase)COSArrayList.converterToCOSArray(widths));
        dict.setInt(COSName.FIRST_CHAR, firstChar);
        dict.setInt(COSName.LAST_CHAR, lastChar);
        return fd;
    }

    public Encoding getFontEncoding() {
        return this.fontEncoding;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    public PDFontDescriptor getFontDescriptor() {
        return this.fontDescriptor;
    }
}

