/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.ExternalFonts;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.StandardEncoding;
import org.apache.pdfbox.util.Matrix;

public class PDCIDFontType2
extends PDCIDFont {
    private static final Log LOG = LogFactory.getLog(PDCIDFontType2.class);
    private final TrueTypeFont ttf;
    private final int[] cid2gid;
    private final boolean hasIdentityCid2Gid;
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private Matrix fontMatrix;

    public PDCIDFontType2(COSDictionary fontDictionary, PDType0Font parent) throws IOException {
        super(fontDictionary, parent);
        PDFontDescriptor fd = this.getFontDescriptor();
        PDStream ff2Stream = fd.getFontFile2();
        PDStream ff3Stream = fd.getFontFile3();
        TrueTypeFont ttfFont = null;
        boolean fontIsDamaged = false;
        if (ff2Stream != null) {
            try {
                TTFParser ttfParser = new TTFParser(true);
                ttfFont = ttfParser.parse(ff2Stream.createInputStream());
            }
            catch (NullPointerException e) {
                LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                fontIsDamaged = true;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                fontIsDamaged = true;
            }
        } else if (ff3Stream != null) {
            try {
                OTFParser otfParser = new OTFParser(true);
                OpenTypeFont otf = otfParser.parse(ff3Stream.createInputStream());
                ttfFont = otf;
                if (otf.isPostScript()) {
                    throw new IOException("Not implemented: OpenType font with CFF table " + this.getBaseFont());
                }
                if (otf.hasLayoutTables()) {
                    LOG.error((Object)("OpenType Layout tables used in font " + this.getBaseFont() + " are not implemented in PDFBox and will be ignored"));
                }
            }
            catch (NullPointerException e) {
                fontIsDamaged = true;
                LOG.warn((Object)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
            }
            catch (IOException e) {
                fontIsDamaged = true;
                LOG.warn((Object)("Could not read embedded OTF for font " + this.getBaseFont()), (Throwable)e);
            }
        }
        this.isEmbedded = ttfFont != null;
        this.isDamaged = fontIsDamaged;
        if (ttfFont == null) {
            TrueTypeFont ttfSubstitute = ExternalFonts.getTrueTypeFont(this.getBaseFont());
            if (ttfSubstitute != null) {
                ttfFont = ttfSubstitute;
            } else {
                LOG.warn((Object)("Using fallback font for " + this.getBaseFont()));
                ttfFont = ExternalFonts.getTrueTypeFallbackFont(this.getFontDescriptor());
            }
        }
        this.ttf = ttfFont;
        this.cid2gid = this.readCIDToGIDMap();
        COSBase map = this.dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        this.hasIdentityCid2Gid = map instanceof COSName && ((COSName)map).getName().equals("Identity");
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            this.fontMatrix = new Matrix(0.001f, 0.0f, 0.0f, 0.001f, 0.0f, 0.0f);
        }
        return this.fontMatrix;
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        return this.ttf.getFontBBox();
    }

    private int[] readCIDToGIDMap() {
        int[] cid2gid = null;
        COSBase map = this.dict.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            try {
                InputStream is = stream.getUnfilteredStream();
                byte[] mapAsBytes = IOUtils.toByteArray(is);
                IOUtils.closeQuietly(is);
                int numberOfInts = mapAsBytes.length / 2;
                cid2gid = new int[numberOfInts];
                int offset = 0;
                for (int index = 0; index < numberOfInts; ++index) {
                    int gid;
                    cid2gid[index] = gid = (mapAsBytes[offset] & 0xFF) << 8 | mapAsBytes[offset + 1] & 0xFF;
                    offset += 2;
                }
            }
            catch (IOException exception) {
                LOG.error((Object)"Can't read the CIDToGIDMap", (Throwable)exception);
            }
        }
        return cid2gid;
    }

    @Override
    public int codeToCID(int code) {
        CMap cMap = this.parent.getCMap();
        if (!cMap.hasCIDMappings() && cMap.hasUnicodeMappings()) {
            return cMap.toUnicode(code).codePointAt(0);
        }
        return cMap.toCID(code);
    }

    @Override
    public int codeToGID(int code) throws IOException {
        if (!this.isEmbedded) {
            String unicode;
            CmapSubtable cmap = this.getUnicodeCmap(this.ttf.getCmap());
            if (this.cid2gid != null || this.hasIdentityCid2Gid) {
                int cid = this.codeToCID(code);
                if (this.hasIdentityCid2Gid) {
                    return cid;
                }
                return this.cid2gid[cid];
            }
            if (!this.parent.isSymbolic()) {
                String name = null;
                if (name == null) {
                    name = StandardEncoding.INSTANCE.getName(code);
                }
                unicode = GlyphList.getAdobeGlyphList().toUnicode(name);
            } else {
                int cid = this.codeToCID(code);
                unicode = this.parent.toUnicode(cid);
            }
            if (unicode == null) {
                return 0;
            }
            if (unicode.length() > 1) {
                LOG.warn((Object)"trying to map a multi-byte character using 'cmap', result will be poor");
            }
            return cmap.getGlyphId(unicode.codePointAt(0));
        }
        int cid = this.codeToCID(code);
        if (this.cid2gid != null) {
            if (cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return 0;
        }
        if (cid < this.ttf.getNumberOfGlyphs()) {
            return cid;
        }
        return 0;
    }

    private CmapSubtable getUnicodeCmap(CmapTable cmapTable) {
        CmapSubtable cmap = cmapTable.getSubtable(0, 4);
        if (cmap == null) {
            cmap = cmapTable.getSubtable(0, 3);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 1);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 0);
        }
        if (cmap == null) {
            LOG.warn((Object)("Used fallback cmap for font " + this.getBaseFont()));
            cmap = cmapTable.getCmaps()[0];
        }
        return cmap;
    }

    @Override
    public float getHeight(int code) throws IOException {
        return (this.ttf.getHorizontalHeader().getAscender() + -this.ttf.getHorizontalHeader().getDescender()) / this.ttf.getUnitsPerEm();
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        int width = this.ttf.getAdvanceWidth(gid);
        int unitsPerEM = this.ttf.getUnitsPerEm();
        if (unitsPerEM != 1000) {
            width = (int)((float)width * (1000.0f / (float)unitsPerEM));
        }
        return width;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }
}

