/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.fontbox.util.autodetect.FontFileFinder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.FontProvider;

final class FileSystemFontProvider
implements FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final Map<String, File> ttfFontFiles = new HashMap<String, File>();
    private final Map<String, File> cffFontFiles = new HashMap<String, File>();
    private final Map<String, File> type1FontFiles = new HashMap<String, File>();
    private final Map<String, TrueTypeFont> ttfFonts = new HashMap<String, TrueTypeFont>();
    private final Map<String, CFFFont> cffFonts = new HashMap<String, CFFFont>();
    private final Map<String, Type1Font> type1Fonts = new HashMap<String, Type1Font>();

    FileSystemFontProvider() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Will search the local system for fonts");
        }
        int count = 0;
        FontFileFinder fontFileFinder = new FontFileFinder();
        List fonts = fontFileFinder.find();
        for (URI font : fonts) {
            ++count;
            File fontFile = new File(font);
            try {
                if (fontFile.getPath().toLowerCase().endsWith(".ttf") || fontFile.getPath().toLowerCase().endsWith(".otf")) {
                    this.addOpenTypeFont(fontFile);
                    continue;
                }
                if (!fontFile.getPath().toLowerCase().endsWith(".pfb")) continue;
                this.addType1Font(fontFile);
            }
            catch (IOException e) {
                LOG.error((Object)("Error parsing font " + fontFile.getPath()), (Throwable)e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + count + " fonts on the local system"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOpenTypeFont(File otfFile) throws IOException {
        TTFParser ttfParser = new TTFParser(false, true);
        TrueTypeFont ttf = null;
        try {
            ttf = ttfParser.parse(otfFile);
        }
        catch (NullPointerException e) {
            LOG.error((Object)("Could not load font file: " + otfFile), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not load font file: " + otfFile), (Throwable)e);
        }
        try {
            NamingTable nameTable = ttf.getNaming();
            if (nameTable == null) {
                LOG.warn((Object)("Missing 'name' table in font " + otfFile));
            } else if (nameTable.getPostScriptName() != null) {
                String format;
                String psName = nameTable.getPostScriptName();
                if (ttf.getTableMap().get("CFF ") != null) {
                    format = "OTF";
                    this.cffFontFiles.put(psName, otfFile);
                } else {
                    format = "TTF";
                    this.ttfFontFiles.put(psName, otfFile);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(format + ": '" + psName + "' / '" + nameTable.getFontFamily() + "' / '" + nameTable.getFontSubFamily() + "'"));
                }
            } else {
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + otfFile));
            }
        }
        finally {
            if (ttf != null) {
                ttf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addType1Font(File pfbFile) throws IOException {
        FileInputStream input = new FileInputStream(pfbFile);
        try {
            Type1Font type1 = Type1Font.createWithPFB((InputStream)input);
            String psName = type1.getFontName();
            this.type1FontFiles.put(psName, pfbFile);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + psName + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        finally {
            ((InputStream)input).close();
        }
    }

    @Override
    public synchronized TrueTypeFont getTrueTypeFont(String postScriptName) {
        TrueTypeFont ttf = this.ttfFonts.get(postScriptName);
        if (ttf != null) {
            return ttf;
        }
        File file = this.ttfFontFiles.get(postScriptName);
        if (file != null) {
            TTFParser ttfParser = new TTFParser(false, true);
            try {
                ttf = ttfParser.parse(file);
                this.ttfFonts.put(postScriptName, ttf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (NullPointerException e) {
                LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CFFFont getCFFFont(String postScriptName) {
        CFFFont cff = this.cffFonts.get(postScriptName);
        if (cff != null) {
            return cff;
        }
        File file = this.cffFontFiles.get(postScriptName);
        if (file != null) {
            CFFFont cFFFont;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                byte[] bytes = IOUtils.toByteArray(input);
                CFFParser cffParser = new CFFParser();
                cff = (CFFFont)cffParser.parse(bytes).get(0);
                this.cffFonts.put(postScriptName, cff);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                cFFFont = cff;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return cFFFont;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Type1Font getType1Font(String postScriptName) {
        Type1Font type1 = this.type1Fonts.get(postScriptName);
        if (type1 != null) {
            return type1;
        }
        File file = this.type1FontFiles.get(postScriptName);
        if (file != null) {
            Type1Font type1Font;
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                type1 = Type1Font.createWithPFB((InputStream)input);
                this.type1Fonts.put(postScriptName, type1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                type1Font = type1;
            }
            catch (IOException e) {
                try {
                    LOG.error((Object)("Could not load font file: " + file), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
                IOUtils.closeQuietly(input);
            }
            IOUtils.closeQuietly(input);
            return type1Font;
        }
        return null;
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, File> entry : this.ttfFontFiles.entrySet()) {
            sb.append("TTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.cffFontFiles.entrySet()) {
            sb.append("OTF: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        for (Map.Entry<String, File> entry : this.type1FontFiles.entrySet()) {
            sb.append("PFB: ");
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue().getPath());
            sb.append('\n');
        }
        return sb.toString();
    }
}

