/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.MessageDigests;
import org.apache.pdfbox.pdmodel.encryption.PDCryptFilterDictionary;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.RC4Cipher;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public final class StandardSecurityHandler
extends SecurityHandler {
    private static final Log LOG = LogFactory.getLog(StandardSecurityHandler.class);
    public static final String FILTER = "Standard";
    public static final Class<?> PROTECTION_POLICY_CLASS = StandardProtectionPolicy.class;
    public static final byte[] ENCRYPT_PADDING = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    private static final String[] HASHES_2B = new String[]{"SHA-256", "SHA-384", "SHA-512"};
    private static final int DEFAULT_VERSION = 1;
    private static final int DEFAULT_REVISION = 3;
    private int revision = 3;
    private StandardProtectionPolicy policy;
    private RC4Cipher rc4 = new RC4Cipher();

    public StandardSecurityHandler() {
    }

    public StandardSecurityHandler(StandardProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    private int computeVersionNumber() {
        if (this.keyLength == 40) {
            return 1;
        }
        if (this.keyLength == 256) {
            return 5;
        }
        return 2;
    }

    private int computeRevisionNumber() {
        if (this.version < 2 && !this.policy.getPermissions().hasAnyRevision3PermissionSet()) {
            return 2;
        }
        if (this.version == 5) {
            return 6;
        }
        if (this.version == 2 || this.version == 3 || this.policy.getPermissions().hasAnyRevision3PermissionSet()) {
            return 3;
        }
        return 4;
    }

    @Override
    public void decryptDocument(PDDocument doc, DecryptionMaterial decryptionMaterial) throws IOException {
        this.document = doc;
        PDEncryption dictionary = this.document.getEncryption();
        COSArray documentIDArray = this.document.getDocument().getDocumentID();
        this.prepareForDecryption(dictionary, documentIDArray, decryptionMaterial);
        this.proceedDecryption();
    }

    @Override
    public void prepareForDecryption(PDEncryption encryption, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws IOException {
        COSName cryptFilterMethod;
        PDCryptFilterDictionary stdCryptFilterDictionary;
        byte[] documentIDBytes;
        int dicLength;
        if (!(decryptionMaterial instanceof StandardDecryptionMaterial)) {
            throw new IOException("Decryption material is not compatible with the document");
        }
        this.decryptMetadata = encryption.isEncryptMetaData();
        StandardDecryptionMaterial material = (StandardDecryptionMaterial)decryptionMaterial;
        String password = material.getPassword();
        if (password == null) {
            password = "";
        }
        int dicPermissions = encryption.getPermissions();
        int dicRevision = encryption.getRevision();
        int n = dicLength = encryption.getVersion() == 1 ? 5 : encryption.getLength() / 8;
        if (documentIDArray != null && documentIDArray.size() >= 1) {
            COSString id = (COSString)documentIDArray.getObject(0);
            documentIDBytes = id.getBytes();
        } else {
            documentIDBytes = new byte[]{};
        }
        boolean encryptMetadata = encryption.isEncryptMetaData();
        byte[] userKey = encryption.getUserKey();
        byte[] ownerKey = encryption.getOwnerKey();
        byte[] ue = null;
        byte[] oe = null;
        String passwordCharset = "ISO-8859-1";
        if (dicRevision == 6 || dicRevision == 5) {
            passwordCharset = "UTF-8";
            ue = encryption.getUserEncryptionKey();
            oe = encryption.getOwnerEncryptionKey();
        }
        if (this.isOwnerPassword(password.getBytes(passwordCharset), userKey, ownerKey, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata)) {
            this.currentAccessPermission = AccessPermission.getOwnerAccessPermission();
            byte[] computedPassword = dicRevision == 6 || dicRevision == 5 ? password.getBytes(passwordCharset) : this.getUserPassword(password.getBytes(passwordCharset), ownerKey, dicRevision, dicLength);
            this.encryptionKey = this.computeEncryptedKey(computedPassword, ownerKey, userKey, oe, ue, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata, true);
        } else if (this.isUserPassword(password.getBytes(passwordCharset), userKey, ownerKey, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata)) {
            this.currentAccessPermission = new AccessPermission(dicPermissions);
            this.encryptionKey = this.computeEncryptedKey(password.getBytes(passwordCharset), ownerKey, userKey, oe, ue, dicPermissions, documentIDBytes, dicRevision, dicLength, encryptMetadata, false);
        } else {
            throw new IOException("Cannot decrypt PDF, the password is incorrect");
        }
        if (dicRevision == 6 || dicRevision == 5) {
            try {
                int permsP;
                Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
                cipher.init(2, new SecretKeySpec(this.encryptionKey, "AES"));
                byte[] perms = cipher.doFinal(encryption.getPerms());
                if (perms[9] != 97 || perms[10] != 100 || perms[11] != 98) {
                    LOG.warn((Object)"Verification of permissions failed (constant)");
                }
                if ((permsP = perms[0] & 0xFF | perms[1] & 0xFF00 | perms[2] & 0xFF0000 | perms[3] & 0xFF000000) != dicPermissions) {
                    LOG.warn((Object)("Verification of permissions failed (" + permsP + " != " + dicPermissions + ")"));
                }
                if (encryptMetadata && perms[8] != 84 || !encryptMetadata && perms[8] != 70) {
                    LOG.warn((Object)"Verification of permissions failed (EncryptMetadata)");
                }
            }
            catch (GeneralSecurityException e) {
                StandardSecurityHandler.logIfStrongEncryptionMissing();
                throw new IOException(e);
            }
        }
        if ((stdCryptFilterDictionary = encryption.getStdCryptFilterDictionary()) != null && (cryptFilterMethod = stdCryptFilterDictionary.getCryptFilterMethod()) != null) {
            this.setAES("AESV2".equalsIgnoreCase(cryptFilterMethod.getName()) || "AESV3".equalsIgnoreCase(cryptFilterMethod.getName()));
        }
    }

    @Override
    public void prepareDocumentForEncryption(PDDocument doc) throws IOException {
        this.document = doc;
        PDEncryption encryptionDictionary = this.document.getEncryption();
        if (encryptionDictionary == null) {
            encryptionDictionary = new PDEncryption();
        }
        this.version = this.computeVersionNumber();
        this.revision = this.computeRevisionNumber();
        encryptionDictionary.setFilter(FILTER);
        encryptionDictionary.setVersion(this.version);
        encryptionDictionary.setRevision(this.revision);
        encryptionDictionary.setLength(this.keyLength);
        String ownerPassword = this.policy.getOwnerPassword();
        String userPassword = this.policy.getUserPassword();
        if (ownerPassword == null) {
            ownerPassword = "";
        }
        if (userPassword == null) {
            userPassword = "";
        }
        if (ownerPassword.isEmpty()) {
            ownerPassword = userPassword;
        }
        int permissionInt = this.policy.getPermissions().getPermissionBytes();
        encryptionDictionary.setPermissions(permissionInt);
        int length = this.keyLength / 8;
        if (this.revision == 6) {
            try {
                SecureRandom rnd = new SecureRandom();
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                this.encryptionKey = new byte[32];
                rnd.nextBytes(this.encryptionKey);
                byte[] userPasswordBytes = StandardSecurityHandler.truncate127(userPassword.getBytes("UTF-8"));
                byte[] userValidationSalt = new byte[8];
                byte[] userKeySalt = new byte[8];
                rnd.nextBytes(userValidationSalt);
                rnd.nextBytes(userKeySalt);
                byte[] hashU = StandardSecurityHandler.computeHash2B(StandardSecurityHandler.concat(userPasswordBytes, userValidationSalt), userPasswordBytes, null);
                byte[] u = StandardSecurityHandler.concat(hashU, userValidationSalt, userKeySalt);
                byte[] hashUE = StandardSecurityHandler.computeHash2B(StandardSecurityHandler.concat(userPasswordBytes, userKeySalt), userPasswordBytes, null);
                cipher.init(1, (Key)new SecretKeySpec(hashUE, "AES"), new IvParameterSpec(new byte[16]));
                byte[] ue = cipher.doFinal(this.encryptionKey);
                byte[] ownerPasswordBytes = StandardSecurityHandler.truncate127(ownerPassword.getBytes("UTF-8"));
                byte[] ownerValidationSalt = new byte[8];
                byte[] ownerKeySalt = new byte[8];
                rnd.nextBytes(ownerValidationSalt);
                rnd.nextBytes(ownerKeySalt);
                byte[] hashO = StandardSecurityHandler.computeHash2B(StandardSecurityHandler.concat(ownerPasswordBytes, ownerValidationSalt, u), ownerPasswordBytes, u);
                byte[] o = StandardSecurityHandler.concat(hashO, ownerValidationSalt, ownerKeySalt);
                byte[] hashOE = StandardSecurityHandler.computeHash2B(StandardSecurityHandler.concat(ownerPasswordBytes, ownerKeySalt, u), ownerPasswordBytes, u);
                cipher.init(1, (Key)new SecretKeySpec(hashOE, "AES"), new IvParameterSpec(new byte[16]));
                byte[] oe = cipher.doFinal(this.encryptionKey);
                encryptionDictionary.setUserKey(u);
                encryptionDictionary.setUserEncryptionKey(ue);
                encryptionDictionary.setOwnerKey(o);
                encryptionDictionary.setOwnerEncryptionKey(oe);
                PDCryptFilterDictionary cryptFilterDictionary = new PDCryptFilterDictionary();
                cryptFilterDictionary.setCryptFilterMethod(COSName.AESV3);
                cryptFilterDictionary.setLength(this.keyLength);
                encryptionDictionary.setStdCryptFilterDictionary(cryptFilterDictionary);
                encryptionDictionary.setStreamFilterName(COSName.STD_CF);
                encryptionDictionary.setStringFilterName(COSName.STD_CF);
                this.setAES(true);
                byte[] perms = new byte[16];
                perms[0] = (byte)permissionInt;
                perms[1] = (byte)(permissionInt >>> 8);
                perms[2] = (byte)(permissionInt >>> 16);
                perms[3] = (byte)(permissionInt >>> 24);
                perms[7] = -1;
                perms[6] = -1;
                perms[5] = -1;
                perms[4] = -1;
                perms[8] = 84;
                perms[9] = 97;
                perms[10] = 100;
                perms[11] = 98;
                for (int i = 12; i <= 15; ++i) {
                    perms[i] = (byte)rnd.nextInt();
                }
                cipher.init(1, (Key)new SecretKeySpec(this.encryptionKey, "AES"), new IvParameterSpec(new byte[16]));
                byte[] permsEnc = cipher.doFinal(perms);
                encryptionDictionary.setPerms(permsEnc);
            }
            catch (GeneralSecurityException e) {
                StandardSecurityHandler.logIfStrongEncryptionMissing();
                throw new IOException(e);
            }
        } else {
            COSArray idArray = this.document.getDocument().getDocumentID();
            if (idArray == null || idArray.size() < 2) {
                MessageDigest md = MessageDigests.getMD5();
                BigInteger time = BigInteger.valueOf(System.currentTimeMillis());
                md.update(time.toByteArray());
                md.update(ownerPassword.getBytes("ISO-8859-1"));
                md.update(userPassword.getBytes("ISO-8859-1"));
                md.update(this.document.getDocument().toString().getBytes());
                byte[] id = md.digest(this.toString().getBytes("ISO-8859-1"));
                COSString idString = new COSString();
                idString.append(id);
                idArray = new COSArray();
                idArray.add(idString);
                idArray.add(idString);
                this.document.getDocument().setDocumentID(idArray);
            }
            COSString id = (COSString)idArray.getObject(0);
            byte[] ownerBytes = this.computeOwnerPassword(ownerPassword.getBytes("ISO-8859-1"), userPassword.getBytes("ISO-8859-1"), this.revision, length);
            byte[] userBytes = this.computeUserPassword(userPassword.getBytes("ISO-8859-1"), ownerBytes, permissionInt, id.getBytes(), this.revision, length, true);
            this.encryptionKey = this.computeEncryptedKey(userPassword.getBytes("ISO-8859-1"), ownerBytes, null, null, null, permissionInt, id.getBytes(), this.revision, length, true, false);
            encryptionDictionary.setOwnerKey(ownerBytes);
            encryptionDictionary.setUserKey(userBytes);
        }
        this.document.setEncryptionDictionary(encryptionDictionary);
        this.document.getDocument().setEncryptionDictionary(encryptionDictionary.getCOSDictionary());
    }

    public boolean isOwnerPassword(byte[] ownerPassword, byte[] user, byte[] owner, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws IOException {
        if (encRevision == 6 || encRevision == 5) {
            ownerPassword = StandardSecurityHandler.truncate127(ownerPassword);
            byte[] oHash = new byte[32];
            byte[] oValidationSalt = new byte[8];
            System.arraycopy(owner, 0, oHash, 0, 32);
            System.arraycopy(owner, 32, oValidationSalt, 0, 8);
            byte[] hash = encRevision == 5 ? StandardSecurityHandler.computeSHA256(ownerPassword, oValidationSalt, user) : this.computeHash2A(ownerPassword, oValidationSalt, user);
            return Arrays.equals(hash, oHash);
        }
        byte[] userPassword = this.getUserPassword(ownerPassword, owner, encRevision, length);
        return this.isUserPassword(userPassword, user, owner, permissions, id, encRevision, length, encryptMetadata);
    }

    public byte[] getUserPassword(byte[] ownerPassword, byte[] owner, int encRevision, int length) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] rc4Key = this.computeRC4key(ownerPassword, encRevision, length);
        if (encRevision == 2) {
            this.rc4.setKey(rc4Key);
            this.rc4.write(owner, (OutputStream)result);
        } else if (encRevision == 3 || encRevision == 4) {
            byte[] iterationKey = new byte[rc4Key.length];
            byte[] otemp = new byte[owner.length];
            System.arraycopy(owner, 0, otemp, 0, owner.length);
            this.rc4.write(owner, (OutputStream)result);
            for (int i = 19; i >= 0; --i) {
                System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                for (int j = 0; j < iterationKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                }
                this.rc4.setKey(iterationKey);
                result.reset();
                this.rc4.write(otemp, (OutputStream)result);
                otemp = result.toByteArray();
            }
        }
        return result.toByteArray();
    }

    public byte[] computeEncryptedKey(byte[] password, byte[] o, byte[] u, byte[] oe, byte[] ue, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata, boolean isOwnerPassword) throws IOException {
        byte[] result = new byte[length];
        if (encRevision == 6 || encRevision == 5) {
            byte[] fileKeyEnc;
            byte[] hash;
            if (isOwnerPassword) {
                byte[] oKeySalt = new byte[8];
                System.arraycopy(o, 40, oKeySalt, 0, 8);
                hash = encRevision == 5 ? StandardSecurityHandler.computeSHA256(password, oKeySalt, u) : this.computeHash2A(password, oKeySalt, u);
                fileKeyEnc = oe;
            } else {
                byte[] uKeySalt = new byte[8];
                System.arraycopy(u, 40, uKeySalt, 0, 8);
                hash = encRevision == 5 ? StandardSecurityHandler.computeSHA256(password, uKeySalt, null) : this.computeHash2A(password, uKeySalt, null);
                fileKeyEnc = ue;
            }
            try {
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)new SecretKeySpec(hash, "AES"), new IvParameterSpec(new byte[16]));
                result = cipher.doFinal(fileKeyEnc);
            }
            catch (GeneralSecurityException e) {
                StandardSecurityHandler.logIfStrongEncryptionMissing();
                throw new IOException(e);
            }
        } else {
            byte[] padded = this.truncateOrPad(password);
            MessageDigest md = MessageDigests.getMD5();
            md.update(padded);
            md.update(o);
            md.update((byte)permissions);
            md.update((byte)(permissions >>> 8));
            md.update((byte)(permissions >>> 16));
            md.update((byte)(permissions >>> 24));
            md.update(id);
            if (encRevision == 4 && !encryptMetadata) {
                md.update(new byte[]{-1, -1, -1, -1});
            }
            byte[] digest = md.digest();
            if (encRevision == 3 || encRevision == 4) {
                for (int i = 0; i < 50; ++i) {
                    md.reset();
                    md.update(digest, 0, length);
                    digest = md.digest();
                }
            }
            System.arraycopy(digest, 0, result, 0, length);
        }
        return result;
    }

    public byte[] computeUserPassword(byte[] password, byte[] owner, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] encryptionKey = this.computeEncryptedKey(password, owner, null, null, null, permissions, id, encRevision, length, encryptMetadata, true);
        if (encRevision == 2) {
            this.rc4.setKey(encryptionKey);
            this.rc4.write(ENCRYPT_PADDING, (OutputStream)result);
        } else if (encRevision == 3 || encRevision == 4) {
            MessageDigest md = MessageDigests.getMD5();
            md.update(ENCRYPT_PADDING);
            md.update(id);
            result.write(md.digest());
            byte[] iterationKey = new byte[encryptionKey.length];
            for (int i = 0; i < 20; ++i) {
                System.arraycopy(encryptionKey, 0, iterationKey, 0, iterationKey.length);
                for (int j = 0; j < iterationKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ i);
                }
                this.rc4.setKey(iterationKey);
                ByteArrayInputStream input = new ByteArrayInputStream(result.toByteArray());
                result.reset();
                this.rc4.write(input, (OutputStream)result);
            }
            byte[] finalResult = new byte[32];
            System.arraycopy(result.toByteArray(), 0, finalResult, 0, 16);
            System.arraycopy(ENCRYPT_PADDING, 0, finalResult, 16, 16);
            result.reset();
            result.write(finalResult);
        }
        return result.toByteArray();
    }

    public byte[] computeOwnerPassword(byte[] ownerPassword, byte[] userPassword, int encRevision, int length) throws IOException {
        if (encRevision == 2 && length != 5) {
            throw new IOException("Expected length=5 actual=" + length);
        }
        byte[] rc4Key = this.computeRC4key(ownerPassword, encRevision, length);
        byte[] paddedUser = this.truncateOrPad(userPassword);
        this.rc4.setKey(rc4Key);
        ByteArrayOutputStream encrypted = new ByteArrayOutputStream();
        this.rc4.write(new ByteArrayInputStream(paddedUser), (OutputStream)encrypted);
        if (encRevision == 3 || encRevision == 4) {
            byte[] iterationKey = new byte[rc4Key.length];
            for (int i = 1; i < 20; ++i) {
                System.arraycopy(rc4Key, 0, iterationKey, 0, rc4Key.length);
                for (int j = 0; j < iterationKey.length; ++j) {
                    iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
                }
                this.rc4.setKey(iterationKey);
                ByteArrayInputStream input = new ByteArrayInputStream(encrypted.toByteArray());
                encrypted.reset();
                this.rc4.write(input, (OutputStream)encrypted);
            }
        }
        return encrypted.toByteArray();
    }

    private byte[] computeRC4key(byte[] ownerPassword, int encRevision, int length) {
        MessageDigest md = MessageDigests.getMD5();
        byte[] digest = md.digest(this.truncateOrPad(ownerPassword));
        if (encRevision == 3 || encRevision == 4) {
            for (int i = 0; i < 50; ++i) {
                md.update(digest, 0, length);
                digest = md.digest();
            }
        }
        byte[] rc4Key = new byte[length];
        System.arraycopy(digest, 0, rc4Key, 0, length);
        return rc4Key;
    }

    private byte[] truncateOrPad(byte[] password) {
        byte[] padded = new byte[ENCRYPT_PADDING.length];
        int bytesBeforePad = Math.min(password.length, padded.length);
        System.arraycopy(password, 0, padded, 0, bytesBeforePad);
        System.arraycopy(ENCRYPT_PADDING, 0, padded, bytesBeforePad, ENCRYPT_PADDING.length - bytesBeforePad);
        return padded;
    }

    public boolean isUserPassword(byte[] password, byte[] user, byte[] owner, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws IOException {
        if (encRevision == 2) {
            byte[] passwordBytes = this.computeUserPassword(password, owner, permissions, id, encRevision, length, encryptMetadata);
            return Arrays.equals(user, passwordBytes);
        }
        if (encRevision == 3 || encRevision == 4) {
            byte[] passwordBytes = this.computeUserPassword(password, owner, permissions, id, encRevision, length, encryptMetadata);
            return Arrays.equals(Arrays.copyOf(user, 16), Arrays.copyOf(passwordBytes, 16));
        }
        if (encRevision == 6 || encRevision == 5) {
            password = StandardSecurityHandler.truncate127(password);
            byte[] uHash = new byte[32];
            byte[] uValidationSalt = new byte[8];
            System.arraycopy(user, 0, uHash, 0, 32);
            System.arraycopy(user, 32, uValidationSalt, 0, 8);
            byte[] hash = encRevision == 5 ? StandardSecurityHandler.computeSHA256(password, uValidationSalt, null) : this.computeHash2A(password, uValidationSalt, null);
            return Arrays.equals(hash, uHash);
        }
        throw new IOException("Unknown Encryption Revision " + encRevision);
    }

    public boolean isUserPassword(String password, byte[] user, byte[] owner, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws IOException {
        if (encRevision == 6 || encRevision == 5) {
            return this.isUserPassword(password.getBytes("UTF-8"), user, owner, permissions, id, encRevision, length, encryptMetadata);
        }
        return this.isUserPassword(password.getBytes("ISO-8859-1"), user, owner, permissions, id, encRevision, length, encryptMetadata);
    }

    public boolean isOwnerPassword(String password, byte[] user, byte[] owner, int permissions, byte[] id, int encRevision, int length, boolean encryptMetadata) throws IOException {
        return this.isOwnerPassword(password.getBytes("ISO-8859-1"), user, owner, permissions, id, encRevision, length, encryptMetadata);
    }

    private byte[] computeHash2A(byte[] password, byte[] salt, byte[] u) throws IOException {
        password = StandardSecurityHandler.truncate127(password);
        if (u == null) {
            u = new byte[]{};
        } else {
            if (u.length < 48) {
                throw new IOException("Bad U length");
            }
            if (u.length > 48) {
                byte[] uTrunc = new byte[48];
                System.arraycopy(u, 0, uTrunc, 0, 48);
                u = uTrunc;
            }
        }
        byte[] input = StandardSecurityHandler.concat(password, salt, u);
        return StandardSecurityHandler.computeHash2B(input, password, u);
    }

    private static byte[] computeHash2B(byte[] input, byte[] password, byte[] userKey) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] k = md.digest(input);
            byte[] e = null;
            for (int round = 0; round < 64 || (e[e.length - 1] & 0xFF) > round - 32; ++round) {
                byte[] k1 = userKey != null && userKey.length >= 48 ? new byte[64 * (password.length + k.length + 48)] : new byte[64 * (password.length + k.length)];
                int pos = 0;
                for (int i = 0; i < 64; ++i) {
                    System.arraycopy(password, 0, k1, pos, password.length);
                    System.arraycopy(k, 0, k1, pos += password.length, k.length);
                    pos += k.length;
                    if (userKey == null || userKey.length < 48) continue;
                    System.arraycopy(userKey, 0, k1, pos, 48);
                    pos += 48;
                }
                byte[] kFirst = new byte[16];
                byte[] kSecond = new byte[16];
                System.arraycopy(k, 0, kFirst, 0, 16);
                System.arraycopy(k, 16, kSecond, 0, 16);
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                SecretKeySpec keySpec = new SecretKeySpec(kFirst, "AES");
                IvParameterSpec ivSpec = new IvParameterSpec(kSecond);
                cipher.init(1, (Key)keySpec, ivSpec);
                e = cipher.doFinal(k1);
                byte[] eFirst = new byte[16];
                System.arraycopy(e, 0, eFirst, 0, 16);
                BigInteger bi = new BigInteger(1, eFirst);
                BigInteger remainder = bi.mod(new BigInteger("3"));
                String nextHash = HASHES_2B[remainder.intValue()];
                md = MessageDigest.getInstance(nextHash);
                k = md.digest(e);
            }
            if (k.length > 32) {
                byte[] kTrunc = new byte[32];
                System.arraycopy(k, 0, kTrunc, 0, 32);
                return kTrunc;
            }
            return k;
        }
        catch (GeneralSecurityException e) {
            StandardSecurityHandler.logIfStrongEncryptionMissing();
            throw new IOException(e);
        }
    }

    private static byte[] computeSHA256(byte[] input, byte[] password, byte[] userKey) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(input);
            md.update(password);
            return userKey == null ? md.digest() : md.digest(userKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private static byte[] concat(byte[] a, byte[] b) {
        byte[] o = new byte[a.length + b.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        return o;
    }

    private static byte[] concat(byte[] a, byte[] b, byte[] c) {
        byte[] o = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, o, 0, a.length);
        System.arraycopy(b, 0, o, a.length, b.length);
        System.arraycopy(c, 0, o, a.length + b.length, c.length);
        return o;
    }

    private static byte[] truncate127(byte[] in) {
        if (in.length <= 127) {
            return in;
        }
        byte[] trunc = new byte[127];
        System.arraycopy(in, 0, trunc, 0, 127);
        return trunc;
    }

    private static void logIfStrongEncryptionMissing() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                LOG.warn((Object)"JCE unlimited strength jurisdiction policy files are not installed");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

