/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.documentinterchange.prepress;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public class PDBoxStyle
implements COSObjectable {
    public static final String GUIDELINE_STYLE_SOLID = "S";
    public static final String GUIDELINE_STYLE_DASHED = "D";
    private COSDictionary dictionary;

    public PDBoxStyle() {
        this.dictionary = new COSDictionary();
    }

    public PDBoxStyle(COSDictionary dic) {
        this.dictionary = dic;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    public PDColor getGuidelineColor() {
        COSArray colorValues = (COSArray)this.dictionary.getDictionaryObject("C");
        if (colorValues == null) {
            colorValues = new COSArray();
            colorValues.add(COSInteger.ZERO);
            colorValues.add(COSInteger.ZERO);
            colorValues.add(COSInteger.ZERO);
            this.dictionary.setItem("C", (COSBase)colorValues);
        }
        PDColor color = new PDColor(colorValues.toFloatArray(), (PDColorSpace)PDDeviceRGB.INSTANCE);
        return color;
    }

    public void setGuideLineColor(PDColor color) {
        COSArray values = null;
        if (color != null) {
            values = color.toCOSArray();
        }
        this.dictionary.setItem("C", (COSBase)values);
    }

    public float getGuidelineWidth() {
        return this.dictionary.getFloat("W", 1.0f);
    }

    public void setGuidelineWidth(float width) {
        this.dictionary.setFloat("W", width);
    }

    public String getGuidelineStyle() {
        return this.dictionary.getNameAsString(GUIDELINE_STYLE_SOLID, GUIDELINE_STYLE_SOLID);
    }

    public void setGuidelineStyle(String style) {
        this.dictionary.setName(GUIDELINE_STYLE_SOLID, style);
    }

    public PDLineDashPattern getLineDashPattern() {
        PDLineDashPattern pattern = null;
        COSArray d = (COSArray)this.dictionary.getDictionaryObject(GUIDELINE_STYLE_DASHED);
        if (d == null) {
            d = new COSArray();
            d.add(COSInteger.THREE);
            this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (COSBase)d);
        }
        COSArray lineArray = new COSArray();
        lineArray.add(d);
        pattern = new PDLineDashPattern(lineArray, 0);
        return pattern;
    }

    public void setLineDashPattern(COSArray dashArray) {
        COSArray array = null;
        if (dashArray != null) {
            array = dashArray;
        }
        this.dictionary.setItem(GUIDELINE_STYLE_DASHED, (COSBase)array);
    }
}

