/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.function;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;

public class PDFunctionType2
extends PDFunction {
    private final COSArray c0;
    private final COSArray c1;
    private final float exponent;

    public PDFunctionType2(COSBase function) {
        super(function);
        if (this.getDictionary().getDictionaryObject(COSName.C0) == null) {
            this.c0 = new COSArray();
            this.c0.add(new COSFloat(0.0f));
        } else {
            this.c0 = (COSArray)this.getDictionary().getDictionaryObject(COSName.C0);
        }
        if (this.getDictionary().getDictionaryObject(COSName.C1) == null) {
            this.c1 = new COSArray();
            this.c1.add(new COSFloat(1.0f));
        } else {
            this.c1 = (COSArray)this.getDictionary().getDictionaryObject(COSName.C1);
        }
        this.exponent = this.getDictionary().getFloat(COSName.N);
    }

    @Override
    public int getFunctionType() {
        return 2;
    }

    @Override
    public float[] eval(float[] input) throws IOException {
        float xToN = (float)Math.pow(input[0], this.exponent);
        float[] result = new float[this.c0.size()];
        for (int j = 0; j < result.length; ++j) {
            float C0j = ((COSNumber)this.c0.get(j)).floatValue();
            float C1j = ((COSNumber)this.c1.get(j)).floatValue();
            result[j] = C0j + xToN * (C1j - C0j);
        }
        return this.clipToRange(result);
    }

    public COSArray getC0() {
        return this.c0;
    }

    public COSArray getC1() {
        return this.c1;
    }

    public float getN() {
        return this.exponent;
    }

    @Override
    public String toString() {
        return "FunctionType2{C0: " + this.getC0() + " " + "C1: " + this.getC1() + " " + "N: " + this.getN() + "}";
    }
}

