/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.NonSequentialPDFParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlerFactory;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardSecurityHandler;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDSignatureField;

public class PDDocument
implements Closeable {
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryption encryption;
    private boolean allSecurityToBeRemoved;
    private Long documentId;
    private BaseParser parser;
    private File incrementalFile;
    private AccessPermission accessPermission;

    public PDDocument() {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public void addPage(PDPage page) {
        this.getPages().add(page);
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface) throws IOException {
        this.addSignature(sigObject, signatureInterface, new SignatureOptions());
    }

    public void addSignature(PDSignature sigObject, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        COSDocument visualSignature;
        int preferedSignatureSize = options.getPreferedSignatureSize();
        if (preferedSignatureSize > 0) {
            sigObject.setContents(new byte[preferedSignatureSize]);
        } else {
            sigObject.setContents(new byte[9472]);
        }
        sigObject.setByteRange(new int[]{0, 1000000000, 1000000000, 1000000000});
        this.getDocument().setSignatureInterface(signatureInterface);
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        int pageCount = catalog.getPages().getCount();
        if (pageCount == 0) {
            throw new IllegalStateException("Cannot sign an empty document");
        }
        int startIndex = Math.max(Math.min(options.getPage(), 0), pageCount - 1);
        PDPage page = catalog.getPages().get(startIndex);
        PDAcroForm acroForm = catalog.getAcroForm();
        catalog.getCOSObject().setNeedToBeUpdate(true);
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getCOSObject().setNeedToBeUpdate(true);
        }
        List<PDAnnotation> annotations = page.getAnnotations();
        List<PDFieldTreeNode> fields = acroForm.getFields();
        PDSignatureField signatureField = null;
        if (fields == null) {
            fields = new ArrayList<PDFieldTreeNode>();
            acroForm.setFields(fields);
        }
        for (PDFieldTreeNode pdField : fields) {
            PDSignature signature;
            if (!(pdField instanceof PDSignatureField) || (signature = ((PDSignatureField)pdField).getSignature()) == null || !signature.getDictionary().equals(sigObject.getDictionary())) continue;
            signatureField = (PDSignatureField)pdField;
        }
        if (signatureField == null) {
            signatureField = new PDSignatureField(acroForm);
            signatureField.setSignature(sigObject);
            signatureField.getWidget().setPage(page);
        }
        List<PDFieldTreeNode> acroFormFields = acroForm.getFields();
        acroForm.getDictionary().setDirect(true);
        acroForm.setSignaturesExist(true);
        acroForm.setAppendOnly(true);
        boolean checkFields = false;
        for (PDFieldTreeNode field : acroFormFields) {
            if (!(field instanceof PDSignatureField) || !((PDSignatureField)field).getCOSObject().equals(signatureField.getCOSObject())) continue;
            checkFields = true;
            signatureField.getCOSObject().setNeedToBeUpdate(true);
            break;
        }
        if (!checkFields) {
            acroFormFields.add(signatureField);
        }
        if ((visualSignature = options.getVisualSignature()) == null) {
            signatureField.getWidget().setRectangle(new PDRectangle());
            acroForm.setDefaultResources(null);
            PDAppearanceDictionary ap = new PDAppearanceDictionary();
            COSStream apsStream = this.getDocument().createCOSStream();
            apsStream.createUnfilteredStream();
            PDAppearanceStream aps = new PDAppearanceStream(apsStream);
            COSDictionary cosObject = (COSDictionary)aps.getCOSObject();
            cosObject.setItem(COSName.SUBTYPE, (COSBase)COSName.FORM);
            cosObject.setItem(COSName.BBOX, (COSObjectable)new PDRectangle());
            ap.setNormalAppearance(aps);
            ap.getCOSObject().setDirect(true);
            signatureField.getWidget().setAppearance(ap);
        } else {
            List<COSObject> cosObjects = visualSignature.getObjects();
            boolean annotNotFound = true;
            boolean sigFieldNotFound = true;
            COSDictionary acroFormDict = acroForm.getDictionary();
            for (COSObject cosObject : cosObjects) {
                COSDictionary cosBaseDict;
                if (!annotNotFound && !sigFieldNotFound) break;
                COSBase base = cosObject.getObject();
                if (base == null || !(base instanceof COSDictionary)) continue;
                COSBase ft = ((COSDictionary)base).getItem(COSName.FT);
                COSBase type = ((COSDictionary)base).getItem(COSName.TYPE);
                COSBase apDict = ((COSDictionary)base).getItem(COSName.AP);
                if (annotNotFound && COSName.ANNOT.equals(type)) {
                    cosBaseDict = (COSDictionary)base;
                    COSArray rectAry = (COSArray)cosBaseDict.getItem(COSName.RECT);
                    PDRectangle rect = new PDRectangle(rectAry);
                    signatureField.getWidget().setRectangle(rect);
                    annotNotFound = false;
                }
                if (!sigFieldNotFound || !COSName.SIG.equals(ft) || apDict == null) continue;
                cosBaseDict = (COSDictionary)base;
                PDAppearanceDictionary ap = new PDAppearanceDictionary((COSDictionary)cosBaseDict.getDictionaryObject(COSName.AP));
                ap.getCOSObject().setDirect(true);
                signatureField.getWidget().setAppearance(ap);
                COSBase dr = cosBaseDict.getItem(COSName.DR);
                if (dr != null) {
                    dr.setDirect(true);
                    dr.setNeedToBeUpdate(true);
                    acroFormDict.setItem(COSName.DR, dr);
                }
                sigFieldNotFound = false;
            }
            if (annotNotFound || sigFieldNotFound) {
                throw new IllegalArgumentException("Template is missing required objects");
            }
        }
        if (annotations == null) {
            annotations = new COSArrayList<PDAnnotation>();
            page.setAnnotations(annotations);
        }
        if (!(annotations instanceof COSArrayList && acroFormFields instanceof COSArrayList && ((COSArrayList)annotations).toList().equals(((COSArrayList)acroFormFields).toList()) && checkFields)) {
            annotations.add(signatureField.getWidget());
        }
        page.getCOSObject().setNeedToBeUpdate(true);
    }

    public void addSignatureField(List<PDSignatureField> sigFields, SignatureInterface signatureInterface, SignatureOptions options) throws IOException {
        PDDocumentCatalog catalog = this.getDocumentCatalog();
        catalog.getCOSObject().setNeedToBeUpdate(true);
        PDAcroForm acroForm = catalog.getAcroForm();
        if (acroForm == null) {
            acroForm = new PDAcroForm(this);
            catalog.setAcroForm(acroForm);
        } else {
            acroForm.getCOSObject().setNeedToBeUpdate(true);
        }
        COSDictionary acroFormDict = acroForm.getDictionary();
        acroFormDict.setDirect(true);
        acroFormDict.setNeedToBeUpdate(true);
        if (!acroForm.isSignaturesExist()) {
            acroForm.setSignaturesExist(true);
        }
        List<PDFieldTreeNode> field = acroForm.getFields();
        for (PDSignatureField sigField : sigFields) {
            PDSignature sigObject = sigField.getSignature();
            sigField.getCOSObject().setNeedToBeUpdate(true);
            boolean checkFields = false;
            for (PDFieldTreeNode fieldNode : field) {
                if (!(fieldNode instanceof PDSignatureField) || !fieldNode.getCOSObject().equals(sigField.getCOSObject())) continue;
                checkFields = true;
                sigField.getCOSObject().setNeedToBeUpdate(true);
                break;
            }
            if (!checkFields) {
                field.add(sigField);
            }
            if (sigField.getSignature() == null) continue;
            sigField.getCOSObject().setNeedToBeUpdate(true);
            if (options == null) {
                // empty if block
            }
            this.addSignature(sigField.getSignature(), signatureInterface, options);
        }
    }

    public void removePage(PDPage page) {
        this.getPages().remove(page);
    }

    public void removePage(int pageNumber) {
        this.getPages().remove(pageNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSObject()));
        InputStream is = null;
        OutputStream os = null;
        try {
            PDStream src = page.getStream();
            if (src != null) {
                int amountRead;
                PDStream dest = new PDStream(this.document.createCOSStream());
                importedPage.setContents(dest);
                os = dest.createOutputStream();
                byte[] buf = new byte[10240];
                is = src.createInputStream();
                while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                    os.write(buf, 0, amountRead);
                }
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this(doc, null);
    }

    public PDDocument(COSDocument doc, BaseParser usedParser) {
        this(doc, usedParser, null);
    }

    public PDDocument(COSDocument doc, BaseParser usedParser, AccessPermission permission) {
        this.document = doc;
        this.parser = usedParser;
        this.accessPermission = permission;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSBase dictionary = trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = dictionary instanceof COSDictionary ? new PDDocumentCatalog(this, (COSDictionary)dictionary) : new PDDocumentCatalog(this);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    @Deprecated
    public PDEncryption getEncryptionDictionary() {
        return this.getEncryption();
    }

    public PDEncryption getEncryption() {
        if (this.encryption == null && this.isEncrypted()) {
            this.encryption = new PDEncryption(this.document.getEncryptionDictionary());
        }
        return this.encryption;
    }

    public void setEncryptionDictionary(PDEncryption encryption) throws IOException {
        this.encryption = encryption;
    }

    public PDSignature getLastSignatureDictionary() throws IOException {
        List<PDSignature> signatureDictionaries = this.getSignatureDictionaries();
        int size = signatureDictionaries.size();
        if (size > 0) {
            return signatureDictionaries.get(size - 1);
        }
        return null;
    }

    public List<PDSignatureField> getSignatureFields() throws IOException {
        LinkedList<PDSignatureField> fields = new LinkedList<PDSignatureField>();
        PDAcroForm acroForm = this.getDocumentCatalog().getAcroForm();
        if (acroForm != null) {
            List<COSDictionary> signatureDictionary = this.document.getSignatureFields(false);
            for (COSDictionary dict : signatureDictionary) {
                fields.add(new PDSignatureField(acroForm, dict, null));
            }
        }
        return fields;
    }

    public List<PDSignature> getSignatureDictionaries() throws IOException {
        List<COSDictionary> signatureDictionary = this.document.getSignatureDictionaries();
        LinkedList<PDSignature> signatures = new LinkedList<PDSignature>();
        for (COSDictionary dict : signatureDictionary) {
            signatures.add(new PDSignature(dict));
        }
        return signatures;
    }

    @Deprecated
    public void decrypt(String password) throws IOException {
        StandardDecryptionMaterial m = new StandardDecryptionMaterial(password);
        this.openProtection(m);
    }

    @Deprecated
    public void encrypt(String ownerPassword, String userPassword) throws IOException {
        if (!this.isEncrypted()) {
            this.encryption = new PDEncryption();
        }
        this.getEncryption().setSecurityHandler(new StandardSecurityHandler(new StandardProtectionPolicy(ownerPassword, userPassword, new AccessPermission())));
    }

    @Deprecated
    public String getOwnerPasswordForEncryption() {
        return null;
    }

    @Deprecated
    public String getUserPasswordForEncryption() {
        return null;
    }

    public static PDDocument loadLegacy(File file) throws IOException {
        return PDDocument.loadLegacy(file, BaseParser.FORCE_PARSING, false);
    }

    public static PDDocument loadLegacy(File file, boolean force) throws IOException {
        return PDDocument.loadLegacy(file, force, false);
    }

    public static PDDocument loadLegacy(File file, boolean force, boolean useScratchFiles) throws IOException {
        PDFParser parser = new PDFParser(new FileInputStream(file), force, useScratchFiles);
        parser.parse();
        PDDocument doc = parser.getPDDocument();
        doc.incrementalFile = file;
        return doc;
    }

    public static PDDocument loadLegacy(InputStream input) throws IOException {
        return PDDocument.loadLegacy(input, BaseParser.FORCE_PARSING, false);
    }

    public static PDDocument loadLegacy(InputStream input, boolean force) throws IOException {
        return PDDocument.loadLegacy(input, force, false);
    }

    public static PDDocument loadLegacy(InputStream input, boolean force, boolean useScratchFiles) throws IOException {
        PDFParser parser = new PDFParser(input, force, useScratchFiles);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(file, "", false);
    }

    public static PDDocument load(File file, boolean useScratchFiles) throws IOException {
        return PDDocument.load(file, "", useScratchFiles);
    }

    public static PDDocument load(File file, String password) throws IOException {
        return PDDocument.load(file, password, false);
    }

    public static PDDocument load(File file, String password, boolean useScratchFiles) throws IOException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(file, password, useScratchFiles);
        parser.parse();
        return parser.getPDDocument();
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, "", false);
    }

    public static PDDocument load(InputStream input, boolean useScratchFiles) throws IOException {
        return PDDocument.load(input, "", useScratchFiles);
    }

    public static PDDocument load(InputStream input, String password) throws IOException {
        return PDDocument.load(input, password, false);
    }

    public static PDDocument load(InputStream input, String password, boolean useScratchFiles) throws IOException {
        NonSequentialPDFParser parser = new NonSequentialPDFParser(input, password, useScratchFiles);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException {
        this.save(new File(fileName));
    }

    public void save(File file) throws IOException {
        this.save(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException {
        if (this.document == null) {
            throw new IOException("Cannot save a document which has been closed");
        }
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Deprecated
    public void saveIncremental(String fileName) throws IOException {
        this.saveIncremental(new BufferedInputStream(new FileInputStream(fileName)), new BufferedOutputStream(new FileOutputStream(fileName, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIncremental(InputStream input, OutputStream output) throws IOException {
        COSWriter writer = null;
        try {
            writer = new COSWriter(output, input);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void saveIncremental(OutputStream output) throws IOException {
        if (this.incrementalFile == null) {
            throw new IOException("PDDocument.load must be called with a File or String");
        }
        this.saveIncremental(new FileInputStream(this.incrementalFile), output);
    }

    public PDPage getPage(int pageIndex) {
        return this.getDocumentCatalog().getPages().get(pageIndex);
    }

    public PDPageTree getPages() {
        return this.getDocumentCatalog().getPages();
    }

    public int getNumberOfPages() {
        return this.getDocumentCatalog().getPages().getCount();
    }

    @Override
    public void close() throws IOException {
        this.documentCatalog = null;
        this.documentInformation = null;
        this.encryption = null;
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
        if (this.parser != null) {
            this.parser.clearResources();
            this.parser = null;
        }
        this.accessPermission = null;
    }

    public void protect(ProtectionPolicy policy) throws IOException {
        SecurityHandler securityHandler;
        if (!this.isEncrypted()) {
            this.encryption = new PDEncryption();
        }
        if ((securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForPolicy(policy)) == null) {
            throw new IOException("No security handler for policy " + policy);
        }
        this.getEncryption().setSecurityHandler(securityHandler);
    }

    public void openProtection(DecryptionMaterial decryptionMaterial) throws IOException {
        if (!this.isEncrypted()) {
            throw new IOException("Document is not encrypted");
        }
        SecurityHandler securityHandler = this.getEncryption().getSecurityHandler();
        securityHandler.decryptDocument(this, decryptionMaterial);
        this.accessPermission = securityHandler.getCurrentAccessPermission();
        this.document.dereferenceObjectStreams();
        this.document.setEncryptionDictionary(null);
        this.getDocumentCatalog();
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.accessPermission == null) {
            this.accessPermission = AccessPermission.getOwnerAccessPermission();
        }
        return this.accessPermission;
    }

    @Deprecated
    public SecurityHandler getSecurityHandler() {
        if (this.isEncrypted() && this.getEncryption().hasSecurityHandler()) {
            try {
                return this.getEncryption().getSecurityHandler();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Deprecated
    public boolean setSecurityHandler(SecurityHandler securityHandler) {
        if (this.isEncrypted()) {
            return false;
        }
        this.encryption = new PDEncryption();
        this.getEncryption().setSecurityHandler(securityHandler);
        return true;
    }

    public boolean isAllSecurityToBeRemoved() {
        return this.allSecurityToBeRemoved;
    }

    public void setAllSecurityToBeRemoved(boolean removeAllSecurity) {
        this.allSecurityToBeRemoved = removeAllSecurity;
    }

    public Long getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(Long docId) {
        this.documentId = docId;
    }
}

