/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.FilterFactory;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.io.RandomAccessFileInputStream;
import org.apache.pdfbox.io.RandomAccessFileOutputStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;

public class COSStream
extends COSDictionary
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSStream.class);
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess buffer;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;
    private DecodeResult decodeResult;

    public COSStream() {
        this(false, null);
    }

    public COSStream(COSDictionary dictionary) {
        this(dictionary, false, null);
    }

    public COSStream(boolean useScratchFiles, File scratchDirectory) {
        if (useScratchFiles) {
            this.createScratchFile(scratchDirectory);
        }
        if (this.buffer == null) {
            this.buffer = new RandomAccessBuffer();
        }
    }

    public COSStream(COSDictionary dictionary, boolean useScratchFiles, File scratchDirectory) {
        super(dictionary);
        if (useScratchFiles) {
            this.createScratchFile(scratchDirectory);
        }
        if (this.buffer == null) {
            this.buffer = new RandomAccessBuffer();
        }
    }

    private void createScratchFile(File scratchDirectory) {
        try {
            File scratchFile = File.createTempFile("PDFBox", null, scratchDirectory);
            scratchFile.deleteOnExit();
            this.buffer = new RandomAccessFile(scratchFile, "rw");
        }
        catch (IOException exception) {
            LOG.error((Object)"Can't create temp file, using memory buffer instead", (Throwable)exception);
        }
    }

    public List<Object> getStreamTokens() throws IOException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLengthWritten();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.buffer, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public void setFilteredLength(long length) {
        this.filteredStream.setExpectedLength(COSInteger.get(length));
    }

    public long getFilteredLengthWritten() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLengthWritten();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval;
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLengthWritten();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.buffer, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    public DecodeResult getDecodeResult() throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream == null || this.decodeResult == null) {
            throw new IOException("Stream was not read");
        }
        return this.decodeResult;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        this.unFilteredStream = this.filteredStream;
        COSBase filters = this.getFilters();
        if (filters == null) {
            this.decodeResult = DecodeResult.DEFAULT;
        } else if (filters instanceof COSName) {
            this.doDecode((COSName)filters, 0);
        } else if (filters instanceof COSArray) {
            COSArray filterArray = (COSArray)filters;
            for (int i = 0; i < filterArray.size(); ++i) {
                COSName filterName = (COSName)filterArray.get(i);
                this.doDecode(filterName, i);
            }
        } else {
            throw new IOException("Error: Unknown filter type:" + filters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDecode(COSName filterName, int filterIndex) throws IOException {
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        long writtenLength = this.unFilteredStream.getLengthWritten();
        if (length == 0L && writtenLength == 0L) {
            IOUtils.closeQuietly(this.unFilteredStream);
            this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
            done = true;
        } else {
            BufferedInputStream input;
            int tryCount;
            for (tryCount = 0; length > 0L && !done && tryCount < 5; ++tryCount) {
                input = null;
                try {
                    input = new BufferedInputStream(new RandomAccessFileInputStream(this.buffer, position, length), 16384);
                    IOUtils.closeQuietly(this.unFilteredStream);
                    this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
                    this.decodeResult = filter.decode(input, this.unFilteredStream, this, filterIndex);
                    done = true;
                    IOUtils.closeQuietly(input);
                    continue;
                }
                catch (IOException io) {
                    --length;
                    exception = io;
                    continue;
                }
                finally {
                    IOUtils.closeQuietly(input);
                }
            }
            if (!done) {
                length = writtenLength;
                for (tryCount = 0; !done && tryCount < 5; ++tryCount) {
                    input = null;
                    try {
                        input = new BufferedInputStream(new RandomAccessFileInputStream(this.buffer, position, length), 16384);
                        IOUtils.closeQuietly(this.unFilteredStream);
                        this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
                        this.decodeResult = filter.decode(input, this.unFilteredStream, this, filterIndex);
                        done = true;
                    }
                    catch (IOException io) {
                        try {
                            --length;
                            exception = io;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(input);
                            throw throwable;
                        }
                        IOUtils.closeQuietly(input);
                        continue;
                    }
                    IOUtils.closeQuietly(input);
                    continue;
                }
            }
        }
        if (!done) {
            throw exception;
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        COSBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof COSName) {
                this.doEncode((COSName)filters, 0);
            } else if (filters instanceof COSArray) {
                COSArray filterArray = (COSArray)filters;
                for (int i = filterArray.size() - 1; i >= 0; --i) {
                    COSName filterName = (COSName)filterArray.get(i);
                    this.doEncode(filterName, i);
                }
            }
        }
    }

    private void doEncode(COSName filterName, int filterIndex) throws IOException {
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.buffer, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.buffer);
        filter.encode(input, this.filteredStream, this, filterIndex);
        IOUtils.closeQuietly(input);
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = null;
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = new RandomAccessFileOutputStream(this.buffer);
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        OutputStream out = this.createFilteredStream();
        this.filteredStream.setExpectedLength(expectedLength);
        return out;
    }

    public void setFilters(COSBase filters) throws IOException {
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        this.setItem(COSName.FILTER, filters);
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        IOUtils.closeQuietly(this.filteredStream);
        this.filteredStream = null;
        IOUtils.closeQuietly(this.unFilteredStream);
        this.unFilteredStream = new RandomAccessFileOutputStream(this.buffer);
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }

    @Override
    public void close() {
        try {
            if (this.buffer != null) {
                this.buffer.close();
                this.buffer = null;
            }
        }
        catch (IOException exception) {
            LOG.error((Object)"Exception occured when closing the file.", (Throwable)exception);
        }
        if (this.filteredStream != null) {
            IOUtils.closeQuietly(this.filteredStream);
        }
        if (this.unFilteredStream != null) {
            IOUtils.closeQuietly(this.unFilteredStream);
        }
        this.clear();
    }
}

