/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator.graphics;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.MissingImageReaderException;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class DrawObject
extends GraphicsOperatorProcessor {
    private static final Log LOG = LogFactory.getLog(DrawObject.class);

    @Override
    public void process(Operator operator, List<COSBase> operands) throws IOException {
        COSName objectName = (COSName)operands.get(0);
        PDXObject xobject = this.context.getResources().getXObject(objectName);
        if (xobject == null) {
            LOG.warn((Object)("Can't find the XObject named '" + objectName.getName() + "'"));
        } else if (xobject instanceof PDImageXObject) {
            PDImageXObject image = (PDImageXObject)xobject;
            try {
                this.context.drawImage(image);
            }
            catch (MissingImageReaderException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
            }
        } else if (xobject instanceof PDFormXObject) {
            PDFormXObject form = (PDFormXObject)xobject;
            if (form.getGroup() != null && COSName.TRANSPARENCY.equals(form.getGroup().getSubType())) {
                this.getContext().showTransparencyGroup(form);
            } else {
                this.getContext().showForm(form);
            }
        }
    }

    @Override
    public String getName() {
        return "Do";
    }
}

