/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator.color;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;

public class SetNonStrokingColorSpace
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(SetNonStrokingColorSpace.class);

    @Override
    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        COSName name = (COSName)arguments.get(0);
        try {
            PDColorSpace cs = this.context.getResources().getColorSpace(name);
            this.context.getGraphicsState().setNonStrokingColorSpace(cs);
            this.context.getGraphicsState().setNonStrokingColor(cs.getInitialColor());
        }
        catch (PDColorSpace.MissingException e) {
            LOG.error((Object)("Missing color space: " + name.getName()));
        }
    }

    @Override
    public String getName() {
        return "cs";
    }
}

