/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.pdfbox.cos.COSDictionary;

public class Operator {
    private String theOperator;
    private byte[] imageData;
    private COSDictionary imageParameters;
    private static final ConcurrentHashMap<String, Operator> operators = new ConcurrentHashMap();

    private Operator(String aOperator) {
        this.theOperator = aOperator;
        if (aOperator.startsWith("/")) {
            throw new RuntimeException("Operators are not allowed to start with / '" + aOperator + "'");
        }
    }

    public static Operator getOperator(String operator) {
        Operator operation = null;
        if (operator.equals("ID") || operator.equals("BI")) {
            operation = new Operator(operator);
        } else {
            operation = operators.get(operator);
            if (operation == null && (operation = operators.putIfAbsent(operator, new Operator(operator))) == null) {
                operation = operators.get(operator);
            }
        }
        return operation;
    }

    public String getName() {
        return this.theOperator;
    }

    public String toString() {
        return "PDFOperator{" + this.theOperator + "}";
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] imageDataArray) {
        this.imageData = imageDataArray;
    }

    public COSDictionary getImageParameters() {
        return this.imageParameters;
    }

    public void setImageParameters(COSDictionary params) {
        this.imageParameters = params;
    }
}

