/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.font.PDType3CharProc;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.PDTextState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class PDFStreamEngine {
    private static final Log LOG = LogFactory.getLog(PDFStreamEngine.class);
    private final Map<String, OperatorProcessor> operators = new HashMap<String, OperatorProcessor>();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    protected Matrix subStreamMatrix = new Matrix();
    private final Stack<PDGraphicsState> graphicsStack = new Stack();
    private PDResources resources;
    private PDPage currentPage;
    private boolean isProcessingPage;
    private boolean forceParsing;

    public boolean isForceParsing() {
        return this.forceParsing;
    }

    public void setForceParsing(boolean forceParsingValue) {
        this.forceParsing = forceParsingValue;
    }

    @Deprecated
    public void registerOperatorProcessor(String operator, OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(operator, op);
    }

    public final void addOperator(OperatorProcessor op) {
        op.setContext(this);
        this.operators.put(op.getName(), op);
    }

    private void initPage(PDPage page) {
        if (page == null) {
            throw new IllegalArgumentException("Page cannot be null");
        }
        this.currentPage = page;
        this.graphicsStack.clear();
        this.graphicsStack.push(new PDGraphicsState(page.getCropBox()));
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = null;
    }

    public void processPage(PDPage page) throws IOException {
        this.initPage(page);
        if (page.getStream() != null) {
            this.isProcessingPage = true;
            this.processStream(page);
            this.isProcessingPage = false;
        }
    }

    public void showTransparencyGroup(PDFormXObject form) throws IOException {
        this.processTransparencyGroup(form);
    }

    public void showForm(PDFormXObject form) throws IOException {
        this.processChildStream(form);
    }

    public void processChildStream(PDContentStream contentStream) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        this.processStream(contentStream);
    }

    protected void processTransparencyGroup(PDFormXObject group) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        PDResources parent = this.pushResources(group);
        this.saveGraphicsState();
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(group.getMatrix());
        this.clipToRect(group.getBBox());
        this.processStreamOperators(group);
        this.restoreGraphicsState();
        this.popResources(parent);
    }

    protected void processType3Stream(PDType3CharProc charProc, Matrix textRenderingMatrix) throws IOException {
        if (this.currentPage == null) {
            throw new IllegalStateException("No current page, call #processChildStream(PDContentStream, PDPage) instead");
        }
        PDResources parent = this.pushResources(charProc);
        this.saveGraphicsState();
        this.getGraphicsState().setCurrentTransformationMatrix(textRenderingMatrix);
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(charProc.getMatrix());
        Matrix textMatrixOld = this.textMatrix;
        this.textMatrix = new Matrix();
        Matrix textLineMatrixOld = this.textLineMatrix;
        this.textLineMatrix = new Matrix();
        this.processStreamOperators(charProc);
        this.textMatrix = textMatrixOld;
        this.textLineMatrix = textLineMatrixOld;
        this.restoreGraphicsState();
        this.popResources(parent);
    }

    protected void processAnnotation(PDAnnotation annotation, PDAppearanceStream appearance) throws IOException {
        PDResources parent = this.pushResources(appearance);
        this.saveGraphicsState();
        PDRectangle bbox = appearance.getBBox();
        PDRectangle rect = annotation.getRectangle();
        Matrix matrix = appearance.getMatrix();
        if (rect.getWidth() > 0.0f && rect.getHeight() > 0.0f) {
            PDRectangle transformedBox = bbox.transform(matrix);
            Matrix a = Matrix.getTranslatingInstance(rect.getLowerLeftX(), rect.getLowerLeftY());
            a.concatenate(Matrix.getScaleInstance(rect.getWidth() / transformedBox.getWidth(), rect.getHeight() / transformedBox.getHeight()));
            a.concatenate(Matrix.getTranslatingInstance(-transformedBox.getLowerLeftX(), -transformedBox.getLowerLeftY()));
            Matrix aa = Matrix.concatenate(matrix, a);
            this.getGraphicsState().setCurrentTransformationMatrix(aa);
            this.clipToRect(bbox);
            this.processStreamOperators(appearance);
        }
        this.restoreGraphicsState();
        this.popResources(parent);
    }

    protected final void processTilingPattern(PDTilingPattern tilingPattern) throws IOException {
        PDResources parent = this.pushResources(tilingPattern);
        this.saveGraphicsState();
        PDRectangle bbox = tilingPattern.getBBox();
        this.clipToRect(bbox);
        this.processStreamOperators(tilingPattern);
        this.restoreGraphicsState();
        this.popResources(parent);
    }

    public void showAnnotation(PDAnnotation annotation) throws IOException {
        PDAppearanceStream appearanceStream = this.getAppearance(annotation);
        if (appearanceStream != null) {
            this.processAnnotation(annotation, appearanceStream);
        }
    }

    public PDAppearanceStream getAppearance(PDAnnotation annotation) {
        return annotation.getNormalAppearanceStream();
    }

    protected void processChildStream(PDContentStream contentStream, PDPage page) throws IOException {
        if (this.isProcessingPage) {
            throw new IllegalStateException("Current page has already been set via  #processPage(PDPage) call #processChildStream(PDContentStream) instead");
        }
        this.initPage(page);
        this.processStream(contentStream);
        this.currentPage = null;
    }

    private void processStream(PDContentStream contentStream) throws IOException {
        this.processStream(contentStream, null);
    }

    private void processStream(PDContentStream contentStream, PDRectangle patternBBox) throws IOException {
        PDResources parent = this.pushResources(contentStream);
        this.saveGraphicsState();
        this.getGraphicsState().getCurrentTransformationMatrix().concatenate(contentStream.getMatrix());
        PDRectangle bbox = contentStream.getBBox();
        if (patternBBox != null) {
            bbox = patternBBox;
        }
        this.clipToRect(bbox);
        this.processStreamOperators(contentStream);
        this.restoreGraphicsState();
        this.popResources(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStreamOperators(PDContentStream contentStream) throws IOException {
        Matrix oldSubStreamMatrix = this.subStreamMatrix;
        this.subStreamMatrix = this.getGraphicsState().getCurrentTransformationMatrix();
        ArrayList<COSBase> arguments = new ArrayList<COSBase>();
        PDFStreamParser parser = new PDFStreamParser(contentStream.getContentStream(), this.forceParsing);
        try {
            Iterator<Object> iter = parser.getTokenIterator();
            while (iter.hasNext()) {
                Object token = iter.next();
                if (token instanceof COSObject) {
                    arguments.add(((COSObject)token).getObject());
                    continue;
                }
                if (token instanceof Operator) {
                    this.processOperator((Operator)token, arguments);
                    arguments = new ArrayList();
                    continue;
                }
                arguments.add((COSBase)token);
            }
        }
        finally {
            parser.close();
        }
        this.subStreamMatrix = oldSubStreamMatrix;
    }

    private PDResources pushResources(PDContentStream contentStream) {
        PDResources parentResources = this.resources;
        PDResources streamResources = contentStream.getResources();
        this.resources = streamResources != null ? streamResources : this.currentPage.getResources();
        if (this.resources == null) {
            this.resources = new PDResources();
        }
        return parentResources;
    }

    private void popResources(PDResources parentResources) {
        this.resources = parentResources;
    }

    private void clipToRect(PDRectangle rectangle) {
        if (rectangle != null) {
            PDRectangle clip = rectangle.transform(this.getGraphicsState().getCurrentTransformationMatrix());
            this.getGraphicsState().intersectClippingPath(new Area(clip.toGeneralPath()));
        }
    }

    public void beginText() throws IOException {
    }

    public void endText() throws IOException {
    }

    public void showTextString(byte[] string) throws IOException {
        this.showText(string);
    }

    public void showTextStrings(COSArray array) throws IOException {
        PDTextState textState = this.getGraphicsState().getTextState();
        float fontSize = textState.getFontSize();
        float horizontalScaling = textState.getHorizontalScaling() / 100.0f;
        boolean isVertical = textState.getFont().isVertical();
        for (COSBase obj : array) {
            if (obj instanceof COSNumber) {
                float ty;
                float tx;
                float tj = ((COSNumber)obj).floatValue();
                if (isVertical) {
                    tx = 0.0f;
                    ty = -tj / 1000.0f * fontSize;
                } else {
                    tx = -tj / 1000.0f * fontSize * horizontalScaling;
                    ty = 0.0f;
                }
                this.applyTextAdjustment(tx, ty);
                continue;
            }
            if (obj instanceof COSString) {
                byte[] string = ((COSString)obj).getBytes();
                this.showText(string);
                continue;
            }
            throw new IOException("Unknown type in array for TJ operation:" + obj);
        }
    }

    protected void applyTextAdjustment(float tx, float ty) throws IOException {
        this.textMatrix.concatenate(Matrix.getTranslatingInstance(tx, ty));
    }

    protected void showText(byte[] string) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        PDTextState textState = state.getTextState();
        PDFont font = textState.getFont();
        if (font == null) {
            LOG.warn((Object)"No current font, will use default");
            font = PDFontFactory.createDefaultFont();
        }
        float fontSize = textState.getFontSize();
        float horizontalScaling = textState.getHorizontalScaling() / 100.0f;
        float charSpacing = textState.getCharacterSpacing();
        Matrix parameters = new Matrix(fontSize * horizontalScaling, 0.0f, 0.0f, fontSize, 0.0f, textState.getRise());
        ByteArrayInputStream in = new ByteArrayInputStream(string);
        while (((InputStream)in).available() > 0) {
            float ty;
            float tx;
            int before = ((InputStream)in).available();
            int code = font.readCode(in);
            int codeLength = before - ((InputStream)in).available();
            String unicode = font.toUnicode(code);
            float wordSpacing = 0.0f;
            if (codeLength == 1 && code == 32) {
                wordSpacing += textState.getWordSpacing();
            }
            Matrix ctm = state.getCurrentTransformationMatrix();
            Matrix textRenderingMatrix = parameters.multiply(this.textMatrix).multiply(ctm);
            if (font.isVertical()) {
                Vector v = font.getPositionVector(code);
                textRenderingMatrix.translate(v);
            }
            Vector w = font.getDisplacement(code);
            this.saveGraphicsState();
            this.showGlyph(textRenderingMatrix, font, code, unicode, w);
            this.restoreGraphicsState();
            if (font.isVertical()) {
                tx = 0.0f;
                ty = w.getY() * fontSize + charSpacing + wordSpacing;
            } else {
                tx = (w.getX() * fontSize + charSpacing + wordSpacing) * horizontalScaling;
                ty = 0.0f;
            }
            this.textMatrix.concatenate(Matrix.getTranslatingInstance(tx, ty));
        }
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        if (font instanceof PDType3Font) {
            this.showType3Glyph(textRenderingMatrix, (PDType3Font)font, code, unicode, displacement);
        } else {
            this.showFontGlyph(textRenderingMatrix, font, code, unicode, displacement);
        }
    }

    protected void showFontGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
    }

    protected void showType3Glyph(Matrix textRenderingMatrix, PDType3Font font, int code, String unicode, Vector displacement) throws IOException {
        PDType3CharProc charProc = font.getCharProc(code);
        if (charProc != null) {
            this.processType3Stream(charProc, textRenderingMatrix);
        }
    }

    public void processOperator(String operation, List<COSBase> arguments) throws IOException {
        Operator operator = Operator.getOperator(operation);
        this.processOperator(operator, arguments);
    }

    protected void processOperator(Operator operator, List<COSBase> arguments) throws IOException {
        String name = operator.getName();
        OperatorProcessor processor = this.operators.get(name);
        if (processor != null) {
            processor.setContext(this);
            processor.process(operator, arguments);
        } else {
            this.unsupportedOperator(operator, arguments);
        }
    }

    protected void unsupportedOperator(Operator operator, List<COSBase> arguments) throws IOException {
    }

    public void saveGraphicsState() {
        this.graphicsStack.push(this.graphicsStack.peek().clone());
    }

    public void restoreGraphicsState() {
        this.graphicsStack.pop();
    }

    public int getGraphicsStackSize() {
        return this.graphicsStack.size();
    }

    public PDGraphicsState getGraphicsState() {
        return this.graphicsStack.peek();
    }

    public Matrix getTextLineMatrix() {
        return this.textLineMatrix;
    }

    public void setTextLineMatrix(Matrix value) {
        this.textLineMatrix = value;
    }

    public Matrix getTextMatrix() {
        return this.textMatrix;
    }

    public void setTextMatrix(Matrix value) {
        this.textMatrix = value;
    }

    protected Matrix getSubStreamMatrix() {
        return this.subStreamMatrix;
    }

    public PDResources getResources() {
        return this.resources;
    }

    public PDPage getCurrentPage() {
        return this.currentPage;
    }

    public Point2D.Double transformedPoint(double x, double y) {
        double[] position = new double[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        return new Point2D.Double(position[0], position[1]);
    }

    protected float transformWidth(float width) {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        float x = ctm.getValue(0, 0) + ctm.getValue(1, 0);
        float y = ctm.getValue(0, 1) + ctm.getValue(1, 1);
        return width * (float)Math.sqrt((double)(x * x + y * y) * 0.5);
    }
}

