/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CodespaceRange;

public class CMapParser {
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private byte[] tokenParserByteBuffer = new byte[512];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMap parse(File file) throws IOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            CMap cMap = this.parse(input);
            return cMap;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMap parsePredefined(String name) throws IOException {
        InputStream input = null;
        try {
            input = this.getExternalCMap(name);
            CMap cMap = this.parse(input);
            return cMap;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public CMap parse(InputStream input) throws IOException {
        PushbackInputStream cmapStream = new PushbackInputStream(input);
        CMap result = new CMap();
        Object previousToken = null;
        Object token = null;
        while ((token = this.parseNextToken(cmapStream)) != null) {
            if (token instanceof Operator) {
                Operator op = (Operator)token;
                if (op.op.equals("usecmap")) {
                    LiteralName useCmapName = (LiteralName)previousToken;
                    InputStream useStream = this.getExternalCMap(useCmapName.name);
                    CMap useCMap = this.parse(useStream);
                    result.useCmap(useCMap);
                } else {
                    byte[] startCode;
                    byte[] inputCode;
                    Object nextToken;
                    if (op.op.equals("endcmap")) break;
                    if (op.op.equals("begincodespacerange")) {
                        Number cosCount = (Number)previousToken;
                        for (int j = 0; j < cosCount.intValue(); ++j) {
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof Operator) {
                                if (!((Operator)nextToken).op.equals("endcodespacerange")) {
                                    throw new IOException("Error : ~codespacerange contains an unexpected operator : " + ((Operator)nextToken).op);
                                }
                                break;
                            }
                            byte[] startRange = (byte[])nextToken;
                            byte[] endRange = (byte[])this.parseNextToken(cmapStream);
                            CodespaceRange range = new CodespaceRange();
                            range.setStart(startRange);
                            range.setEnd(endRange);
                            result.addCodespaceRange(range);
                        }
                    } else if (op.op.equals("beginbfchar")) {
                        Number cosCount = (Number)previousToken;
                        for (int j = 0; j < cosCount.intValue(); ++j) {
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof Operator) {
                                if (!((Operator)nextToken).op.equals("endbfchar")) {
                                    throw new IOException("Error : ~bfchar contains an unexpected operator : " + ((Operator)nextToken).op);
                                }
                                break;
                            }
                            inputCode = (byte[])nextToken;
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof byte[]) {
                                byte[] bytes = (byte[])nextToken;
                                String value = this.createStringFromBytes(bytes);
                                result.addCharMapping(inputCode, value);
                                continue;
                            }
                            if (nextToken instanceof LiteralName) {
                                result.addCharMapping(inputCode, ((LiteralName)nextToken).name);
                                continue;
                            }
                            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
                        }
                    } else if (op.op.equals("beginbfrange")) {
                        Number cosCount = (Number)previousToken;
                        for (int j = 0; j < cosCount.intValue(); ++j) {
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof Operator) {
                                if (!((Operator)nextToken).op.equals("endbfrange")) {
                                    throw new IOException("Error : ~bfrange contains an unexpected operator : " + ((Operator)nextToken).op);
                                }
                                break;
                            }
                            startCode = (byte[])nextToken;
                            byte[] endCode = (byte[])this.parseNextToken(cmapStream);
                            nextToken = this.parseNextToken(cmapStream);
                            List array = null;
                            byte[] tokenBytes = null;
                            if (nextToken instanceof List) {
                                array = (List)nextToken;
                                tokenBytes = (byte[])array.get(0);
                            } else {
                                tokenBytes = (byte[])nextToken;
                            }
                            boolean done = false;
                            String value = null;
                            int arrayIndex = 0;
                            while (!done) {
                                if (this.compare(startCode, endCode) >= 0) {
                                    done = true;
                                }
                                value = this.createStringFromBytes(tokenBytes);
                                result.addCharMapping(startCode, value);
                                this.increment(startCode);
                                if (array == null) {
                                    this.increment(tokenBytes);
                                    continue;
                                }
                                if (++arrayIndex >= array.size()) continue;
                                tokenBytes = (byte[])array.get(arrayIndex);
                            }
                        }
                    } else if (op.op.equals("begincidchar")) {
                        Number cosCount = (Number)previousToken;
                        for (int j = 0; j < cosCount.intValue(); ++j) {
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof Operator) {
                                if (!((Operator)nextToken).op.equals("endcidchar")) {
                                    throw new IOException("Error : ~cidchar contains an unexpected operator : " + ((Operator)nextToken).op);
                                }
                                break;
                            }
                            inputCode = (byte[])nextToken;
                            int mappedCode = (Integer)this.parseNextToken(cmapStream);
                            int mappedCID = this.createIntFromBytes(inputCode);
                            result.addCIDMapping(mappedCode, mappedCID);
                        }
                    } else if (op.op.equals("begincidrange")) {
                        int numberOfLines = (Integer)previousToken;
                        for (int n = 0; n < numberOfLines; ++n) {
                            nextToken = this.parseNextToken(cmapStream);
                            if (nextToken instanceof Operator) {
                                if (!((Operator)nextToken).op.equals("endcidrange")) {
                                    throw new IOException("Error : ~cidrange contains an unexpected operator : " + ((Operator)nextToken).op);
                                }
                                break;
                            }
                            startCode = (byte[])nextToken;
                            int start = this.createIntFromBytes(startCode);
                            byte[] endCode = (byte[])this.parseNextToken(cmapStream);
                            int end = this.createIntFromBytes(endCode);
                            int mappedCode = (Integer)this.parseNextToken(cmapStream);
                            if (startCode.length <= 2 && endCode.length <= 2) {
                                result.addCIDRange((char)start, (char)end, mappedCode);
                                continue;
                            }
                            int endOfMappings = mappedCode + end - start;
                            while (mappedCode <= endOfMappings) {
                                int mappedCID = this.createIntFromBytes(startCode);
                                result.addCIDMapping(mappedCode++, mappedCID);
                                this.increment(startCode);
                            }
                        }
                    }
                }
            } else if (token instanceof LiteralName) {
                Object next;
                LiteralName literal = (LiteralName)token;
                if ("WMode".equals(literal.name)) {
                    Object next2 = this.parseNextToken(cmapStream);
                    if (next2 instanceof Integer) {
                        result.setWMode((Integer)next2);
                    }
                } else if ("CMapName".equals(literal.name)) {
                    Object next3 = this.parseNextToken(cmapStream);
                    if (next3 instanceof LiteralName) {
                        result.setName(((LiteralName)next3).name);
                    }
                } else if ("CMapVersion".equals(literal.name)) {
                    Object next4 = this.parseNextToken(cmapStream);
                    if (next4 instanceof Number) {
                        result.setVersion(((Number)next4).toString());
                    } else if (next4 instanceof String) {
                        result.setVersion((String)next4);
                    }
                } else if ("CMapType".equals(literal.name)) {
                    Object next5 = this.parseNextToken(cmapStream);
                    if (next5 instanceof Integer) {
                        result.setType((Integer)next5);
                    }
                } else if ("Registry".equals(literal.name)) {
                    Object next6 = this.parseNextToken(cmapStream);
                    if (next6 instanceof String) {
                        result.setRegistry((String)next6);
                    }
                } else if ("Ordering".equals(literal.name)) {
                    Object next7 = this.parseNextToken(cmapStream);
                    if (next7 instanceof String) {
                        result.setOrdering((String)next7);
                    }
                } else if ("Supplement".equals(literal.name) && (next = this.parseNextToken(cmapStream)) instanceof Integer) {
                    result.setSupplement((Integer)next);
                }
            }
            previousToken = token;
        }
        return result;
    }

    protected InputStream getExternalCMap(String name) throws IOException {
        URL url = this.getClass().getResource(name);
        if (url == null) {
            throw new IOException("Error: Could not find referenced cmap stream " + name);
        }
        return url.openStream();
    }

    private Object parseNextToken(PushbackInputStream is) throws IOException {
        Object retval = null;
        int nextByte = is.read();
        while (nextByte == 9 || nextByte == 32 || nextByte == 13 || nextByte == 10) {
            nextByte = is.read();
        }
        switch (nextByte) {
            case 37: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                this.readUntilEndOfLine(is, buffer);
                retval = buffer.toString();
                break;
            }
            case 40: {
                StringBuffer buffer = new StringBuffer();
                int stringByte = is.read();
                while (stringByte != -1 && stringByte != 41) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                retval = buffer.toString();
                break;
            }
            case 62: {
                int secondCloseBrace = is.read();
                if (secondCloseBrace == 62) {
                    retval = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                retval = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> list = new ArrayList<Object>();
                Object nextToken = this.parseNextToken(is);
                while (nextToken != null && nextToken != MARK_END_OF_ARRAY) {
                    list.add(nextToken);
                    nextToken = this.parseNextToken(is);
                }
                retval = list;
                break;
            }
            case 60: {
                int theNextByte = is.read();
                if (theNextByte == 60) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    Object key = this.parseNextToken(is);
                    while (key instanceof LiteralName && key != MARK_END_OF_DICTIONARY) {
                        Object value = this.parseNextToken(is);
                        result.put(((LiteralName)key).name, value);
                        key = this.parseNextToken(is);
                    }
                    retval = result;
                    break;
                }
                int multiplyer = 16;
                int bufferIndex = -1;
                while (theNextByte != -1 && theNextByte != 62) {
                    int intValue = 0;
                    if (theNextByte >= 48 && theNextByte <= 57) {
                        intValue = theNextByte - 48;
                    } else if (theNextByte >= 65 && theNextByte <= 70) {
                        intValue = 10 + theNextByte - 65;
                    } else if (theNextByte >= 97 && theNextByte <= 102) {
                        intValue = 10 + theNextByte - 97;
                    } else {
                        if (this.isWhitespaceOrEOF(theNextByte)) {
                            theNextByte = is.read();
                            continue;
                        }
                        throw new IOException("Error: expected hex character and not " + (char)theNextByte + ":" + theNextByte);
                    }
                    intValue *= multiplyer;
                    if (multiplyer == 16) {
                        this.tokenParserByteBuffer[++bufferIndex] = 0;
                        multiplyer = 1;
                    } else {
                        multiplyer = 16;
                    }
                    int n = bufferIndex;
                    this.tokenParserByteBuffer[n] = (byte)(this.tokenParserByteBuffer[n] + intValue);
                    theNextByte = is.read();
                }
                byte[] finalResult = new byte[bufferIndex + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, finalResult, 0, bufferIndex + 1);
                retval = finalResult;
                break;
            }
            case 47: {
                StringBuffer buffer = new StringBuffer();
                int stringByte = is.read();
                while (!this.isWhitespaceOrEOF(stringByte)) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                retval = new LiteralName(buffer.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!this.isWhitespaceOrEOF(nextByte) && (Character.isDigit((char)nextByte) || nextByte == 46)) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                is.unread(nextByte);
                String value = buffer.toString();
                if (value.indexOf(46) >= 0) {
                    retval = new Double(value);
                    break;
                }
                retval = new Integer(value);
                break;
            }
            default: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!this.isWhitespaceOrEOF(nextByte) && nextByte != 60) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                if (nextByte == 60) {
                    is.unread(nextByte);
                }
                retval = new Operator(buffer.toString());
                break;
            }
        }
        return retval;
    }

    private void readUntilEndOfLine(InputStream is, StringBuffer buf) throws IOException {
        int nextByte = is.read();
        while (nextByte != -1 && nextByte != 13 && nextByte != 10) {
            buf.append((char)nextByte);
            nextByte = is.read();
        }
    }

    private boolean isWhitespaceOrEOF(int aByte) {
        return aByte == -1 || aByte == 32 || aByte == 13 || aByte == 10;
    }

    private void increment(byte[] data) {
        this.increment(data, data.length - 1);
    }

    private void increment(byte[] data, int position) {
        if (position > 0 && (data[position] + 256) % 256 == 255) {
            data[position] = 0;
            this.increment(data, position - 1);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
    }

    private int createIntFromBytes(byte[] bytes) {
        int intValue = (bytes[0] + 256) % 256;
        if (bytes.length == 2) {
            intValue <<= 8;
            intValue += (bytes[1] + 256) % 256;
        }
        return intValue;
    }

    private String createStringFromBytes(byte[] bytes) throws IOException {
        String retval = null;
        retval = bytes.length == 1 ? new String(bytes, "ISO-8859-1") : new String(bytes, "UTF-16BE");
        return retval;
    }

    private int compare(byte[] first, byte[] second) {
        int retval = 1;
        int firstLength = first.length;
        for (int i = 0; i < firstLength; ++i) {
            if (first[i] == second[i]) continue;
            if ((first[i] + 256) % 256 < (second[i] + 256) % 256) {
                retval = -1;
                break;
            }
            retval = 1;
            break;
        }
        return retval;
    }

    private class Operator {
        private String op;

        private Operator(String theOp) {
            this.op = theOp;
        }
    }

    private class LiteralName {
        private String name;

        private LiteralName(String theName) {
            this.name = theName;
        }
    }
}

