/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CIDKeyedType2CharString;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.cff.IndexData;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.type1.Type1CharStringReader;

public class CFFCIDFont
extends CFFFont {
    private String registry;
    private String ordering;
    private int supplement;
    private List<Map<String, Object>> fontDictionaries = new LinkedList<Map<String, Object>>();
    private List<Map<String, Object>> privateDictionaries = new LinkedList<Map<String, Object>>();
    private FDSelect fdSelect;
    private final Map<Integer, CIDKeyedType2CharString> charStringCache = new ConcurrentHashMap<Integer, CIDKeyedType2CharString>();
    private final PrivateType1CharStringReader reader = new PrivateType1CharStringReader();

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String registry) {
        this.registry = registry;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    public List<Map<String, Object>> getFontDicts() {
        return this.fontDictionaries;
    }

    void setFontDict(List<Map<String, Object>> fontDict) {
        this.fontDictionaries = fontDict;
    }

    public List<Map<String, Object>> getPrivDicts() {
        return this.privateDictionaries;
    }

    void setPrivDict(List<Map<String, Object>> privDict) {
        this.privateDictionaries = privDict;
    }

    public FDSelect getFdSelect() {
        return this.fdSelect;
    }

    void setFdSelect(FDSelect fdSelect) {
        this.fdSelect = fdSelect;
    }

    private int getDefaultWidthX(int gid) {
        int fdArrayIndex = this.fdSelect.getFDIndex(gid);
        if (fdArrayIndex == -1) {
            return 1000;
        }
        Map<String, Object> privDict = this.privateDictionaries.get(fdArrayIndex);
        return privDict.containsKey("defaultWidthX") ? ((Number)privDict.get("defaultWidthX")).intValue() : 1000;
    }

    private int getNominalWidthX(int gid) {
        int fdArrayIndex = this.fdSelect.getFDIndex(gid);
        if (fdArrayIndex == -1) {
            return 0;
        }
        Map<String, Object> privDict = this.privateDictionaries.get(fdArrayIndex);
        return privDict.containsKey("nominalWidthX") ? ((Number)privDict.get("nominalWidthX")).intValue() : 0;
    }

    private IndexData getLocalSubrIndex(int gid) {
        int fdArrayIndex = this.fdSelect.getFDIndex(gid);
        if (fdArrayIndex == -1) {
            return new IndexData(0);
        }
        Map<String, Object> privDict = this.privateDictionaries.get(fdArrayIndex);
        return (IndexData)privDict.get("Subrs");
    }

    public CIDKeyedType2CharString getType2CharString(int cid) throws IOException {
        CIDKeyedType2CharString type2 = this.charStringCache.get(cid);
        if (type2 == null) {
            int gid = this.charset.getGIDForCID(cid);
            byte[] bytes = (byte[])this.charStrings.get(gid);
            if (bytes == null) {
                bytes = (byte[])this.charStrings.get(0);
            }
            Type2CharStringParser parser = new Type2CharStringParser(this.fontName, cid);
            List<Object> type2seq = parser.parse(bytes, this.globalSubrIndex, this.getLocalSubrIndex(gid));
            type2 = new CIDKeyedType2CharString((Type1CharStringReader)this.reader, this.fontName, cid, gid, type2seq, this.getDefaultWidthX(gid), this.getNominalWidthX(gid));
            this.charStringCache.put(cid, type2);
        }
        return type2;
    }

    @Override
    public List<Number> getFontMatrix() {
        if (this.fontDictionaries.size() > 0 && this.fontDictionaries.get(0).containsKey("FontMatrix")) {
            return (List)this.fontDictionaries.get(0).get("FontMatrix");
        }
        return (List)this.topDict.get("FontMatrix");
    }

    private class PrivateType1CharStringReader
    implements Type1CharStringReader {
        private PrivateType1CharStringReader() {
        }

        @Override
        public Type1CharString getType1CharString(String name) throws IOException {
            return CFFCIDFont.this.getType2CharString(0);
        }
    }
}

