/*
 * Decompiled with CFR 0.152.
 */
package de.unimuenster.alphaportfolio;

import de.unimuenster.alphaportfolio.BigTextField;
import de.unimuenster.alphaportfolio.Config;
import de.unimuenster.alphaportfolio.CustomPanel;
import de.unimuenster.alphaportfolio.HeaderLabel;
import de.unimuenster.alphaportfolio.PDFWochenplan;
import de.unimuenster.alphaportfolio.Tagesplan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPrinter;
import org.apache.pdfbox.printing.Scaling;

public class Wochenplan
extends JPanel {
    private static final long serialVersionUID = -4833434074221592239L;
    public static final String FILE_SETTINGS = "assets/cfg/settings.cfg";
    private JPanel pnTop = null;
    private JPanel pnMiddle = null;
    private JPanel pnBottom = null;
    private JPanel pnPersData = null;
    private GridBagLayout gbl = null;
    private JTextField tfDatumVon = null;
    private JTextField tfDatumBis = null;
    private JTextField tfVorname = null;
    private JTextField tfNachname = null;
    private JScrollPane spMiddle = null;
    private Vector<Tagesplan> tagesplaene;
    private JButton btPrint = null;
    private JButton btSave = null;
    private JLabel logo = null;
    private JFileChooser fc = null;
    private JLabel warteAnimation = null;
    private SimpleDateFormat sdf = null;
    private Date heute = null;
    private Date inEinerWoche = null;
    private SimpleDateFormat sdfAmerikanisch = null;

    public Wochenplan() {
        this.setPreferredSize(new Dimension(1200, 600));
        this.fc = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("PDF Datei", "pdf", "pdf");
        this.fc.setFileFilter(filter);
        this.setBackground(Config.COLOR_WHITE);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnTop = new CustomPanel(new BorderLayout());
        this.gbl = new GridBagLayout();
        this.pnPersData = new CustomPanel(this.gbl);
        GridBagConstraints cbc = new GridBagConstraints();
        cbc.weightx = 0.5;
        cbc.weighty = 0.5;
        cbc.insets = new Insets(5, 5, 5, 5);
        cbc.fill = 2;
        cbc.gridx = 0;
        cbc.gridy = 0;
        this.heute = Calendar.getInstance().getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, 7);
        this.inEinerWoche = calendar.getTime();
        this.sdf = new SimpleDateFormat("dd.MM.yyyy");
        this.sdfAmerikanisch = new SimpleDateFormat("yyyy-MM-dd");
        this.pnPersData.add((Component)new HeaderLabel("Wochenplan f\u00fcr die Woche vom "), cbc);
        this.tfDatumVon = new BigTextField(this.sdf.format(this.heute));
        cbc.gridx = 1;
        this.pnPersData.add((Component)this.tfDatumVon, cbc);
        cbc.gridx = 2;
        this.pnPersData.add((Component)new HeaderLabel(" bis zum "), cbc);
        this.tfDatumBis = new BigTextField(this.sdf.format(this.inEinerWoche));
        cbc.gridx = 3;
        this.pnPersData.add((Component)this.tfDatumBis, cbc);
        cbc.fill = 2;
        cbc.gridwidth = 1;
        cbc.gridy = 1;
        cbc.gridx = 0;
        this.pnPersData.add((Component)new HeaderLabel("Vorname:"), cbc);
        this.tfVorname = new BigTextField();
        cbc.gridx = 1;
        cbc.gridwidth = 4;
        this.pnPersData.add((Component)this.tfVorname, cbc);
        cbc.gridy = 2;
        cbc.gridx = 0;
        this.pnPersData.add((Component)new HeaderLabel("Nachname:"), cbc);
        this.tfNachname = new BigTextField();
        cbc.gridx = 1;
        this.pnPersData.add((Component)this.tfNachname, cbc);
        this.pnTop.add((Component)this.pnPersData, "West");
        this.logo = new JLabel(new ImageIcon("assets/gfx/logo_128.png"));
        this.logo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 15));
        this.pnTop.add((Component)this.logo, "East");
        this.add((Component)this.pnTop, "North");
        this.pnMiddle = new CustomPanel(new GridBagLayout());
        this.spMiddle = new JScrollPane(this.pnMiddle);
        cbc = new GridBagConstraints();
        cbc.insets = new Insets(5, 5, 5, 5);
        cbc.fill = 1;
        cbc.gridx = 0;
        cbc.gridy = 0;
        cbc.weightx = 1.0;
        this.tagesplaene = new Vector();
        int i = 0;
        while (i < 5) {
            Tagesplan tmpTagesplan = new Tagesplan(i, this);
            this.tagesplaene.add(tmpTagesplan);
            this.pnMiddle.add((Component)tmpTagesplan, cbc);
            ++cbc.gridy;
            ++i;
        }
        this.add((Component)this.spMiddle, "Center");
        this.pnBottom = new JPanel(new BorderLayout(5, 5));
        this.btPrint = new JButton("");
        this.btPrint.setIcon(new ImageIcon("assets/gfx/drucken.png"));
        this.btPrint.setBorder(BorderFactory.createEmptyBorder(8, 64, 8, 64));
        this.btPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wochenplan.this.warteAnimation.setVisible(true);
                Wochenplan.this.btPrint.setText("....");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Wochenplan.this.printPDF();
                        Wochenplan.this.btPrint.setText("");
                        Wochenplan.this.warteAnimation.setVisible(false);
                    }
                }).start();
            }
        });
        this.btSave = new JButton("");
        this.btSave.setIcon(new ImageIcon("assets/gfx/speichern.png"));
        this.btSave.setBorder(BorderFactory.createEmptyBorder(8, 64, 8, 64));
        this.btSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Wochenplan.this.btSave.setText("....");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Wochenplan.this.savePDF("");
                        Wochenplan.this.btSave.setText("");
                        Wochenplan.this.warteAnimation.setVisible(false);
                    }
                }).start();
            }
        });
        this.warteAnimation = new JLabel(new ImageIcon("assets/gfx/warten.gif"));
        this.warteAnimation.setVisible(false);
        this.pnBottom.add((Component)this.warteAnimation, "Center");
        this.pnBottom.add((Component)this.btSave, "West");
        JLabel lbCopyright = new JLabel("\u00a9 Alphaportfolio");
        lbCopyright.setHorizontalAlignment(0);
        this.pnBottom.add((Component)lbCopyright, "Center");
        this.pnBottom.add((Component)this.btPrint, "East");
        this.add((Component)this.pnBottom, "South");
        this.loadSettings();
    }

    public void savePDF(String dateiname) {
        if (this.tagesplaene.get(0).toString() != "!" && this.tagesplaene.get(0).toString() != "?") {
            PDFWochenplan pdfWochenplanTest = new PDFWochenplan();
            this.fc.setSelectedFile(new File("WP_" + this.tfVorname.getText() + "_" + this.tfNachname.getText() + "_" + this.sdfAmerikanisch.format(this.heute) + "_" + this.sdfAmerikanisch.format(this.inEinerWoche) + ".pdf"));
            int returnVal = this.fc.showSaveDialog(this);
            if (returnVal == 0) {
                this.warteAnimation.setVisible(true);
                pdfWochenplanTest.createPDF(this.tfVorname.getText(), this.tfNachname.getText(), this, this.fc.getSelectedFile().getAbsoluteFile().toString());
                try {
                    pdfWochenplanTest.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Bitte w\u00e4hlen Sie alle Ebenen aus.");
        }
    }

    public void printPDF() {
        boolean fehler = false;
        Vector<String> VDateinamen = new Vector<String>();
        if (this.tagesplaene.get(0).toString() != "!" && this.tagesplaene.get(0).toString() != "?") {
            PrinterJob printJob;
            for (Tagesplan tp : this.tagesplaene) {
                tp.meldung(false, "", Tagesplan.C_MELDUNG_INFO);
                if (tp.toString() != "!" && tp.toString() != "?") {
                    File f = new File("assets/pdf/" + tp.toString());
                    if (f.exists()) {
                        VDateinamen.add(tp.toString());
                        continue;
                    }
                    tp.meldung(true, "F\u00fcr diese Anforderungen steht momentan kein PDF zur Verf\u00fcgung.", Tagesplan.C_MELDUNG);
                    continue;
                }
                if (tp.toString() != "?") continue;
                tp.meldung(true, "Bitte f\u00fcllen Sie jede angefangene Zeile ganz aus.", Tagesplan.C_MELDUNG);
                fehler = true;
            }
            if (!fehler && (printJob = PrinterJob.getPrinterJob()).printDialog()) {
                PrintService printService = printJob.getPrintService();
                PDFWochenplan pdfWochenplan = new PDFWochenplan();
                pdfWochenplan.createPDF(this.tfVorname.getText(), this.tfNachname.getText(), this, "");
                pdfWochenplan.printPDF(printJob, printService);
                try {
                    pdfWochenplan.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                for (String datei : VDateinamen) {
                    PrinterJob printPDFJob;
                    PDFPrinter printer;
                    if (datei.equals("")) continue;
                    File f = new File("assets/pdf/" + datei);
                    PDDocument pdf = null;
                    try {
                        try {
                            pdf = PDDocument.load((File)f);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(this, "Aufgabenblatt/PDF konnt nicht geladen werden. (" + datei + ")");
                            if (pdf == null) continue;
                            try {
                                printer = new PDFPrinter(pdf, Scaling.ACTUAL_SIZE, Orientation.AUTO);
                                printPDFJob = PrinterJob.getPrinterJob();
                                printPDFJob.setPrintService(printService);
                                printPDFJob.setPageable((Pageable)printer.getPageable());
                                printer.silentPrint(printPDFJob);
                                pdf.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                                JOptionPane.showMessageDialog(this, "Drucker konnte nicht ge\u00f6ffnet werden.");
                            }
                            catch (PrinterException e3) {
                                e3.printStackTrace();
                                JOptionPane.showMessageDialog(this, "Druckauftrag fehlgeschlagen.");
                            }
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pdf != null) {
                            try {
                                printer = new PDFPrinter(pdf, Scaling.ACTUAL_SIZE, Orientation.AUTO);
                                printPDFJob = PrinterJob.getPrinterJob();
                                printPDFJob.setPrintService(printService);
                                printPDFJob.setPageable((Pageable)printer.getPageable());
                                printer.silentPrint(printPDFJob);
                                pdf.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(this, "Drucker konnte nicht ge\u00f6ffnet werden.");
                            }
                            catch (PrinterException e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(this, "Druckauftrag fehlgeschlagen.");
                            }
                        }
                        throw throwable;
                    }
                    if (pdf == null) continue;
                    try {
                        printer = new PDFPrinter(pdf, Scaling.ACTUAL_SIZE, Orientation.AUTO);
                        printPDFJob = PrinterJob.getPrinterJob();
                        printPDFJob.setPrintService(printService);
                        printPDFJob.setPageable((Pageable)printer.getPageable());
                        printer.silentPrint(printPDFJob);
                        pdf.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Drucker konnte nicht ge\u00f6ffnet werden.");
                    }
                    catch (PrinterException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Druckauftrag fehlgeschlagen.");
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Bitte w\u00e4hlen Sie alle Ebenen aus.");
        }
        this.saveSettings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveSettings() {
        boolean erfolg = false;
        Properties prop = new Properties();
        prop.setProperty("vorname", this.tfVorname.getText());
        prop.setProperty("nachname", this.tfNachname.getText());
        FileOutputStream strmOut = null;
        try {
            try {
                strmOut = new FileOutputStream(FILE_SETTINGS);
                prop.store(strmOut, null);
                erfolg = true;
                return erfolg;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Konfiguration konnte nicht gefunden werden.");
                if (strmOut == null) return erfolg;
                try {
                    ((OutputStream)strmOut).close();
                    return erfolg;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return erfolg;
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Konfiguration konnte nicht gespeichert werden.");
                if (strmOut == null) return erfolg;
                try {
                    ((OutputStream)strmOut).close();
                    return erfolg;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return erfolg;
            }
        }
        finally {
            if (strmOut != null) {
                try {
                    ((OutputStream)strmOut).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadSettings() {
        File fSettings = new File(FILE_SETTINGS);
        if (!fSettings.exists()) return true;
        Properties prop = new Properties();
        FileInputStream strmIn = null;
        try {
            try {
                strmIn = new FileInputStream(fSettings);
                prop.load(strmIn);
                this.tfVorname.setText(prop.getProperty("vorname"));
                this.tfNachname.setText(prop.getProperty("nachname"));
                return true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Es ist keine Konfigurationsdatei vorhanden.");
                if (strmIn == null) return true;
                try {
                    ((InputStream)strmIn).close();
                    return true;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "Konfiguration konnte nicht geladen werden.");
                if (strmIn == null) return true;
                try {
                    ((InputStream)strmIn).close();
                    return true;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return true;
            }
        }
        finally {
            if (strmIn != null) {
                try {
                    ((InputStream)strmIn).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getVon() {
        return this.tfDatumVon.getText();
    }

    public String getBis() {
        return this.tfDatumBis.getText();
    }

    public String getDatum(String format) {
        if (format == "") {
            format = "dd.MM.yyyy";
        }
        Date heute = Calendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(heute);
    }

    public Vector<Tagesplan> getTagesplaene() {
        return this.tagesplaene;
    }

    public void setTagesplaene(Vector<Tagesplan> tagesplaene) {
        this.tagesplaene = tagesplaene;
    }

    public void printSelection() {
        System.out.println(this.tagesplaene.get(0).toString());
    }

    public void tagesplanAuswahl(Tagesplan tagesplan) {
        if (!tagesplan.getCbNiveau().getSelectedItem().toString().equals("")) {
            if (tagesplan.getNummer() < 4) {
                this.tagesplaene.get(tagesplan.getNummer() + 1).getCbNiveau().setEnabled(true);
                this.tagesplaene.get(tagesplan.getNummer() + 1).meldung(true, "Bitte Niveau ausw\u00e4hlen:", Tagesplan.C_MELDUNG_INFO);
                this.tagesplaene.get(tagesplan.getNummer()).meldung(true, "", Tagesplan.C_MELDUNG_INFO);
            } else {
                this.tagesplaene.get(tagesplan.getNummer()).meldung(true, "", Tagesplan.C_MELDUNG_INFO);
            }
        }
    }
}

