/*
 * Decompiled with CFR 0.152.
 */
package de.unimuenster.alphaportfolio;

import de.unimuenster.alphaportfolio.ComboItem;
import de.unimuenster.alphaportfolio.ComboVector;
import de.unimuenster.alphaportfolio.ComboboxRenderer;
import de.unimuenster.alphaportfolio.CustomCombobox;
import de.unimuenster.alphaportfolio.HeaderLabel;
import de.unimuenster.alphaportfolio.Wochenplan;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JLabel;

public class Tagesplan
extends Container
implements ActionListener {
    private static final long serialVersionUID = -7678326159119635189L;
    public static final Color C_MELDUNG = new Color(255, 32, 32);
    public static final Color C_MELDUNG_INFO = new Color(32, 32, 32);
    private CustomCombobox cbNiveau = null;
    private CustomCombobox cbArbeit = null;
    private CustomCombobox cbStation = null;
    private CustomCombobox cbAufgabe = null;
    private CustomCombobox cbFertigkeit = null;
    private CustomCombobox cbStufe = null;
    private JLabel lbMeldung = null;
    private ComboboxRenderer cbRenderer = null;
    private Wochenplan wochenplan;
    private int nummer = -1;

    public Tagesplan(int nummer, Wochenplan wochenplan) {
        this.nummer = nummer;
        this.wochenplan = wochenplan;
        this.setLayout(new GridBagLayout());
        GridBagConstraints cbc = new GridBagConstraints();
        cbc.insets = new Insets(3, 3, 3, 3);
        cbc.fill = 1;
        cbc.gridy = 0;
        cbc.weightx = 0.5;
        cbc.weighty = 0.5;
        if (nummer == 0) {
            this.add((Component)new HeaderLabel("Sprachniveau"), cbc);
            this.add((Component)new HeaderLabel("Ziele"), cbc);
            this.add((Component)new HeaderLabel("Station"), cbc);
            this.add((Component)new HeaderLabel("Aufgabenebene"), cbc);
            this.add((Component)new HeaderLabel("Fertigkeit"), cbc);
            this.add((Component)new HeaderLabel("Stufe"), cbc);
            ++cbc.gridy;
        }
        if (nummer > 0) {
            this.add((Component)new HeaderLabel(""), cbc);
            this.add((Component)new HeaderLabel(""), cbc);
            this.add((Component)new HeaderLabel(""), cbc);
            this.add((Component)new HeaderLabel(""), cbc);
            this.add((Component)new HeaderLabel(""), cbc);
            this.add((Component)new HeaderLabel(""), cbc);
            ++cbc.gridy;
        }
        ++cbc.gridy;
        cbc.gridwidth = 7;
        this.lbMeldung = new JLabel("");
        if (nummer == 0) {
            this.meldung(true, "Bitte Niveau ausw\u00e4hlen:", C_MELDUNG_INFO);
        }
        this.lbMeldung.setFont(this.lbMeldung.getFont().deriveFont(16.0f));
        this.add((Component)this.lbMeldung, cbc);
        cbc.gridwidth = 1;
        ++cbc.gridy;
        this.cbRenderer = new ComboboxRenderer();
        ComboVector cv = null;
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/niveaustufen_allgemein.png", 1, 3);
        cv.addItem("A1", "A1", "assets/gfx/niveau_a1.png", 1, 3);
        cv.addItem("A2", "A2", "assets/gfx/niveau_a2.png", 1, 3);
        cv.addItem("B1", "B1", "assets/gfx/niveau_b1.png", 1, 3);
        this.cbNiveau = new CustomCombobox(cv);
        this.cbNiveau.setRenderer(this.cbRenderer);
        this.cbNiveau.setMaximumRowCount(6);
        if (nummer == 0) {
            this.cbNiveau.setEnabled(true);
        } else {
            this.cbNiveau.setEnabled(false);
        }
        this.add((Component)this.cbNiveau, cbc);
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/Berufsziele_allgemein.png", 1, 3);
        cv.addItem("Gar", "Garten", "assets/gfx/Berufsziele_Gaertner.png", 1, 3);
        cv.addItem("Kue", "K\u00fcche", "assets/gfx/Berufsziele_Kochen.png", 1, 3);
        cv.addItem("La", "Lager/Fabrik", "assets/gfx/Berufsziele_Lager.png", 1, 3);
        cv.addItem("Nae", "N\u00e4hen", "assets/gfx/Berufsziele_Naehen.png", 1, 3);
        cv.addItem("Put", "Putzen", "assets/gfx/Berufsziele_Putzen.png", 1, 3);
        cv.addItem("Ver", "Verkauf", "assets/gfx/Berufsziele_Verkaufen.png", 1, 3);
        cv.addItem("Bau", "Bau", "assets/gfx/Berufsziele_Baustelle.png", 2, 3);
        cv.addItem("Pfl", "Pflege", "assets/gfx/Berufsziele_Altenpflege.png", 2, 3);
        cv.addItem("Kin", "Kinderbetreuung", "assets/gfx/Berufsziele_Kinderbetreuung.png", 3, 3);
        cv.addItem("Tax", "Taxifahrer", "assets/gfx/Berufsziele_Taxifahrer.png", 3, 3);
        cv.addItem("Fris", "Friseur", "assets/gfx/Berufsziele_Friseur.png", 3, 3);
        cv.addItem("Mal", "Maler u. Lackierer", "assets/gfx/Berufsziele_Maler und Lackierer.png", 3, 3);
        cv.addItem("All", "Allgemeines", "assets/gfx/Berufsziele_allgemeines.png", 3, 3);
        this.cbArbeit = new CustomCombobox(cv);
        this.cbArbeit.setRenderer(this.cbRenderer);
        this.cbArbeit.setMaximumRowCount(6);
        this.cbArbeit.setEnabled(false);
        this.add((Component)this.cbArbeit, cbc);
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/stationen_allgemein.png", 1, 3);
        cv.addItem("1", "T\u00e4tigkeit (1)", "assets/gfx/Stationen_Taetigkeiten_im_Beruf.png", 1, 3);
        cv.addItem("2", "Werkzeuge (2)", "assets/gfx/Stationen_Werkzeuge_und_Instrumente.png", 1, 3);
        cv.addItem("3", "Ort (3)", "assets/gfx/Stationen_Arbeitsorte.png", 1, 3);
        cv.addItem("4", "Schrift (4)", "assets/gfx/Stationen_Schrift_am_Ort.png", 1, 3);
        this.cbStation = new CustomCombobox(cv);
        this.cbStation.setRenderer(this.cbRenderer);
        this.cbStation.setMaximumRowCount(6);
        this.cbStation.setEnabled(false);
        this.add((Component)this.cbStation, cbc);
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/aufgabenebene_allgemein.png", 1, 3);
        cv.addItem("B", "Buchstabe", "assets/gfx/Aufgabenebene_Buchstabe.png", 1, 1);
        cv.addItem("Sil", "Silbe", "assets/gfx/Aufgabenebene_Silbe.png", 1, 1);
        cv.addItem("Wo", "Wort", "assets/gfx/Aufgabenebene_Wort.png", 1, 2);
        cv.addItem("Sa", "Satz", "assets/gfx/Aufgabenebene_Satz.png", 1, 3);
        cv.addItem("Te", "Text", "assets/gfx/Aufgabenebene_Text.png", 1, 3);
        cv.addItem("Gr", "Grammatik", "assets/gfx/Aufgabenebene_Schau_genau.png", 1, 3);
        cv.addItem("K", "Karten", "assets/gfx/Aufgabenebene_Wort-Bild-Karten.png", 1, 2);
        cv.addItem("Spiel", "Spiel", "assets/gfx/Aufgabenebene_Spiel.png", 1, 3);
        cv.addItem("Glossar", "Glossar", "assets/gfx/Aufgabenebene_Glossar.png", 3, 3);
        this.cbAufgabe = new CustomCombobox(cv);
        this.cbAufgabe.setRenderer(this.cbRenderer);
        this.cbAufgabe.setMaximumRowCount(6);
        this.cbAufgabe.setEnabled(false);
        this.add((Component)this.cbAufgabe, cbc);
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/fertigkeiten_allgemein.png", 1, 3);
        cv.addItem("Hoe", "H\u00f6ren", "assets/gfx/Fertigkeiten_Hoeren.png", 1, 3);
        cv.addItem("Spr", "Sprechen", "assets/gfx/Fertigkeiten_Sprechen.png", 1, 3);
        cv.addItem("Les", "Lesen", "assets/gfx/Fertigkeiten_Lesen.png", 1, 3);
        cv.addItem("Sch", "Schreiben", "assets/gfx/Fertigkeiten_Schreiben.png", 1, 3);
        this.cbFertigkeit = new CustomCombobox(cv);
        this.cbFertigkeit.setRenderer(this.cbRenderer);
        this.cbFertigkeit.setMaximumRowCount(6);
        this.cbFertigkeit.setEnabled(false);
        this.add((Component)this.cbFertigkeit, cbc);
        cv = new ComboVector();
        cv.addItem("", "", "assets/gfx/stufe_allgemein.png", 1, 3);
        cv.addItem("l", "leicht", "assets/gfx/Stufe_leicht.png", 1, 3);
        cv.addItem("m", "mittel", "assets/gfx/Stufe_mittel.png", 1, 3);
        cv.addItem("s", "schwer", "assets/gfx/Stufe_schwer.png", 1, 3);
        this.cbStufe = new CustomCombobox(cv);
        this.cbStufe.setRenderer(this.cbRenderer);
        this.cbStufe.setMaximumRowCount(6);
        this.cbStufe.setEnabled(false);
        this.add((Component)this.cbStufe, cbc);
        this.cbNiveau.addActionListener(this);
        this.cbAufgabe.addActionListener(this);
    }

    @Override
    public String toString() {
        String strFile = "";
        ComboItem ci = null;
        String niveau = "";
        String arbeit = "";
        String station = "";
        String aufgabe = "";
        String fertigkeit = "";
        String stufe = "";
        ci = (ComboItem)this.cbNiveau.getSelectedItem();
        if (this.cbNiveau.isEnabled()) {
            niveau = ci.getId();
        }
        ci = (ComboItem)this.cbArbeit.getSelectedItem();
        if (this.cbArbeit.isEnabled()) {
            arbeit = ci.getId();
        }
        ci = (ComboItem)this.cbStation.getSelectedItem();
        if (this.cbStation.isEnabled()) {
            station = ci.getId();
        }
        ci = (ComboItem)this.cbAufgabe.getSelectedItem();
        if (this.cbAufgabe.isEnabled()) {
            aufgabe = ci.getId();
        }
        ci = (ComboItem)this.cbFertigkeit.getSelectedItem();
        if (this.cbFertigkeit.isEnabled()) {
            fertigkeit = ci.getId();
        }
        ci = (ComboItem)this.cbStufe.getSelectedItem();
        if (this.cbStufe.isEnabled()) {
            stufe = ci.getId();
        }
        if (aufgabe.equals("Basis")) {
            return this.getBasisText("Basis");
        }
        if (aufgabe.equals("Glossar")) {
            return this.getBasisText("Glossar");
        }
        if (aufgabe.equals("Spiel")) {
            return this.getBasisText("Spiel");
        }
        if (aufgabe.equals("K")) {
            return this.getBasisText("K");
        }
        if (aufgabe.equals("Gr") && niveau.equals("A1")) {
            return this.getBasisText("Gr");
        }
        if (niveau != "" && arbeit != "" && station != "" && aufgabe != "" && fertigkeit != "" && stufe != "") {
            strFile = String.valueOf(niveau) + "/" + arbeit + "/" + niveau + "_" + arbeit + "_" + station + "_" + aufgabe + "_" + fertigkeit + "_" + stufe + ".pdf";
        } else {
            strFile = "!";
            if (niveau != "" || arbeit != "" || station != "" || aufgabe != "" || fertigkeit != "" || stufe != "") {
                strFile = "?";
            }
        }
        return strFile;
    }

    public String getBasisText(String typ) {
        String basis = "";
        ComboItem ci = null;
        ci = (ComboItem)this.cbNiveau.getSelectedItem();
        String niveau = ci.getId();
        ci = (ComboItem)this.cbArbeit.getSelectedItem();
        String arbeit = ci.getId();
        ci = (ComboItem)this.cbStation.getSelectedItem();
        String station = ci.getId();
        ci = (ComboItem)this.cbAufgabe.getSelectedItem();
        String aufgabe = ci.getId();
        ci = (ComboItem)this.cbFertigkeit.getSelectedItem();
        String fertigkeit = ci.getId();
        if (niveau != "" && arbeit != "" && station != "" && aufgabe != "" && !typ.equals("Gr")) {
            basis = String.valueOf(niveau) + "/" + arbeit + "/" + niveau + "_" + arbeit + "_" + station + "_" + typ + ".pdf";
        } else {
            basis = "!";
            if (niveau != "" || arbeit != "" || station != "" || aufgabe != "") {
                basis = "?";
            }
        }
        basis = String.valueOf(niveau) + "/" + arbeit + "/" + niveau + "_" + arbeit + "_" + station + "_" + typ + ".pdf";
        if (typ.equals("Gr") && fertigkeit != "") {
            basis = String.valueOf(niveau) + "/" + arbeit + "/" + niveau + "_" + arbeit + "_" + station + "_" + typ + "_" + fertigkeit + ".pdf";
        }
        if (typ.equals("Gr") && fertigkeit == "") {
            basis = "!";
        }
        return basis;
    }

    public HashMap<String, String> getIcons() {
        HashMap<String, String> map = new HashMap<String, String>();
        ComboItem ci = null;
        ci = (ComboItem)this.cbNiveau.getSelectedItem();
        String niveau = ci.getIconDatei();
        if (ci.getId() != "") {
            map.put("niveau", niveau);
        }
        ci = (ComboItem)this.cbArbeit.getSelectedItem();
        String arbeit = ci.getIconDatei();
        if (ci.getId() != "") {
            map.put("arbeit", arbeit);
        }
        if (this.cbStation.isEnabled()) {
            ci = (ComboItem)this.cbStation.getSelectedItem();
            String station = ci.getIconDatei();
            if (ci.getId() != "") {
                map.put("station", station);
            }
        }
        if (this.cbAufgabe.isEnabled()) {
            ci = (ComboItem)this.cbAufgabe.getSelectedItem();
            String aufgabe = ci.getIconDatei();
            if (ci.getId() != "") {
                map.put("aufgabe", aufgabe);
            }
        }
        if (this.cbFertigkeit.isEnabled()) {
            ci = (ComboItem)this.cbFertigkeit.getSelectedItem();
            String fertigkeit = ci.getIconDatei();
            if (ci.getId() != "") {
                map.put("fertigkeit", fertigkeit);
            }
        }
        if (this.cbStufe.isEnabled()) {
            ci = (ComboItem)this.cbStufe.getSelectedItem();
            String stufe = ci.getIconDatei();
            if (ci.getId() != "") {
                map.put("stufe", stufe);
            }
        }
        return map;
    }

    public void meldung(boolean wert, String m, Color farbe) {
        this.lbMeldung.setText(m);
        this.lbMeldung.setVisible(wert);
        this.lbMeldung.setForeground(farbe);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        block15: {
            block14: {
                if (!ae.getSource().equals(this.cbNiveau)) break block14;
                if (this.cbNiveau.getSelectedItem().equals("")) break block15;
                this.cbArbeit.setEnabled(true);
                this.cbStation.setEnabled(true);
                this.cbAufgabe.setEnabled(true);
                this.cbFertigkeit.setEnabled(true);
                this.cbStufe.setEnabled(true);
                this.updateFertigkeitenUndStufe();
                int niveau = 1;
                switch (this.cbNiveau.getSelectedItem().toString()) {
                    case "A1": {
                        niveau = 1;
                        break;
                    }
                    case "A2": {
                        niveau = 2;
                        break;
                    }
                    case "B1": {
                        niveau = 3;
                    }
                }
                this.cbArbeit.updateNiveau(niveau);
                this.cbStation.updateNiveau(niveau);
                this.cbAufgabe.updateNiveau(niveau);
                this.cbFertigkeit.updateNiveau(niveau);
                this.cbStufe.updateNiveau(niveau);
                break block15;
            }
            if (ae.getSource().equals(this.cbAufgabe)) {
                this.updateFertigkeitenUndStufe();
            }
        }
        this.wochenplan.tagesplanAuswahl(this);
    }

    public void updateFertigkeitenUndStufe() {
        if (this.cbAufgabe.getSelectedItem().toString().equals("Glossar") || this.cbAufgabe.getSelectedItem().toString().equals("Spiel") || this.cbAufgabe.getSelectedItem().toString().equals("Karten")) {
            this.cbFertigkeit.setEnabled(false);
            this.cbStufe.setEnabled(false);
        } else {
            this.cbFertigkeit.setEnabled(true);
            this.cbStufe.setEnabled(true);
        }
        if (this.cbAufgabe.getSelectedItem().toString().equals("Grammatik")) {
            this.cbFertigkeit.setEnabled(true);
            if (this.cbNiveau.getSelectedItem().toString().equals("A1")) {
                this.cbStufe.setEnabled(false);
            } else {
                this.cbStufe.setEnabled(true);
            }
        }
    }

    public int getNummer() {
        return this.nummer;
    }

    public void setNummer(int nummer) {
        this.nummer = nummer;
    }

    public CustomCombobox getCbNiveau() {
        return this.cbNiveau;
    }

    public void setCbNiveau(CustomCombobox cbNiveau) {
        this.cbNiveau = cbNiveau;
    }

    public CustomCombobox getCbArbeit() {
        return this.cbArbeit;
    }

    public void setCbArbeit(CustomCombobox cbArbeit) {
        this.cbArbeit = cbArbeit;
    }

    public CustomCombobox getCbStation() {
        return this.cbStation;
    }

    public void setCbStation(CustomCombobox cbStation) {
        this.cbStation = cbStation;
    }

    public CustomCombobox getCbAufgabe() {
        return this.cbAufgabe;
    }

    public void setCbAufgabe(CustomCombobox cbAufgabe) {
        this.cbAufgabe = cbAufgabe;
    }

    public CustomCombobox getCbFertigkeit() {
        return this.cbFertigkeit;
    }

    public void setCbFertigkeit(CustomCombobox cbFertigkeit) {
        this.cbFertigkeit = cbFertigkeit;
    }

    public CustomCombobox getCbStufe() {
        return this.cbStufe;
    }

    public void setCbStufe(CustomCombobox cbStufe) {
        this.cbStufe = cbStufe;
    }

    public ComboboxRenderer getCbRenderer() {
        return this.cbRenderer;
    }

    public void setCbRenderer(ComboboxRenderer cbRenderer) {
        this.cbRenderer = cbRenderer;
    }
}

