/*
 * Decompiled with CFR 0.152.
 */
package de.unimuenster.alphaportfolio;

import de.unimuenster.alphaportfolio.Wochenplan;
import java.awt.image.BufferedImage;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import javax.swing.JOptionPane;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPrinter;
import org.apache.pdfbox.printing.Scaling;

public class PDFWochenplan
extends PDDocument {
    private PDFont font;
    private float fontSize = 12.0f;
    private int wDatum = 65;
    private int wNiveau = 50;
    private int wZiel = 115;
    private int wStation = 110;
    private int wAufgabenebene = 80;
    private int wFertigkeit = 75;
    private int wStufe = 75;
    private int wWieLange = 70;
    private int wLeichtOderSchwer = 100;
    private int xDatum = 30;
    private int xNiveau = this.xDatum + this.wDatum;
    private int xZiel = this.xNiveau + this.wNiveau;
    private int xStation = this.xZiel + this.wZiel;
    private int xAufgabenebene = this.xStation + this.wStation;
    private int xFertigkeit = this.xAufgabenebene + this.wAufgabenebene;
    private int xStufe = this.xFertigkeit + this.wFertigkeit;
    private int xWieLange = this.xStufe + this.wStufe;
    private int xLeichtOderSchwer = this.xWieLange + this.wWieLange + 20;

    public PDFWochenplan() {
        try {
            this.font = PDTrueTypeFont.loadTTF((PDDocument)this, (File)new File("assets/fnt/OpenSans-Semibold.ttf"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPDF(String vorname, String nachname, Wochenplan wochenplan, String dateiname) {
        PDPage page = new PDPage(PDRectangle.A4);
        page.setRotation(90);
        PDRectangle pageSize = page.getMediaBox();
        float pageWidth = pageSize.getWidth();
        this.addPage(page);
        try {
            try {
                float halfwidth = 0.0f;
                PDPageContentStream pcs = new PDPageContentStream((PDDocument)this, page);
                pcs.concatenate2CTM(0.0, 1.0, -1.0, 0.0, (double)pageWidth, 0.0);
                pcs.beginText();
                pcs.setFont(this.font, this.fontSize);
                pcs.moveTextPositionByAmount(40.0f, 550.0f);
                pcs.drawString("Wochenplan f\u00fcr die Woche vom " + wochenplan.getVon() + " bis zum " + wochenplan.getBis());
                pcs.moveTextPositionByAmount(0.0f, -18.0f);
                pcs.drawString("Vorname: " + vorname);
                pcs.moveTextPositionByAmount(0.0f, -18.0f);
                pcs.drawString("Nachname: " + nachname);
                pcs.endText();
                pcs.drawLine(30.0f, 500.0f, 810.0f, 500.0f);
                pcs.beginText();
                String txt = "Datum";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xDatum + this.wDatum / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Niveau";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xNiveau + this.wNiveau / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Ziel";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xZiel + this.wZiel / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Station";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xStation + this.wStation / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Aufgaben-";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xAufgabenebene + this.wAufgabenebene / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "ebene";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xAufgabenebene + this.wAufgabenebene / 2) - halfwidth, 460.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Fertigkeit";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xFertigkeit + this.wFertigkeit / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Stufe";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xStufe + this.wStufe / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Wie lange?";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xWieLange + this.wWieLange / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                pcs.beginText();
                txt = "Leicht oder schwer?";
                halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                pcs.moveTextPositionByAmount((float)(this.xLeichtOderSchwer + this.wLeichtOderSchwer / 2) - halfwidth, 480.0f);
                pcs.drawString(txt);
                pcs.endText();
                BufferedImage bim = ImageIO.read(new File("assets/gfx/logo_128.png"));
                PDImageXObject pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                pcs.drawImage(pdImage, 650.0f, 520.0f);
                bim = ImageIO.read(new File("assets/gfx/Datum_Kalender.png"));
                pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                pcs.drawImage(pdImage, (float)(this.xDatum + this.wDatum / 2 - pdImage.getWidth() / 2), 440.0f);
                bim = ImageIO.read(new File("assets/gfx/wie_lange.png"));
                pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                pcs.drawImage(pdImage, (float)(this.xWieLange + this.wWieLange / 2 - pdImage.getWidth() / 2), 440.0f);
                int i = 0;
                while (i < wochenplan.getTagesplaene().size()) {
                    pcs.beginText();
                    halfwidth = 10.0f;
                    txt = "____.____.";
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xDatum + this.wDatum / 2) - halfwidth, (float)(380 - i * 80 + 25));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = "__________";
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xDatum + this.wDatum / 2) - halfwidth, (float)(380 - i * 80 - 5));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbNiveau().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xNiveau + this.wNiveau / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbArbeit().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xZiel + this.wZiel / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbStation().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xStation + this.wStation / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbAufgabe().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xAufgabenebene + this.wAufgabenebene / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbFertigkeit().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xFertigkeit + this.wFertigkeit / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = wochenplan.getTagesplaene().get(i).getCbStufe().getSelectedItem().toString();
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xStufe + this.wStufe / 2) - halfwidth, (float)(380 - i * 80));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = "____ ____";
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xWieLange + this.wWieLange / 2) - halfwidth, (float)(380 - i * 80 + 20));
                    pcs.drawString(txt);
                    pcs.endText();
                    pcs.beginText();
                    txt = "Minuten";
                    halfwidth = this.font.getStringWidth(txt) / 1000.0f * this.fontSize / 2.0f;
                    pcs.moveTextPositionByAmount((float)(this.xWieLange + this.wWieLange / 2) - halfwidth, (float)(380 - i * 80 - 10));
                    pcs.drawString(txt);
                    pcs.endText();
                    ++i;
                }
                i = 0;
                while (i < wochenplan.getTagesplaene().size()) {
                    String stufe;
                    String fertigkeit;
                    String aufgabe;
                    String station;
                    String ziel;
                    int iconY = 395;
                    HashMap<String, String> map = wochenplan.getTagesplaene().get(i).getIcons();
                    String niveau = map.get("niveau");
                    if (niveau != null && niveau != "") {
                        bim = ImageIO.read(new File(niveau));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xNiveau + this.wNiveau / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if ((ziel = map.get("arbeit")) != null && ziel != "") {
                        bim = ImageIO.read(new File(ziel));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xZiel + this.wZiel / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if ((station = map.get("station")) != null && station != "") {
                        bim = ImageIO.read(new File(station));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xStation + this.wStation / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if ((aufgabe = map.get("aufgabe")) != null && aufgabe != "") {
                        bim = ImageIO.read(new File(aufgabe));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xAufgabenebene + this.wAufgabenebene / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if ((fertigkeit = map.get("fertigkeit")) != null && fertigkeit != "") {
                        bim = ImageIO.read(new File(fertigkeit));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xFertigkeit + this.wFertigkeit / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if ((stufe = map.get("stufe")) != null && stufe != "") {
                        bim = ImageIO.read(new File(stufe));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, (float)(this.xStufe + this.wStufe / 2 - pdImage.getWidth() / 2), (float)(iconY - i * 80));
                    }
                    if (niveau != null && niveau != "") {
                        bim = ImageIO.read(new File("assets/gfx/leicht_oder_schwer_wochenplan.png"));
                        pdImage = LosslessFactory.createFromImage((PDDocument)this, (BufferedImage)bim);
                        pcs.drawImage(pdImage, 680.0f, (float)(iconY - i * 80));
                    }
                    ++i;
                }
                pcs.drawLine(30.0f, 435.0f, 810.0f, 435.0f);
                pcs.drawLine(30.0f, 500.0f, 30.0f, 40.0f);
                pcs.drawLine(810.0f, 500.0f, 810.0f, 40.0f);
                pcs.drawLine(30.0f, 40.0f, 810.0f, 40.0f);
                i = 1;
                while (i < 5) {
                    pcs.drawLine(30.0f, (float)(40 + i * 80), 810.0f, (float)(40 + i * 80));
                    ++i;
                }
                int xPos = this.xDatum + this.wDatum;
                pcs.drawLine((float)xPos, 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wNiveau), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wZiel), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wStation), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wAufgabenebene), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wFertigkeit), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wStufe), 40.0f, (float)xPos, 500.0f);
                pcs.drawLine((float)(xPos += this.wWieLange), 40.0f, (float)xPos, 500.0f);
                pcs.beginText();
                pcs.setFont(this.font, 10.0f);
                pcs.moveTextPositionByAmount(30.0f, 20.0f);
                pcs.drawString("\u00a9 Alphaportfolio");
                pcs.endText();
                pcs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(wochenplan, "Fehler beim erstellen des Wochenplans");
                try {
                    if (dateiname == "") {
                        this.save(new File("assets/pdf/wochenplaene/plan.pdf"));
                    } else {
                        this.save(new File(dateiname));
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    JOptionPane.showMessageDialog(wochenplan, "Fehler beim Speichern von " + dateiname);
                }
            }
        }
        finally {
            try {
                if (dateiname == "") {
                    this.save(new File("assets/pdf/wochenplaene/plan.pdf"));
                } else {
                    this.save(new File(dateiname));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(wochenplan, "Fehler beim Speichern von " + dateiname);
            }
        }
    }

    public void printPDF(PrinterJob printJob, PrintService printService) {
        try {
            PDFPrinter printer = new PDFPrinter((PDDocument)this, Scaling.ACTUAL_SIZE, Orientation.AUTO);
            PrinterJob printPDFJob = PrinterJob.getPrinterJob();
            printPDFJob.setPrintService(printService);
            printPDFJob.setPageable((Pageable)printer.getPageable());
            printer.silentPrint(printPDFJob);
        }
        catch (PrinterException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Wochenplan konnte nicht gedruckt werden.");
        }
    }
}

