/*
 * Decompiled with CFR 0.152.
 */
package de.unimuenster.alphaportfolio;

import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class ComboItem
extends JLabel {
    private static final long serialVersionUID = 6877355023696555314L;
    private String id;
    private String value;
    private String initialValue;
    private String iconDatei = null;
    private ImageIcon icon = null;
    private int maxNiveau = 3;
    private int minNiveau = 1;

    public void init() {
        this.setFont(this.getFont().deriveFont(16.0f));
        this.setOpaque(true);
    }

    public ComboItem(String id, String value, String icon, int minNiveau, int maxNiveau) {
        this.id = id;
        this.value = value;
        this.initialValue = value;
        this.icon = new ImageIcon(icon);
        this.setIcon(this.icon);
        this.iconDatei = icon;
        this.setText(value);
        this.maxNiveau = maxNiveau;
        this.minNiveau = minNiveau;
        if (maxNiveau < 3) {
            this.setEnabled(false);
            this.setFocusable(false);
            this.setValue("-1");
        }
        this.init();
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public void setIcon(ImageIcon icon) {
        this.icon = icon;
    }

    public int getMaxNiveau() {
        return this.maxNiveau;
    }

    public void setMaxNiveau(int maxNiveau) {
        this.maxNiveau = maxNiveau;
    }

    public String getIconDatei() {
        return this.iconDatei;
    }

    public void setIconDatei(String iconDatei) {
        this.iconDatei = iconDatei;
    }

    public int getMinNiveau() {
        return this.minNiveau;
    }

    public void setMinNiveau(int minNiveau) {
        this.minNiveau = minNiveau;
    }

    public void updateNiveau(int niveau) {
        if (niveau < this.minNiveau || niveau > this.maxNiveau) {
            this.setEnabled(false);
            this.setFocusable(false);
            this.setValue("-1");
        } else {
            this.setEnabled(true);
            this.setFocusable(true);
            this.setValue(this.initialValue);
        }
    }
}

