/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep;

import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.lsmp.djep.xjep.CommandVisitor;
import org.lsmp.djep.xjep.DeepCopyVisitor;
import org.lsmp.djep.xjep.Eval;
import org.lsmp.djep.xjep.MacroFunction;
import org.lsmp.djep.xjep.NodeFactory;
import org.lsmp.djep.xjep.PrintVisitor;
import org.lsmp.djep.xjep.SimplificationVisitor;
import org.lsmp.djep.xjep.SubstitutionVisitor;
import org.lsmp.djep.xjep.TreeUtils;
import org.lsmp.djep.xjep.XEvaluatorVisitor;
import org.lsmp.djep.xjep.XOperatorSet;
import org.lsmp.djep.xjep.XSymbolTable;
import org.lsmp.djep.xjep.XVariable;
import org.lsmp.djep.xjep.XVariableFactory;
import org.lsmp.djep.xjep.function.Define;
import org.lsmp.djep.xjep.function.FromBase;
import org.lsmp.djep.xjep.function.Max;
import org.lsmp.djep.xjep.function.MaxArg;
import org.lsmp.djep.xjep.function.Min;
import org.lsmp.djep.xjep.function.MinArg;
import org.lsmp.djep.xjep.function.Product;
import org.lsmp.djep.xjep.function.Simpson;
import org.lsmp.djep.xjep.function.Sum;
import org.lsmp.djep.xjep.function.ToBase;
import org.lsmp.djep.xjep.function.Trapezium;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.PostfixMathCommandI;

public class XJep
extends JEP {
    protected NodeFactory nf = null;
    protected TreeUtils tu = null;
    protected DeepCopyVisitor copier = null;
    protected SubstitutionVisitor subv = null;
    protected SimplificationVisitor simpv = null;
    protected CommandVisitor commandv = null;
    protected PrintVisitor pv = null;
    private VariableFactory vf = new XVariableFactory();
    private JEP ingrediant = null;

    public XJep() {
        this.symTab = new XSymbolTable(this.vf);
        this.nf = new NodeFactory(this);
        this.opSet = new XOperatorSet();
        this.tu = new TreeUtils();
        this.copier = new DeepCopyVisitor();
        this.subv = new SubstitutionVisitor();
        this.ev = new XEvaluatorVisitor();
        this.simpv = new SimplificationVisitor();
        this.commandv = new CommandVisitor();
        this.pv = new PrintVisitor();
        this.pv.addSpecialRule(this.opSet.getElement(), new PrintVisitor.PrintRulesI(){

            public void append(Node node, PrintVisitor printVisitor) throws ParseException {
                node.jjtGetChild(0).jjtAccept((ParserVisitor)printVisitor, null);
                node.jjtGetChild(1).jjtAccept((ParserVisitor)printVisitor, null);
            }
        });
    }

    protected XJep(XJep xJep) {
        super((JEP)xJep);
        this.commandv = xJep.commandv;
        this.copier = xJep.copier;
        this.ev = xJep.ev;
        this.nf = xJep.nf;
        this.opSet = xJep.opSet;
        this.pv = xJep.pv;
        this.simpv = xJep.simpv;
        this.subv = xJep.subv;
        this.tu = xJep.tu;
    }

    public XJep(JEP jEP) {
        this.ingrediant = jEP;
        this.nf = new NodeFactory(this);
        this.symTab = new XSymbolTable(this.vf);
        this.funTab = jEP.getFunctionTable();
        this.opSet = new XOperatorSet(jEP.getOperatorSet());
        this.tu = new TreeUtils();
        this.copier = new DeepCopyVisitor();
        this.subv = new SubstitutionVisitor();
        this.ev = new XEvaluatorVisitor();
        this.simpv = new SimplificationVisitor();
        this.commandv = new CommandVisitor();
        this.pv = new PrintVisitor();
    }

    public XJep newInstance() {
        XJep xJep = new XJep(this);
        return xJep;
    }

    public XJep newInstance(SymbolTable symbolTable) {
        XJep xJep = new XJep(this);
        xJep.symTab = symbolTable;
        return xJep;
    }

    public void addStandardFunctions() {
        if (this.ingrediant != null) {
            this.ingrediant.addStandardFunctions();
        } else {
            super.addStandardFunctions();
        }
        this.addFunction("eval", (PostfixMathCommandI)new Eval());
        this.addFunction("Sum", (PostfixMathCommandI)new Sum(this));
        this.addFunction("Product", (PostfixMathCommandI)new Product());
        this.addFunction("Min", (PostfixMathCommandI)new Min());
        this.addFunction("Max", (PostfixMathCommandI)new Max());
        this.addFunction("MinArg", (PostfixMathCommandI)new MinArg());
        this.addFunction("MaxArg", (PostfixMathCommandI)new MaxArg());
        this.addFunction("Simpson", (PostfixMathCommandI)new Simpson());
        this.addFunction("Trapezium", (PostfixMathCommandI)new Trapezium());
        this.addFunction("toBase", (PostfixMathCommandI)new ToBase());
        this.addFunction("toHex", (PostfixMathCommandI)new ToBase(16, "0x"));
        this.addFunction("fromBase", (PostfixMathCommandI)new FromBase());
        this.addFunction("fromHex", (PostfixMathCommandI)new FromBase(16, "0x"));
        this.addFunction("exp", (PostfixMathCommandI)new Exp());
        this.addFunction("Define", (PostfixMathCommandI)new Define(this));
        try {
            MacroFunction macroFunction = new MacroFunction("sec", 1, "1/cos(x)", this);
            this.addFunction("sec", (PostfixMathCommandI)macroFunction);
            MacroFunction macroFunction2 = new MacroFunction("cosec", 1, "1/sin(x)", this);
            this.addFunction("cosec", (PostfixMathCommandI)macroFunction2);
            MacroFunction macroFunction3 = new MacroFunction("cot", 1, "1/tan(x)", this);
            this.addFunction("cot", (PostfixMathCommandI)macroFunction3);
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
        }
    }

    public void addStandardConstants() {
        if (this.ingrediant != null) {
            this.ingrediant.addStandardConstants();
            Enumeration enumeration = this.ingrediant.getSymbolTable().elements();
            while (enumeration.hasMoreElements()) {
                Variable variable = (Variable)enumeration.nextElement();
                if (!variable.isConstant()) continue;
                this.symTab.addConstant(variable.getName(), variable.getValue());
            }
        } else {
            super.addStandardConstants();
        }
    }

    public void addComplex() {
        if (this.ingrediant != null) {
            this.ingrediant.addComplex();
        } else {
            super.addComplex();
        }
        try {
            MacroFunction macroFunction = new MacroFunction("macrocomplex", 2, "x+i*y", this);
            this.addFunction("macrocomplex", (PostfixMathCommandI)macroFunction);
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
        }
    }

    public Node deepCopy(Node node) throws ParseException {
        return this.copier.deepCopy(node, this);
    }

    public Node simplify(Node node) throws ParseException {
        return this.simpv.simplify(node, this);
    }

    public Node preprocess(Node node) throws ParseException {
        return this.commandv.process(node, this);
    }

    public Node substitute(Node node, String string, Node node2) throws ParseException {
        return this.subv.substitute(node, string, node2, this);
    }

    public Node substitute(Node node, String[] stringArray, Node[] nodeArray) throws ParseException {
        return this.subv.substitute(node, stringArray, nodeArray, this);
    }

    public void print(Node node) {
        this.pv.print(node);
    }

    public void print(Node node, PrintStream printStream) {
        this.pv.print(node, printStream);
    }

    public void println(Node node) {
        this.pv.println(node);
    }

    public void println(Node node, PrintStream printStream) {
        this.pv.println(node, printStream);
    }

    public String toString(Node node) {
        return this.pv.toString(node);
    }

    public NodeFactory getNodeFactory() {
        return this.nf;
    }

    public TreeUtils getTreeUtils() {
        return this.tu;
    }

    public PrintVisitor getPrintVisitor() {
        return this.pv;
    }

    public Object calcVarValue(String string) throws Exception {
        XVariable xVariable = (XVariable)this.getVar(string);
        return xVariable.calcValue(this);
    }

    public Node continueParsing() throws ParseException {
        return this.parser.continueParse();
    }

    public void restartParser(String string) {
        this.parser.restart((Reader)new StringReader(string), (JEP)this);
    }

    public void restartParser(Reader reader) {
        this.parser.restart(reader, (JEP)this);
    }

    public Vector getVarsInEquation(Node node, Vector vector) {
        if (node instanceof ASTVarNode) {
            Variable variable = ((ASTVarNode)node).getVar();
            if (!vector.contains(variable)) {
                vector.add(variable);
            }
        } else if (node instanceof ASTFunNode) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.getVarsInEquation(node.jjtGetChild(i), vector);
            }
        }
        return vector;
    }

    public Vector recursiveGetVarsInEquation(Node node, Vector vector) throws ParseException {
        if (node instanceof ASTVarNode) {
            XVariable xVariable = (XVariable)((ASTVarNode)node).getVar();
            if (!vector.contains((Object)xVariable)) {
                if (xVariable.hasEquation()) {
                    this.recursiveGetVarsInEquation(xVariable.getEquation(), vector);
                }
                if (vector.contains((Object)xVariable)) {
                    throw new ParseException("Recursive definition for " + xVariable.getName());
                }
                vector.add(xVariable);
            }
        } else if (node instanceof ASTFunNode) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                this.recursiveGetVarsInEquation(node.jjtGetChild(i), vector);
            }
        }
        return vector;
    }

    public Object evaluate(PostfixMathCommandI postfixMathCommandI, Node node) throws ParseException {
        return super.evaluate(node);
    }
}

