/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;

public class Tensor
implements MatrixValueI {
    private Object[] values = null;
    private Dimensions dims;
    private int curEle = 0;

    private Tensor() {
    }

    public Tensor(Dimensions dimensions) {
        this.values = new Object[dimensions.numEles()];
        this.dims = dimensions;
    }

    public Tensor(Tensor tensor) {
        this.values = new Object[tensor.getDim().numEles()];
        this.dims = tensor.getDim();
    }

    public MatrixValueI copy() {
        Tensor tensor = new Tensor(this);
        tensor.setEles(tensor);
        return tensor;
    }

    public Tensor(int n, Dimensions dimensions) {
        this.values = new Object[n * dimensions.numEles()];
        this.dims = Dimensions.valueOf(n, dimensions);
    }

    public Dimensions getDim() {
        return this.dims;
    }

    public int getNumEles() {
        return this.values.length;
    }

    public void setEle(int n, Object object) {
        this.values[n] = object;
    }

    public Object getEle(int n) {
        return this.values[n];
    }

    public void setEles(MatrixValueI matrixValueI) {
        if (!this.dims.equals(matrixValueI.getDim())) {
            return;
        }
        System.arraycopy(((Tensor)matrixValueI).values, 0, this.values, 0, this.getNumEles());
    }

    public static MatrixValueI getInstance(Dimensions dimensions) {
        switch (dimensions.rank()) {
            case 0: {
                return new Scaler();
            }
            case 1: {
                return new MVector(dimensions.getFirstDim());
            }
            case 2: {
                return new Matrix(dimensions.getFirstDim(), dimensions.getLastDim());
            }
        }
        return new Tensor(dimensions);
    }

    private static MatrixValueI getInstance(int n, Dimensions dimensions) {
        switch (dimensions.rank()) {
            case 0: {
                return new MVector(n);
            }
            case 1: {
                return new Matrix(n, dimensions.getFirstDim());
            }
        }
        return new Tensor(Dimensions.valueOf(n, dimensions));
    }

    protected void bufferAppend(StringBuffer stringBuffer, int n) {
        stringBuffer.append("[");
        if (n + 1 >= this.dims.rank()) {
            for (int i = 0; i < this.dims.getIthDim(n); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.getEle(this.curEle++));
            }
        } else {
            for (int i = 0; i < this.dims.getIthDim(n); ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                this.bufferAppend(stringBuffer, n + 1);
            }
        }
        stringBuffer.append("]");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.curEle = 0;
        this.bufferAppend(stringBuffer, 0);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tensor)) {
            return false;
        }
        Tensor tensor = (Tensor)object;
        if (!tensor.getDim().equals(this.getDim())) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(tensor.values[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < this.values.length; ++i) {
            n = 37 * n + this.values[i].hashCode();
        }
        return n;
    }
}

