/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.values;

import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;

public class MVector
implements MatrixValueI {
    private Object[] data = null;
    private Dimensions dim;

    private MVector() {
    }

    public MVector(int n) {
        this.data = new Object[n];
        this.dim = Dimensions.valueOf(n);
    }

    public static MatrixValueI getInstance(int n) {
        return new MVector(n);
    }

    private static MatrixValueI getInstance(Object[] objectArray) {
        if (objectArray.length == 1) {
            return Scaler.getInstance(objectArray[0]);
        }
        MVector mVector = new MVector(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            mVector.setEle(i, objectArray[i]);
        }
        return mVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.data[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Dimensions getDim() {
        return this.dim;
    }

    public int getNumEles() {
        return this.data.length;
    }

    public void setEle(int n, Object object) {
        this.data[n] = object;
    }

    public Object getEle(int n) {
        return this.data[n];
    }

    public void setEles(MatrixValueI matrixValueI) {
        if (!this.dim.equals(matrixValueI.getDim())) {
            return;
        }
        System.arraycopy(((MVector)matrixValueI).data, 0, this.data, 0, this.getNumEles());
    }

    public Object[] getEles() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MVector)) {
            return false;
        }
        MVector mVector = (MVector)object;
        if (!mVector.getDim().equals(this.getDim())) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].equals(mVector.data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        for (int i = 0; i < this.data.length; ++i) {
            n = 37 * n + this.data[i].hashCode();
        }
        return n;
    }

    public MatrixValueI copy() {
        MVector mVector = new MVector(this.data.length);
        mVector.setEles(this);
        return mVector;
    }
}

