/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Transpose
extends PostfixMathCommand
implements UnaryOperatorI {
    public Transpose() {
        this.numberOfParameters = 1;
    }

    public Dimensions calcDim(Dimensions dimensions) {
        return Dimensions.valueOf(dimensions.getLastDim(), dimensions.getFirstDim());
    }

    public MatrixValueI calcValue(MatrixValueI matrixValueI, MatrixValueI matrixValueI2) throws ParseException {
        if (!(matrixValueI instanceof Matrix)) {
            throw new ParseException("transpose: result must be a matrix");
        }
        if (!(matrixValueI2 instanceof Matrix)) {
            throw new ParseException("transpose: argument must be a matrix");
        }
        Matrix matrix = (Matrix)matrixValueI;
        Matrix matrix2 = (Matrix)matrixValueI2;
        if (matrix.getNumCols() != matrix2.getNumRows() || matrix.getNumRows() != matrix2.getNumCols()) {
            throw new ParseException("transpose, dimension of result is wrong res " + matrix.getDim() + " arg " + matrix2.getDim());
        }
        for (int i = 0; i < matrix.getNumRows(); ++i) {
            for (int j = 0; j < matrix.getNumCols(); ++j) {
                matrix.setEle(i, j, matrix2.getEle(j, i));
            }
        }
        return matrixValueI;
    }

    public void run(Stack stack) throws ParseException {
        MatrixValueI matrixValueI = (MatrixValueI)stack.pop();
        MatrixValueI matrixValueI2 = Tensor.getInstance(this.calcDim(matrixValueI.getDim()));
        this.calcValue(matrixValueI2, matrixValueI);
        stack.push(matrixValueI2);
    }
}

