/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.sjep;

import org.lsmp.djep.sjep.Monomial;
import org.lsmp.djep.sjep.PConstant;
import org.lsmp.djep.sjep.PNodeI;
import org.lsmp.djep.sjep.Polynomial;
import org.lsmp.djep.sjep.PolynomialCreator;
import org.nfunk.jep.ParseException;

public class MutiablePolynomial {
    PolynomialCreator pc;
    PNodeI[] terms;

    public MutiablePolynomial(PolynomialCreator polynomialCreator, PNodeI[] pNodeIArray) {
        this.pc = polynomialCreator;
        this.terms = pNodeIArray;
    }

    public void add(PNodeI pNodeI) throws ParseException {
        int n;
        if (pNodeI instanceof PConstant) {
            for (n = 0; n < this.terms.length; ++n) {
                if (!(this.terms[n] instanceof PConstant)) continue;
                this.terms[n] = this.terms[n].add(pNodeI);
                return;
            }
        }
        if (pNodeI instanceof Polynomial) {
            Polynomial polynomial = (Polynomial)pNodeI;
            for (int i = 0; i < polynomial.terms.length; ++i) {
                this.add(polynomial.terms[i]);
            }
            return;
        }
        for (n = 0; n < this.terms.length; ++n) {
            if (this.terms[n] instanceof Monomial) {
                if (!((Monomial)this.terms[n]).equalsIgnoreConstant(pNodeI)) continue;
                this.terms[n] = this.terms[n].add(pNodeI);
                return;
            }
            if (!this.terms[n].equals(pNodeI)) continue;
            this.terms[n] = this.terms[n].add(pNodeI);
            return;
        }
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length + 1];
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < this.terms.length; ++i) {
            if (!bl && this.terms[i].compareTo(pNodeI) > 0) {
                pNodeIArray[n2] = pNodeI;
                ++n2;
                bl = true;
            }
            pNodeIArray[n2] = this.terms[i];
            ++n2;
        }
        if (!bl) {
            pNodeIArray[n2] = pNodeI;
            ++n2;
        }
        this.terms = pNodeIArray;
    }

    void expandMul(Polynomial polynomial) throws ParseException {
        int n;
        int n2;
        PNodeI[][] pNodeIArray = new PNodeI[this.terms.length][polynomial.terms.length];
        for (n2 = 0; n2 < this.terms.length; ++n2) {
            for (n = 0; n < polynomial.terms.length; ++n) {
                pNodeIArray[n2][n] = this.terms[n2].mul(polynomial.terms[n]);
            }
        }
        n2 = this.terms.length;
        this.terms = new PNodeI[0];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < polynomial.terms.length; ++i) {
                this.add(pNodeIArray[n][i]);
            }
        }
    }

    void expandMul(PNodeI pNodeI) throws ParseException {
        int n;
        if (pNodeI instanceof Polynomial) {
            this.expandMul((Polynomial)pNodeI);
            return;
        }
        PNodeI[] pNodeIArray = new PNodeI[this.terms.length];
        for (n = 0; n < this.terms.length; ++n) {
            pNodeIArray[n] = this.terms[n].mul(pNodeI);
        }
        this.terms = new PNodeI[0];
        for (n = 0; n < pNodeIArray.length; ++n) {
            this.add(pNodeIArray[n]);
        }
    }

    private void reduce() throws ParseException {
        int n;
        int n2 = 0;
        int n3 = 0;
        PConstant pConstant = this.pc.zeroConstant;
        for (n = 0; n < this.terms.length; ++n) {
            if (this.terms[n].isZero()) {
                ++n2;
                continue;
            }
            if (!(this.terms[n] instanceof PConstant)) continue;
            ++n3;
            pConstant = (PConstant)pConstant.add(this.terms[n]);
        }
        if (n2 == 0 && n3 == 0) {
            return;
        }
        n = this.terms.length - n2 - n3;
        if (!pConstant.isZero()) {
            ++n;
        }
        PNodeI[] pNodeIArray = new PNodeI[n];
        int n4 = 0;
        if (!pConstant.isZero()) {
            pNodeIArray[n4++] = pConstant;
        }
        for (int i = 0; i < this.terms.length; ++i) {
            if (this.terms[i].isZero() || this.terms[i] instanceof PConstant) continue;
            pNodeIArray[n4] = this.terms[i];
            ++n4;
        }
        this.terms = pNodeIArray;
    }

    PNodeI toPNode() throws ParseException {
        this.reduce();
        if (this.terms.length == 0) {
            return this.pc.zeroConstant;
        }
        if (this.terms.length == 1) {
            return this.terms[0];
        }
        return new Polynomial(this.pc, this.terms);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                stringBuffer.append('+');
            }
            stringBuffer.append(((Object)this.terms[i]).toString());
        }
        return stringBuffer.toString();
    }
}

