/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.matrixJep;

import org.lsmp.djep.djep.DSymbolTable;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixNodeFactory;
import org.lsmp.djep.matrixJep.SpecialPreProcessorI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.function.NaryOperatorI;
import org.lsmp.djep.vectorJep.function.UnaryOperatorI;
import org.lsmp.djep.xjep.CommandVisitorI;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.function.PostfixMathCommandI;

public class MatrixPreprocessor
implements ParserVisitor {
    private MatrixJep mjep;
    private MatrixNodeFactory nf;
    private DSymbolTable vt;

    public MatrixNodeI preprocess(Node node, MatrixJep matrixJep) throws ParseException {
        this.mjep = matrixJep;
        this.nf = (MatrixNodeFactory)matrixJep.getNodeFactory();
        this.vt = (DSymbolTable)matrixJep.getSymbolTable();
        return (MatrixNodeI)node.jjtAccept((ParserVisitor)this, null);
    }

    public MatrixNodeI[] visitChildrenAsArray(Node node, Object object) throws ParseException {
        int n = node.jjtGetNumChildren();
        MatrixNodeI[] matrixNodeIArray = new MatrixNodeI[n];
        for (int i = 0; i < n; ++i) {
            MatrixNodeI matrixNodeI;
            matrixNodeIArray[i] = matrixNodeI = (MatrixNodeI)node.jjtGetChild(i).jjtAccept((ParserVisitor)this, object);
        }
        return matrixNodeIArray;
    }

    public Object visit(SimpleNode simpleNode, Object object) {
        return null;
    }

    public Object visit(ASTStart aSTStart, Object object) {
        return null;
    }

    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return this.nf.buildConstantNode(aSTConstant.getValue());
    }

    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        return this.nf.buildVariableNode(this.vt.getVar(aSTVarNode.getName()));
    }

    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        if (postfixMathCommandI instanceof SpecialPreProcessorI) {
            SpecialPreProcessorI specialPreProcessorI = (SpecialPreProcessorI)aSTFunNode.getPFMC();
            return specialPreProcessorI.preprocess(aSTFunNode, this, this.mjep, this.nf);
        }
        if (aSTFunNode.isOperator()) {
            return this.visitOp(aSTFunNode, object);
        }
        if (aSTFunNode.getPFMC() instanceof CommandVisitorI) {
            throw new IllegalArgumentException("MatrixPreprocessor: encountered and instance of CommandVisitorI  for function " + aSTFunNode.getName());
        }
        Node[] nodeArray = this.visitChildrenAsArray((Node)aSTFunNode, object);
        ASTMFunNode aSTMFunNode = (ASTMFunNode)this.nf.buildFunctionNode(aSTFunNode, nodeArray);
        return aSTMFunNode;
    }

    public Object visitOp(ASTFunNode aSTFunNode, Object object) throws ParseException {
        PostfixMathCommandI postfixMathCommandI = aSTFunNode.getPFMC();
        Node[] nodeArray = this.visitChildrenAsArray((Node)aSTFunNode, object);
        if (postfixMathCommandI instanceof BinaryOperatorI) {
            if (aSTFunNode.jjtGetNumChildren() != 2) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have two elements, it has " + nodeArray.length);
            }
            BinaryOperatorI binaryOperatorI = (BinaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = binaryOperatorI.calcDim(nodeArray[0].getDim(), nodeArray[1].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        if (postfixMathCommandI instanceof UnaryOperatorI) {
            if (nodeArray.length != 1) {
                throw new ParseException("Operator " + aSTFunNode.getOperator().getName() + " must have one elements, it has " + nodeArray.length);
            }
            UnaryOperatorI unaryOperatorI = (UnaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = unaryOperatorI.calcDim(nodeArray[0].getDim());
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        if (postfixMathCommandI instanceof NaryOperatorI) {
            Dimensions[] dimensionsArray = new Dimensions[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                dimensionsArray[i] = nodeArray[i].getDim();
            }
            NaryOperatorI naryOperatorI = (NaryOperatorI)postfixMathCommandI;
            Dimensions dimensions = naryOperatorI.calcDim(dimensionsArray);
            return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
        }
        Dimensions dimensions = Dimensions.ONE;
        return (ASTMFunNode)this.nf.buildOperatorNode(aSTFunNode.getOperator(), nodeArray, dimensions);
    }
}

