/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.updatecenter.dataxchange;

import info.bioinfweb.commons.appversion.AppVersionXMLConstants;
import info.bioinfweb.commons.appversion.AppVersionXMLReadWrite;
import info.bioinfweb.commons.appversion.ApplicationVersion;
import info.bioinfweb.commons.io.XMLUtils;
import info.bioinfweb.updatecenter.dataxchange.VersionXMLConstants;
import info.bioinfweb.updatecenter.dataxchange.beans.ApplicationVersionInfo;
import info.bioinfweb.updatecenter.dataxchange.beans.ListInfo;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class VersionListXMLReader
implements VersionXMLConstants {
    private XMLEventReader reader;
    private ListInfo<ApplicationVersionInfo> list = new ListInfo();

    private void readEntry() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        ApplicationVersionInfo entry = new ApplicationVersionInfo();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(AppVersionXMLConstants.TAG_APP_VERSION)) {
                    ApplicationVersion version = AppVersionXMLReadWrite.read((StartElement)element);
                    entry.setMajorRelease(version.getMajorRelease());
                    entry.setMinorRelease(version.getMinorRelease());
                    entry.setPatchLevel(version.getPatchLevel());
                    entry.setBuildNumber(version.getBuildNumber());
                    entry.setType(version.getType());
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_SINCE)) {
                    entry.setSince(new Date(Long.parseLong(this.reader.nextEvent().asCharacters().toString())));
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
        this.list.getEntries().add(entry);
    }

    private void readList() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_VERSION)) {
                    this.readEntry();
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readRoot() throws XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        while (event.getEventType() != 2) {
            if (event.getEventType() == 1) {
                StartElement element = event.asStartElement();
                if (element.getName().equals(TAG_LIST)) {
                    this.readList();
                    this.reader.nextEvent();
                } else if (element.getName().equals(TAG_VERSION_COUNT)) {
                    this.list.setOverallLength(Integer.parseInt(this.reader.nextEvent().asCharacters().toString()));
                    this.reader.nextEvent();
                } else {
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
            event = this.reader.nextEvent();
        }
    }

    private void readDocument() throws XMLStreamException {
        while (this.reader.hasNext()) {
            XMLEvent event = this.reader.nextEvent();
            switch (event.getEventType()) {
                case 7: {
                    break;
                }
                case 8: {
                    this.reader.close();
                    return;
                }
                case 1: {
                    StartElement element = event.asStartElement();
                    if (element.getName().equals(TAG_ROOT)) {
                        this.readRoot();
                        this.reader.nextEvent();
                        break;
                    }
                    XMLUtils.reachElementEnd((XMLEventReader)this.reader);
                }
            }
        }
    }

    public ListInfo<ApplicationVersionInfo> read(Reader r) throws XMLStreamException {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(r);
        this.list.clear();
        try {
            this.readDocument();
        }
        finally {
            this.reader.close();
        }
        return this.list;
    }

    public ListInfo<ApplicationVersionInfo> read(InputStream stream) throws XMLStreamException {
        this.reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
        this.list.clear();
        try {
            this.readDocument();
        }
        finally {
            this.reader.close();
        }
        return this.list;
    }

    public ListInfo<ApplicationVersionInfo> read(String data) throws XMLStreamException {
        return this.read(new StringReader(data));
    }
}

