/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe.ruler;

import info.bioinfweb.treegraph.gui.treeframe.ruler.RulerUnit;
import info.bioinfweb.treegraph.gui.treeframe.ruler.TreeViewRuler;
import info.bioinfweb.treegraph.gui.treeframe.ruler.TreeViewRulerConstants;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class TreeViewRulerUnitField
extends JComponent
implements TreeViewRulerConstants {
    public static final String TEXT_CENTIMETER = "cm";
    public static final String TEXT_INCH = "in";
    private TreeViewRuler horizontalRuler;
    private TreeViewRuler verticalRuler;

    public TreeViewRulerUnitField(TreeViewRuler horizontalRuler, TreeViewRuler vertivalRuler) {
        this.horizontalRuler = horizontalRuler;
        this.verticalRuler = vertivalRuler;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TreeViewRulerUnitField.this.getUnit().equals((Object)RulerUnit.CENTIMETER)) {
                    TreeViewRulerUnitField.this.setUnit(RulerUnit.INCH);
                } else {
                    TreeViewRulerUnitField.this.setUnit(RulerUnit.CENTIMETER);
                }
            }
        });
        Dimension d = new Dimension(20, 20);
        this.setPreferredSize(d);
        this.setSize(d);
    }

    private void setUnit(RulerUnit unit) {
        this.horizontalRuler.setUnit(unit);
        this.verticalRuler.setUnit(unit);
        this.repaint();
    }

    private RulerUnit getUnit() {
        return this.horizontalRuler.getUnit();
    }

    @Override
    protected void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(SystemColor.menu);
        g.fillRect(0, 0, 20, 20);
        String text = TEXT_CENTIMETER;
        if (this.getUnit().equals((Object)RulerUnit.INCH)) {
            text = TEXT_INCH;
        }
        g.setColor(SystemColor.menuText);
        g.setFont(FONT);
        FontMetrics fm = g.getFontMetrics();
        g.drawString(text, (20 - fm.stringWidth(text)) / 2, (20 - fm.getHeight()) / 2 + fm.getAscent());
    }
}

