/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe.ruler;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanelListener;
import info.bioinfweb.treegraph.gui.treeframe.ruler.RulerOrientation;
import info.bioinfweb.treegraph.gui.treeframe.ruler.RulerUnit;
import info.bioinfweb.treegraph.gui.treeframe.ruler.TreeViewRulerConstants;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;

public class TreeViewRuler
extends JPanel
implements Scrollable,
TreeViewPanelListener,
TreeViewRulerConstants {
    public static final float DASH_LENGTH = 10.0f;
    public static final float MIN_DASH_DISTANCE = 2.5f;
    public static final float LABEL_DISTANCE = -2.2f;
    public static final float SMALL_FACTOR = 0.5f;
    public static final float MEDIUM_FACTOR = 0.8f;
    public static final String LABEL_LENGTH_STANDARD = "000";
    private RulerOrientation orientation = RulerOrientation.VERTICAL;
    private RulerUnit unit = RulerUnit.CENTIMETER;
    private TreeViewPanel treeViewPanel = null;

    public TreeViewRuler(RulerOrientation orientation, TreeViewPanel treeViewPanel) {
        this.orientation = orientation;
        this.treeViewPanel = treeViewPanel;
        treeViewPanel.addTreeViewPanelListener(this);
        this.sizeChanged(new ChangeEvent(this));
    }

    public RulerUnit getUnit() {
        return this.unit;
    }

    public void setUnit(RulerUnit unit) {
        this.unit = unit;
        this.repaint();
    }

    public RulerOrientation getOrientation() {
        return this.orientation;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 20;
    }

    @Override
    public void selectionChanged(ChangeEvent e) {
    }

    @Override
    public void zoomChanged(ChangeEvent e) {
        this.repaint();
    }

    @Override
    public void sizeChanged(ChangeEvent e) {
        Dimension d = this.treeViewPanel.getPreferredSize();
        if (this.orientation.equals((Object)RulerOrientation.HORIZONTAL)) {
            d.height = 20;
        } else {
            d.width = 20;
        }
        this.setSize(d);
        this.setPreferredSize(d);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension result = this.orientation.equals((Object)RulerOrientation.HORIZONTAL) ? new Dimension(0, 20) : new Dimension(20, 0);
        return result;
    }

    @Override
    protected void paintComponent(Graphics g1) {
        int end;
        int interval2;
        int interval1;
        float stepLength;
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getUnit().equals((Object)RulerUnit.CENTIMETER)) {
            stepLength = this.treeViewPanel.pixelsPerMillimeter();
            interval1 = 5;
            interval2 = 10;
        } else {
            stepLength = this.treeViewPanel.pixelsPerMillimeter() / 2.8346457f;
            interval1 = 12;
            interval2 = 72;
        }
        DistanceDimension d = this.treeViewPanel.getDocument().getTree().getPaintDimension(this.treeViewPanel.getPainterType());
        if (this.orientation.equals((Object)RulerOrientation.HORIZONTAL)) {
            end = Math2.roundUp(d.getWidth().getInPixels(this.treeViewPanel.pixelsPerMillimeter()) / stepLength);
            g.setColor(SystemColor.menu);
            g.fillRect(0, 0, Math2.roundUp((float)end * stepLength), 20);
            g.setColor(SystemColor.menuText);
            g.draw(new Line2D.Float(0.0f, 19.0f, (float)end * stepLength, 19.0f));
        } else {
            end = Math2.roundUp(d.getHeight().getInPixels(this.treeViewPanel.pixelsPerMillimeter()) / stepLength);
            g.setColor(SystemColor.menu);
            g.fillRect(0, 0, 20, Math2.roundUp((float)end * stepLength));
            g.setColor(SystemColor.menuText);
            g.draw(new Line2D.Float(19.0f, 0.0f, 19.0f, (float)end * stepLength));
        }
        g.setFont(FONT);
        FontMetrics fm = g.getFontMetrics();
        int labelInterval = interval2 * Math2.roundUp((float)fm.stringWidth(LABEL_LENGTH_STANDARD) / ((float)interval2 * stepLength));
        int ascent = fm.getAscent();
        int pos = 0;
        while (pos < end) {
            float paintPos = (float)pos * stepLength;
            float dashLength = 10.0f;
            boolean draw = true;
            if (pos % interval2 != 0) {
                if (pos % interval1 == 0) {
                    dashLength *= 0.8f;
                    draw = stepLength * (float)interval1 >= 2.5f;
                } else {
                    dashLength *= 0.5f;
                    boolean bl = draw = stepLength >= 2.5f;
                }
            }
            if (draw) {
                g.setStroke(new BasicStroke(0.0f, 0, 2));
                Path2D.Float path = new Path2D.Float();
                if (this.orientation.equals((Object)RulerOrientation.HORIZONTAL)) {
                    ((Path2D)path).moveTo((double)paintPos - 0.5, 20.0);
                    ((Path2D)path).lineTo((double)paintPos + 0.5, 20.0);
                    ((Path2D)path).lineTo((double)paintPos + 0.5, 20.0f - dashLength);
                    ((Path2D)path).lineTo((double)paintPos - 0.5, 20.0f - dashLength);
                    path.closePath();
                } else {
                    ((Path2D)path).moveTo(20.0, (double)paintPos - 0.5);
                    ((Path2D)path).lineTo(20.0, (double)paintPos + 0.5);
                    ((Path2D)path).lineTo(20.0f - dashLength, (double)paintPos + 0.5);
                    ((Path2D)path).lineTo(20.0f - dashLength, (double)paintPos - 0.5);
                    path.closePath();
                }
                g.fill(path);
                if (pos % labelInterval == 0) {
                    float y;
                    float x;
                    AffineTransform oldTrans = g.getTransform();
                    AffineTransform trans = (AffineTransform)oldTrans.clone();
                    String text = "" + pos / interval2;
                    if (this.orientation.equals((Object)RulerOrientation.HORIZONTAL)) {
                        x = paintPos;
                        y = -2.2f;
                    } else {
                        x = -2.2f;
                        y = paintPos + (float)fm.stringWidth(text) - 1.0f;
                        trans.quadrantRotate(3, x, y);
                        g.setTransform(trans);
                    }
                    g.drawString(text, x, y + (float)ascent);
                    g.setTransform(oldTrans);
                }
            }
            ++pos;
        }
    }
}

