/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.commons.graphics.GraphicsUtils;
import info.bioinfweb.commons.swing.scrollpaneselector.ScrollPaneSelectable;
import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.document.change.DocumentChangeEvent;
import info.bioinfweb.treegraph.document.change.DocumentListener;
import info.bioinfweb.treegraph.document.format.DistanceDimension;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.document.format.PieChartLabelFormats;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanelListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;

public class TreeViewPanel
extends JPanel
implements DocumentListener,
Scrollable,
ScrollPaneSelectable {
    private static final long serialVersionUID = 1L;
    public static final Dimension START_MIN_SIZE = new Dimension(100, 60);
    public static final float SELECTION_MARGIN = 2.0f;
    public static final float PIXELS_PER_MM_100 = 2.8346457f;
    public static final float MIN_ZOOM = 0.1f;
    public static final Color DEFAULT_SELECTION_COLOR = Color.BLUE.brighter();
    public static final Color ALTERNATIVE_SELECTION_COLOR = Color.WHITE;
    public static final int MAX_SELECTION_COLOR_DIF = 200;
    private TreeSelection selection = new TreeSelection(this);
    private Document document = null;
    private float zoom = 1.0f;
    private PositionPaintType painterType = PositionPaintFactory.getDefaultType();
    private Vector<TreeViewPanelListener> treeViewListeners = new Vector(2, 2);

    public TreeViewPanel(Document document) {
        this.setLayout(null);
        this.setDocument(document);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public float pixelsPerMillimeter() {
        return 2.8346457f * this.getZoom();
    }

    public TreeSelection getSelection() {
        return this.selection;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeView(this);
        }
        if (document != null) {
            this.document = document;
            document.addView(this);
            document.registerPositioner(this.painterType);
            PositionPaintFactory.getInstance().getPositioner(this.painterType).positionAll(document, 1.0f);
            this.getSelection().set(null);
            this.changeHappened(new DocumentChangeEvent(document, null));
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom = Math.max(0.1f, zoom);
        this.assignPaintSize();
        this.repaint();
        this.fireZoomChanged();
    }

    public PositionPaintType getPainterType() {
        return this.painterType;
    }

    public void setPainterType(PositionPaintType type) {
        PositionPaintType oldType = this.painterType;
        this.painterType = type;
        if (this.getDocument() != null) {
            this.document.unregisterPositioner(oldType);
            this.document.registerPositioner(this.painterType);
            PositionPaintFactory.getInstance().getPositioner(this.painterType).positionAll(this.document, 1.0f);
            this.changeHappened(new DocumentChangeEvent(this.document, null));
        }
    }

    public void addTreeViewPanelListener(TreeViewPanelListener listener) {
        this.treeViewListeners.add(listener);
    }

    public boolean removeTreeViewPanelListener(TreeViewPanelListener listener) {
        return this.treeViewListeners.remove(listener);
    }

    public void fireSelectionChanged() {
        this.repaint();
        MainFrame.getInstance().getActionManagement().refreshActionStatus();
        int i = 0;
        while (i < this.treeViewListeners.size()) {
            this.treeViewListeners.get(i).selectionChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void fireZoomChanged() {
        int i = 0;
        while (i < this.treeViewListeners.size()) {
            this.treeViewListeners.get(i).zoomChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void fireSizeChanged() {
        int i = 0;
        while (i < this.treeViewListeners.size()) {
            this.treeViewListeners.get(i).sizeChanged(new ChangeEvent(this));
            ++i;
        }
    }

    private void assignPaintSize() {
        DistanceDimension d = this.getDocument().getTree().getPaintDimension(this.painterType);
        this.setSize(d.getWidth().getRoundedInPixels(this.pixelsPerMillimeter()), d.getHeight().getRoundedInPixels(this.pixelsPerMillimeter()));
        this.setPreferredSize(this.getSize());
        this.fireSizeChanged();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        PositionPaintFactory.getInstance().getPainter(this.painterType).paintTree(g2, this.getVisibleRect(), this.getDocument(), this.getSelection(), this.pixelsPerMillimeter(), false);
    }

    public void paintPreview(Graphics2D g, double scale) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        PositionPaintFactory.getInstance().getPainter(this.painterType).paintTree(g, this.getDocument(), this.getSelection(), this.pixelsPerMillimeter() * (float)scale, false);
    }

    @Override
    public void changeHappened(DocumentChangeEvent e) {
        this.getSelection().setValueIsAdjusting(true);
        try {
            Iterator<PaintableElement> iterator = this.getSelection().iterator();
            while (iterator.hasNext()) {
                if (this.document.getTree().contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        finally {
            this.getSelection().setValueIsAdjusting(false);
        }
        MainFrame.getInstance().getActionManagement().refreshActionStatus();
        this.assignPaintSize();
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 20;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 20;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        AbstractPaintableElement element = PositionPaintFactory.getInstance().getPositioner(this.getPainterType()).elementToPosition(this.getDocument(), DistanceValue.pixelsToMillimeters(e.getX(), this.pixelsPerMillimeter()), DistanceValue.pixelsToMillimeters(e.getY(), this.pixelsPerMillimeter()), 2.0f);
        if (element instanceof Node) {
            String text = "";
            if (!((Node)element).isLeaf()) {
                text = String.valueOf(text) + "Internal node name: \"" + ((Node)element).getData() + "\" \n";
            }
            if (((Node)element).hasUniqueName()) {
                text = String.valueOf(text) + "Unique name: \"" + ((Node)element).getUniqueName() + "\"";
            }
            if (!text.equals("")) {
                return text;
            }
        } else {
            if (element instanceof Branch) {
                if (((Branch)element).hasLength()) {
                    return "Branch length: " + ((Branch)element).getLength();
                }
                return "No branch length assigned.";
            }
            if (element instanceof Label) {
                PieChartLabel label;
                String id = ((Label)element).getID();
                StringBuilder result = new StringBuilder();
                if (id.equals("")) {
                    result.append("<html>No label ID defined for this label.");
                }
                result.append("<html>Label ID: \"" + id + "\"");
                if (element instanceof PieChartLabel && !(label = (PieChartLabel)element).getSectionDataList().isEmpty()) {
                    result.append(" (states: ");
                    PieChartLabelFormats formats = label.getFormats();
                    int i = 0;
                    while (i < label.getSectionDataList().size()) {
                        result.append("<span style='color: ");
                        result.append(GraphicsUtils.colorToHexString(formats.getPieColor(i)));
                        result.append(";'>");
                        result.append(label.getSectionDataList().get(i).getValueColumnID());
                        result.append("</span>");
                        if (i < label.getSectionDataList().size() - 1) {
                            result.append(", ");
                        }
                        ++i;
                    }
                    result.append(")");
                }
                result.append("</html>");
                return result.toString();
            }
        }
        return null;
    }

    public void scrollElementToVisible(PaintableElement element) {
        this.scrollRectToVisible(element.getPosition(this.getPainterType()).toRect(this.pixelsPerMillimeter()));
    }

    public static Color selectionColor(Color bgColor) {
        if (GraphicsUtils.brightnessDifference(bgColor, DEFAULT_SELECTION_COLOR) > 200) {
            return DEFAULT_SELECTION_COLOR;
        }
        return ALTERNATIVE_SELECTION_COLOR;
    }
}

