/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.PaintableElement;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class TreeSelection
implements Collection<PaintableElement> {
    private TreeViewPanel owner = null;
    private HashSet<PaintableElement> elements = new HashSet();
    private boolean valueIsAdjusting = false;

    public TreeSelection(TreeViewPanel owner) {
        this.owner = owner;
    }

    private void fireSelectionChanged() {
        if (!this.valueIsAdjusting) {
            this.owner.fireSelectionChanged();
        }
    }

    public PaintableElement first() {
        return this.elements.iterator().next();
    }

    @Override
    public Iterator<PaintableElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.elements.toArray(arr);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.elements.removeAll(c);
        this.fireSelectionChanged();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.elements.retainAll(c);
        this.fireSelectionChanged();
        return result;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        if (!valueIsAdjusting && this.valueIsAdjusting) {
            this.owner.fireSelectionChanged();
        }
        this.valueIsAdjusting = valueIsAdjusting;
    }

    public void set(PaintableElement element) {
        if (element == null || this.owner.getDocument().getTree().contains(element)) {
            this.elements.clear();
            if (element != null) {
                this.elements.add(element);
                if (!this.valueIsAdjusting) {
                    this.owner.scrollElementToVisible(element);
                }
            }
            if (!this.valueIsAdjusting) {
                this.owner.fireSelectionChanged();
            }
        } else {
            throw new IllegalArgumentException("The element \"" + element + "\" can only be selected if it is contained in the associated tree.");
        }
    }

    @Override
    public boolean add(PaintableElement element) {
        if (!this.owner.getDocument().getTree().contains(element)) {
            throw new IllegalArgumentException("The element \"" + element + "\" can only be added to the selection if it is contained in the associated tree.");
        }
        if (element != null) {
            boolean result = true;
            if (!this.contains(element)) {
                boolean bl = result = this.elements.add(element) && result;
                if (!this.valueIsAdjusting) {
                    this.owner.scrollElementToVisible(element);
                    this.owner.fireSelectionChanged();
                }
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends PaintableElement> collection) {
        boolean result = this.elements.addAll(collection);
        if (result && !this.valueIsAdjusting) {
            this.owner.scrollElementToVisible(collection.iterator().next());
            this.owner.fireSelectionChanged();
        }
        return result;
    }

    @Override
    public boolean remove(Object element) {
        if (element != null) {
            boolean result = this.elements.remove(element);
            this.fireSelectionChanged();
            return result;
        }
        return false;
    }

    @Override
    public void clear() {
        this.set(null);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.elements.contains(element);
    }

    public boolean containsType(Class<? extends PaintableElement> elementClass) {
        Iterator<PaintableElement> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!elementClass.isInstance(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOnlyType(Class<? extends PaintableElement> elementClass) {
        boolean containsType = false;
        Iterator<PaintableElement> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (elementClass.isInstance(iterator.next())) {
                containsType = true;
                continue;
            }
            return false;
        }
        return containsType;
    }

    public boolean containsOnlyLeafNodes() {
        boolean containsType = false;
        for (PaintableElement element : this) {
            if (!(element instanceof Node) || !((Node)element).isLeaf()) {
                return false;
            }
            containsType = true;
        }
        return containsType;
    }

    public <T extends PaintableElement> T getFirstElementOfType(Class<T> elementClass) {
        for (PaintableElement element : this) {
            if (!elementClass.isInstance(element)) continue;
            return (T)element;
        }
        return null;
    }

    public Node getFirstNodeBranchOrRoot() {
        Node root = this.getFirstElementOfType(Node.class);
        if (root == null) {
            Branch branch = this.getFirstElementOfType(Branch.class);
            root = branch != null ? branch.getTargetNode() : this.owner.getDocument().getTree().getPaintStart();
        }
        return root;
    }

    public Node getFirstLeaf() {
        for (PaintableElement element : this) {
            if (!(element instanceof Node) || !((Node)element).isLeaf()) continue;
            return (Node)element;
        }
        return null;
    }

    public <T extends PaintableElement> T[] getAllElementsOfType(Class<T> elementClass, boolean leavesOnly) {
        LinkedList<PaintableElement> list = new LinkedList<PaintableElement>();
        for (PaintableElement element : this) {
            if (!elementClass.isInstance(element) || leavesOnly && (!(element instanceof TreeElement) || !((TreeElement)element).getLinkedNode().isLeaf())) continue;
            list.add(element);
        }
        return list.toArray((PaintableElement[])Array.newInstance(elementClass, list.size()));
    }

    public <T extends PaintableElement> T[] getAllElementsOfType(Class<T> elementClass) {
        return this.getAllElementsOfType(elementClass, false);
    }

    public String[] containedLabelIDs() {
        Vector<String> result = new Vector<String>();
        Label[] labels = (Label[])this.getAllElementsOfType(Label.class);
        int i = 0;
        while (i < labels.length) {
            String id = labels[i].getID();
            if (!result.contains(id)) {
                result.add(id);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public int elementCount(Class<? extends PaintableElement> elementClass) {
        int result = 0;
        Iterator<PaintableElement> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!elementClass.isInstance(iterator.next())) continue;
            ++result;
        }
        return result;
    }
}

