/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.gui.treeframe.TreeEditlInputListener;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.treegraph.gui.treeframe.ruler.RulerOrientation;
import info.bioinfweb.treegraph.gui.treeframe.ruler.TreeViewRuler;
import info.bioinfweb.treegraph.gui.treeframe.ruler.TreeViewRulerUnitField;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JScrollPane;

public class TreeScrollPane
extends JScrollPane {
    private TreeViewPanel treeViewPanel = null;
    private TreeEditlInputListener treeViewInputListener = null;

    public TreeScrollPane(Document document) {
        this.treeViewPanel = new TreeViewPanel(document);
        this.treeViewInputListener = new TreeEditlInputListener(this.treeViewPanel);
        this.treeViewPanel.addKeyListener(this.treeViewInputListener);
        this.treeViewPanel.addMouseListener(this.treeViewInputListener);
        this.treeViewPanel.addMouseWheelListener(this.treeViewInputListener);
        this.setViewportView(this.treeViewPanel);
        TreeViewRuler horizontalRuler = new TreeViewRuler(RulerOrientation.HORIZONTAL, this.getTreeViewPanel());
        TreeViewRuler verticalRuler = new TreeViewRuler(RulerOrientation.VERTICAL, this.getTreeViewPanel());
        this.setColumnHeaderView(horizontalRuler);
        this.setRowHeaderView(verticalRuler);
        this.setCorner("UPPER_LEFT_CORNER", new TreeViewRulerUnitField(horizontalRuler, verticalRuler));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreeScrollPane.this.getTreeViewInputListener().mousePressed(new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), 0, 0, e.getButton(), e.isPopupTrigger()));
            }
        });
        this.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.isMetaDown() && SystemUtils.IS_OS_MAC || e.isControlDown() && !SystemUtils.IS_OS_MAC) {
                    TreeScrollPane.this.getTreeViewInputListener().mouseWheelMoved(e);
                }
            }
        });
    }

    public TreeViewPanel getTreeViewPanel() {
        return this.treeViewPanel;
    }

    private TreeEditlInputListener getTreeViewInputListener() {
        return this.treeViewInputListener;
    }
}

