/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.commons.swing.TableColumnModelAdapter;
import info.bioinfweb.commons.swing.scrollpaneselector.ExtendedScrollPaneSelector;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.TreeElement;
import info.bioinfweb.treegraph.document.format.GlobalFormats;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.DocumentTableModel;
import info.bioinfweb.treegraph.gui.treeframe.HelpButton;
import info.bioinfweb.treegraph.gui.treeframe.TreeScrollPane;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class TreeInternalFrame
extends JInternalFrame {
    public static final double TREE_WIDTH_RATIO = 0.5;
    public static final int DATA_COLUMN_WIDTH = 135;
    public static final int DECIMAL_COLUMN_WIDTH = 35;
    private Document document = null;
    private InternalFrameListener internalFrameListener = null;
    private JPanel jContentPane = null;
    private JSplitPane documentSplitPane = null;
    private TreeScrollPane treeScrollPane = null;
    private JScrollPane tableScrollPane = null;
    private JTable table = null;

    public TreeInternalFrame(Document document) {
        super("", true, true, true);
        this.document = document;
        document.setFrame(this);
        this.addInternalFrameListener(this.getInternalFrameListener());
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 400);
        this.setIconifiable(true);
        this.setContentPane(this.getJContentPane());
    }

    private InternalFrameListener getInternalFrameListener() {
        if (this.internalFrameListener == null) {
            this.internalFrameListener = new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    MainFrame.getInstance().updateMenues();
                    TreeInternalFrame.this.getTreeViewPanel().requestFocus();
                }

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    if (TreeInternalFrame.this.document.askToSave()) {
                        CurrentDirectoryModel.getInstance().removeFileChooser(TreeInternalFrame.this.getDocument().getFileChooser());
                        ExtendedScrollPaneSelector.uninstallScrollPaneSelector((JScrollPane)TreeInternalFrame.this.getTreeScrollPane());
                        TreeInternalFrame.this.setDefaultCloseOperation(2);
                    } else {
                        TreeInternalFrame.this.setDefaultCloseOperation(0);
                    }
                }

                @Override
                public void internalFrameClosed(InternalFrameEvent e) {
                    MainFrame.getInstance().updateMenues();
                }
            };
        }
        return this.internalFrameListener;
    }

    public Document getDocument() {
        return this.document;
    }

    public Rectangle getDocumentRect() {
        return this.getTreeScrollPane().getViewportBorderBounds();
    }

    public void setScrollPaneBgColor(Color color) {
        this.getTreeScrollPane().getViewport().setBackground(color);
    }

    private void setColumnWidths() {
        TableColumnModel model = this.getTable().getColumnModel();
        int i = 0;
        while (i < this.getTable().getColumnCount()) {
            if (i % 2 == 0) {
                model.getColumn(i).setPreferredWidth(135);
            } else {
                model.getColumn(i).setPreferredWidth(35);
            }
            ++i;
        }
    }

    public NodeBranchDataAdapter getSelectedAdapter() {
        int pos = this.getTable().getSelectedColumn();
        if (pos != -1) {
            return this.getTableModel().getAdapter(pos);
        }
        return null;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getDocumentSplitPane(), "Center");
        }
        return this.jContentPane;
    }

    private JSplitPane getDocumentSplitPane() {
        if (this.documentSplitPane == null) {
            this.documentSplitPane = new JSplitPane(1, this.getTreeScrollPane(), this.getTableScrollPane());
            this.documentSplitPane.setDividerSize(8);
            this.documentSplitPane.setOneTouchExpandable(true);
            this.documentSplitPane.setResizeWeight(0.5);
            this.documentSplitPane.setDividerLocation(Integer.MAX_VALUE);
        }
        return this.documentSplitPane;
    }

    public TreeViewPanel getTreeViewPanel() {
        return this.getTreeScrollPane().getTreeViewPanel();
    }

    private TreeScrollPane getTreeScrollPane() {
        if (this.treeScrollPane == null) {
            this.treeScrollPane = new TreeScrollPane(this.getDocument());
            ExtendedScrollPaneSelector.installScrollPaneSelector((JScrollPane)this.treeScrollPane);
            this.treeScrollPane.setCorner("UPPER_RIGHT_CORNER", new HelpButton(44));
            this.treeScrollPane.getViewport().setBackground(GlobalFormats.DEFAULT_BACKGROUNG_COLOR);
        }
        return this.treeScrollPane;
    }

    private JScrollPane getTableScrollPane() {
        if (this.tableScrollPane == null) {
            this.tableScrollPane = new JScrollPane();
            this.tableScrollPane.setViewportView(this.getTable());
            ExtendedScrollPaneSelector.installScrollPaneSelector((JScrollPane)this.tableScrollPane);
            this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", new HelpButton(45));
        }
        return this.tableScrollPane;
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(new DocumentTableModel(this.getDocument()));
            this.table.setAutoResizeMode(0);
            this.table.setSurrendersFocusOnKeystroke(true);
            this.table.setColumnSelectionAllowed(true);
            this.table.setRowSelectionAllowed(true);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.getSelectionModel().setSelectionMode(0);
            ListSelectionListener listener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (TreeInternalFrame.this.table.getSelectedColumnCount() > 0 && TreeInternalFrame.this.table.getSelectedRowCount() > 0) {
                        int selRow = TreeInternalFrame.this.table.getSelectedRows()[TreeInternalFrame.this.table.getSelectedRowCount() - 1];
                        int selCol = TreeInternalFrame.this.table.getSelectedColumns()[TreeInternalFrame.this.table.getSelectedColumnCount() - 1];
                        TreeInternalFrame.this.table.changeSelection(selRow, selCol, false, false);
                        TreeInternalFrame.this.getTreeViewPanel().getSelection().set(TreeInternalFrame.this.getTableModel().getTreeElement(selRow, selCol));
                    }
                }
            };
            this.table.getSelectionModel().addListSelectionListener(listener);
            this.table.getColumnModel().getSelectionModel().addListSelectionListener(listener);
            this.table.getColumnModel().addColumnModelListener((TableColumnModelListener)new TableColumnModelAdapter(){

                public void columnAdded(TableColumnModelEvent e) {
                    TreeInternalFrame.this.setColumnWidths();
                }
            });
            this.getTreeViewPanel().addTreeViewPanelListener(new TreeViewPanelListener(){

                @Override
                public void selectionChanged(ChangeEvent e) {
                    TreeElement element = TreeInternalFrame.this.getTreeViewPanel().getSelection().getFirstElementOfType(TreeElement.class);
                    if (element != null) {
                        TreeInternalFrame.this.getTable().changeSelection(TreeInternalFrame.this.getTableModel().getRow(element.getLinkedNode()), TreeInternalFrame.this.getTable().getSelectedColumn(), false, false);
                    }
                }

                @Override
                public void sizeChanged(ChangeEvent e) {
                }

                @Override
                public void zoomChanged(ChangeEvent e) {
                }
            });
            this.setColumnWidths();
        }
        return this.table;
    }

    private DocumentTableModel getTableModel() {
        return (DocumentTableModel)this.getTable().getModel();
    }
}

