/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.commons.SystemUtils;
import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Labels;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextElement;
import info.bioinfweb.treegraph.document.format.DistanceValue;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class TreeEditlInputListener
extends MouseAdapter
implements MouseListener,
KeyListener,
MouseWheelListener {
    public static final float ZOOM_PER_CLICK = 0.1f;
    protected TreeViewPanel owner = null;

    public TreeEditlInputListener(TreeViewPanel owner) {
        this.owner = owner;
    }

    private AbstractPaintableElement getElementByPosition(MouseEvent e) {
        return PositionPaintFactory.getInstance().getPositioner(this.owner.getPainterType()).elementToPosition(this.owner.getDocument(), DistanceValue.pixelsToMillimeters(e.getX(), this.owner.pixelsPerMillimeter()), DistanceValue.pixelsToMillimeters(e.getY(), this.owner.pixelsPerMillimeter()), DistanceValue.pixelsToMillimeters(2.0f, this.owner.pixelsPerMillimeter()));
    }

    protected void doubleClick(MouseEvent e, AbstractPaintableElement element) {
        if (element != null) {
            if (element instanceof TextElement && (!(element instanceof Node) || ((Node)element).isLeaf())) {
                MainFrame.getInstance().getActionManagement().get("edit.editText").actionPerformed(new ActionEvent(this, 0, ""));
            } else {
                MainFrame.getInstance().getActionManagement().get("format.editElementFormats").actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    private void checkPopup(MouseEvent e, AbstractPaintableElement selected) {
        JPopupMenu menu;
        if (e.isPopupTrigger() && (menu = MainFrame.getInstance().getActionManagement().getPopupMenu(selected)) != null) {
            menu.show(this.owner, e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.owner.requestFocusInWindow();
        AbstractPaintableElement selected = this.getElementByPosition(e);
        if (!e.isPopupTrigger() && e.getClickCount() > 1) {
            this.doubleClick(e, selected);
        } else if (e.getButton() == 3) {
            if (!this.owner.getSelection().contains(selected)) {
                if (e.isMetaDown() && SystemUtils.IS_OS_MAC || e.isControlDown() && !SystemUtils.IS_OS_MAC) {
                    this.owner.getSelection().add(selected);
                } else {
                    this.owner.getSelection().set(selected);
                }
            }
        } else if (e.getButton() == 1) {
            if (e.isMetaDown() && SystemUtils.IS_OS_MAC || e.isControlDown() && !SystemUtils.IS_OS_MAC) {
                if (selected != null) {
                    if (this.owner.getSelection().contains(selected)) {
                        this.owner.getSelection().remove(selected);
                    } else {
                        this.owner.getSelection().add(selected);
                    }
                }
            } else {
                this.owner.getSelection().set(selected);
            }
        }
        this.checkPopup(e, selected);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.checkPopup(e, this.getElementByPosition(e));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        block39: {
            block40: {
                block42: {
                    block41: {
                        if (this.owner.getSelection().isEmpty() || e.isMetaDown() && SystemUtils.IS_OS_MAC || e.isControlDown() && !SystemUtils.IS_OS_MAC) break block39;
                        if (e.isShiftDown()) break block40;
                        if (!(this.owner.getSelection().first() instanceof Node)) break block41;
                        Node selected = (Node)this.owner.getSelection().first();
                        switch (e.getKeyCode()) {
                            case 39: 
                            case 102: {
                                if (!selected.getChildren().isEmpty()) {
                                    this.owner.getSelection().set(selected.getChildren().get(0).getAfferentBranch());
                                    break;
                                }
                                break block39;
                            }
                            case 37: 
                            case 100: {
                                if (selected.hasParent() || this.owner.getDocument().getTree().getFormats().getShowRooted()) {
                                    this.owner.getSelection().set(selected.getAfferentBranch());
                                    break;
                                }
                                break block39;
                            }
                            case 38: 
                            case 104: {
                                if (!selected.isFirst()) {
                                    this.owner.getSelection().set(selected.getPrevious());
                                    break;
                                }
                                break block39;
                            }
                            case 40: 
                            case 98: {
                                if (selected.isLast()) break block39;
                                this.owner.getSelection().set(selected.getNext());
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block39;
                    }
                    if (!(this.owner.getSelection().first() instanceof Branch)) break block42;
                    Branch selected = (Branch)this.owner.getSelection().first();
                    switch (e.getKeyCode()) {
                        case 39: 
                        case 102: {
                            this.owner.getSelection().set(selected.getTargetNode());
                            break;
                        }
                        case 37: 
                        case 100: {
                            if (selected.getTargetNode().hasParent()) {
                                this.owner.getSelection().set(selected.getTargetNode().getParent());
                                break;
                            }
                            break block39;
                        }
                        case 38: 
                        case 104: {
                            Labels labels = selected.getLabels();
                            if (labels.lineCount(true) > 0) {
                                this.owner.getSelection().set(labels.getAbove(true, -1, 0));
                                break;
                            }
                            break block39;
                        }
                        case 40: 
                        case 98: {
                            Labels labels = selected.getLabels();
                            if (labels.lineCount(false) <= 0) break block39;
                            this.owner.getSelection().set(labels.getBelow(false, -1, 0));
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block39;
                }
                if (this.owner.getSelection().first() instanceof Label) {
                    Label currentSelection = (Label)this.owner.getSelection().first();
                    AbstractPaintableElement newSelection = null;
                    switch (e.getKeyCode()) {
                        case 39: 
                        case 102: {
                            newSelection = currentSelection.getNext();
                            break;
                        }
                        case 37: 
                        case 100: {
                            newSelection = currentSelection.getPrevious();
                            break;
                        }
                        case 38: 
                        case 104: {
                            newSelection = currentSelection.getAbove();
                            if (newSelection != null || currentSelection.isAbove()) break;
                            newSelection = currentSelection.getHoldingBranch();
                            break;
                        }
                        case 40: 
                        case 98: {
                            newSelection = currentSelection.getBelow();
                            if (newSelection != null || !currentSelection.isAbove()) break;
                            newSelection = currentSelection.getHoldingBranch();
                        }
                    }
                    if (newSelection != null) {
                        this.owner.getSelection().set(newSelection);
                    }
                }
                break block39;
            }
            if (this.owner.getSelection().first() instanceof Node) {
                Node selected = (Node)this.owner.getSelection().first();
                Node newSelection = null;
                switch (e.getKeyCode()) {
                    case 38: 
                    case 104: {
                        newSelection = selected.getPreviousLeaf();
                        break;
                    }
                    case 40: 
                    case 98: {
                        newSelection = selected.getNextLeaf();
                    }
                }
                if (newSelection != null) {
                    this.owner.getSelection().set(newSelection);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isMetaDown() && SystemUtils.IS_OS_MAC || e.isControlDown() && !SystemUtils.IS_OS_MAC) {
            this.owner.setZoom(this.owner.getZoom() - (float)e.getWheelRotation() * 0.1f);
        } else if (this.owner.getParent() != null) {
            this.owner.getParent().dispatchEvent(SwingUtilities.convertMouseEvent(this.owner, e, this.owner.getParent()));
        }
    }
}

