/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.treeframe;

import info.bioinfweb.commons.Math2;
import info.bioinfweb.treegraph.document.AbstractPaintableElement;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.change.DocumentChangeEvent;
import info.bioinfweb.treegraph.document.change.DocumentListener;
import info.bioinfweb.treegraph.document.nodebranchdata.AbstractTextElementDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.BranchLengthAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.HiddenNodeDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeNameAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.TextLabelAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.UniqueNameAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.undo.edit.ChangeCellTypeEdit;
import info.bioinfweb.treegraph.document.undo.edit.ChangeNumercalValueEdit;
import info.bioinfweb.treegraph.document.undo.edit.ChangeTextualValueEdit;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DocumentTableModel
extends AbstractTableModel
implements DocumentListener {
    public static final int COL_UNIQUE_NAME_DATA_TYPE = 1;
    public static final int COL_BRANCH_LENGTH_DATA_TYPE = 5;
    public static final String DECIMAL_COLUMN_HEADING = "Dec";
    private Vector<NodeBranchDataAdapter> adapters = new Vector();
    private Vector<Node> nodes = new Vector();
    private Document document = null;

    public DocumentTableModel(Document document) {
        this.setDocument(document);
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeView(this);
        }
        this.document = document;
        if (document != null) {
            document.addView(this);
            this.changeHappened(new DocumentChangeEvent(document, null));
        }
    }

    public AbstractPaintableElement getTreeElement(int row, int col) {
        return this.getAdapter(col).getDataElement(this.nodes.get(row));
    }

    @Override
    public void changeHappened(DocumentChangeEvent e) {
        this.fillAdapterList(this.getDocument().getTree().getPaintStart());
        this.nodes.clear();
        if (!this.getDocument().getTree().isEmpty()) {
            this.fillNodeList(this.getDocument().getTree().getPaintStart());
        }
        this.fireTableStructureChanged();
    }

    private void fillAdapterList(Node root) {
        this.adapters.clear();
        this.adapters.add(new UniqueNameAdapter());
        this.adapters.add(new NodeNameAdapter());
        this.adapters.add(new BranchLengthAdapter());
        List<String> ids = IDManager.getLabelIDListFromSubtree(root, TextLabel.class);
        int i = 0;
        while (i < ids.size()) {
            this.adapters.add(new TextLabelAdapter(ids.get(i), ((TextLabel)IDManager.getFirstLabel(root, TextLabel.class, ids.get(i))).getFormats().getDecimalFormat()));
            ++i;
        }
        ids = IDManager.getHiddenNodeDataIDListFromSubtree(root);
        i = 0;
        while (i < ids.size()) {
            this.adapters.add(new HiddenNodeDataAdapter(ids.get(i)));
            ++i;
        }
        ids = IDManager.getHiddenBranchDataIDListFromSubtree(root);
        i = 0;
        while (i < ids.size()) {
            this.adapters.add(new HiddenBranchDataAdapter(ids.get(i)));
            ++i;
        }
    }

    private void fillNodeList(Node root) {
        this.nodes.add(root);
        int i = 0;
        while (i < root.getChildren().size()) {
            this.fillNodeList(root.getChildren().get(i));
            ++i;
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if (col % 2 == 0) {
            if (this.adapters.get(col / 2).decimalOnly()) {
                return Double.class;
            }
            return Object.class;
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex % 2 == 0) {
            NodeBranchDataAdapter adapter = this.adapters.get(columnIndex / 2);
            if (adapter instanceof TextLabelAdapter) {
                return String.valueOf(((TextLabelAdapter)adapter).getID()) + " (text labels)";
            }
            if (adapter instanceof HiddenNodeDataAdapter) {
                return String.valueOf(((HiddenNodeDataAdapter)adapter).getID()) + " (hidden node data)";
            }
            if (adapter instanceof HiddenBranchDataAdapter) {
                return String.valueOf(((HiddenBranchDataAdapter)adapter).getID()) + " (hidden branch data)";
            }
            return adapter.toString();
        }
        return DECIMAL_COLUMN_HEADING;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean result;
        boolean bl = result = col != 1 && col != 5 && !(this.getAdapter(col) instanceof UniqueNameAdapter);
        if (result && col % 2 == 1) {
            result = !this.getAdapter(col).isEmpty(this.nodes.get(row));
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2 * this.adapters.size();
    }

    @Override
    public int getRowCount() {
        return this.nodes.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        NodeBranchDataAdapter adapter = this.adapters.get(col / 2);
        Node n = this.nodes.get(row);
        if (col % 2 == 0) {
            if (adapter.isDecimal(n)) {
                return new Double(adapter.getDecimal(n));
            }
            if (adapter.isString(n)) {
                return adapter.getText(n);
            }
            return null;
        }
        if (adapter.isDecimal(n)) {
            return new Boolean(true);
        }
        return new Boolean(false);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        NodeBranchDataAdapter adapter = this.adapters.get(col / 2);
        Node n = this.nodes.get(row);
        if (col % 2 == 0) {
            String str = "";
            if (value != null) {
                str = value.toString();
            }
            if (adapter.isDecimal(n) && Math2.isDecimal(str)) {
                this.getDocument().executeEdit(new ChangeNumercalValueEdit(this.getDocument(), adapter, n, Math2.parseDouble(str)));
            } else {
                this.getDocument().executeEdit(new ChangeTextualValueEdit(this.getDocument(), adapter, n, str));
            }
        } else if (value instanceof Boolean && adapter instanceof AbstractTextElementDataAdapter) {
            this.getDocument().executeEdit(new ChangeCellTypeEdit(this.getDocument(), (AbstractTextElementDataAdapter)adapter, n, (Boolean)value));
        }
    }

    public NodeBranchDataAdapter getAdapter(int col) {
        return this.adapters.get(col / 2);
    }

    public int getRow(Node node) {
        return this.nodes.indexOf(node);
    }
}

