/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.mainframe;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.change.DocumentChangeEvent;
import info.bioinfweb.treegraph.document.change.DocumentChangeType;
import info.bioinfweb.treegraph.document.change.DocumentListener;
import info.bioinfweb.treegraph.document.nodebranchdata.IDElementAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.NodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.nodebranchdata.VoidNodeBranchDataAdapter;
import info.bioinfweb.treegraph.document.topologicalcalculation.NodeInfo;
import info.bioinfweb.treegraph.document.topologicalcalculation.TopologicalCalculator;
import info.bioinfweb.treegraph.document.undo.SelectionSynchronizationCompareParameters;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import info.bioinfweb.treegraph.gui.treeframe.TreeSelection;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanel;
import info.bioinfweb.treegraph.gui.treeframe.TreeViewPanelListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;

public class TreeSelectionSynchronizer
implements TreeViewPanelListener,
DocumentListener,
ContainerListener {
    public static final String KEY_LEAF_REFERENCE = String.valueOf(TreeSelectionSynchronizer.class.getName()) + ".LeafSet";
    private Iterable<TreeViewPanel> treeSource;
    protected boolean isUpdating = false;
    private TopologicalCalculator topologicalCalculator = null;
    private SelectionSynchronizationCompareParameters compareParameters = new SelectionSynchronizationCompareParameters();

    public TreeSelectionSynchronizer(Iterable<TreeViewPanel> treeSource) {
        this.treeSource = treeSource;
    }

    public Iterable<TreeViewPanel> getTreeSource() {
        return this.treeSource;
    }

    public SelectionSynchronizationCompareParameters getCompareParameters() {
        return this.compareParameters;
    }

    public void reset() {
        Document document;
        this.topologicalCalculator = new TopologicalCalculator(this.compareParameters.isProcessRooted(), KEY_LEAF_REFERENCE, this.compareParameters);
        Iterator<TreeViewPanel> iterator = this.getTreeSource().iterator();
        while (iterator.hasNext()) {
            document = iterator.next().getDocument();
            if (document.getTree().isEmpty()) continue;
            this.topologicalCalculator.addSubtreeToLeafValueToIndexMap(document.getTree().getPaintStart(), document.getDefaultLeafAdapter());
        }
        iterator = this.getTreeSource().iterator();
        while (iterator.hasNext()) {
            document = iterator.next().getDocument();
            if (document.getTree().isEmpty()) continue;
            this.topologicalCalculator.addLeafSets(document.getTree().getPaintStart(), document.getDefaultLeafAdapter());
        }
    }

    private void selectAccordingNodes(TreeViewPanel activeTree, TreeViewPanel selectionTargetTree) {
        if (!activeTree.equals(selectionTargetTree) && !selectionTargetTree.getDocument().getTree().isEmpty()) {
            TreeSelection selection = selectionTargetTree.getSelection();
            selection.clear();
            NodeBranchDataAdapter defaultSupportAdapter = selectionTargetTree.getDocument().getDefaultSupportAdapter();
            Node[] nodeArray = (Node[])activeTree.getSelection().getAllElementsOfType(Node.class, false);
            int n = nodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Node activeNode = nodeArray[n2];
                List<NodeInfo> selectionTargetNodeInfos = this.topologicalCalculator.findNodeWithAllLeaves(selectionTargetTree.getDocument().getTree(), this.topologicalCalculator.getLeafSet(activeNode));
                NodeInfo selectionTargetNodeInfo = null;
                if (!selectionTargetNodeInfos.isEmpty()) {
                    selectionTargetNodeInfo = selectionTargetNodeInfos.get(0);
                }
                if (selectionTargetNodeInfo != null) {
                    Node conflictingNode;
                    selection.add(selectionTargetNodeInfo.getNode());
                    if (!(defaultSupportAdapter instanceof VoidNodeBranchDataAdapter) && (conflictingNode = this.topologicalCalculator.findHighestConflict(activeTree.getDocument().getTree(), selectionTargetTree.getDocument().getTree(), selectionTargetNodeInfo.getNode(), this.topologicalCalculator.getLeafSet(activeNode), this.topologicalCalculator.getLeafSet(selectionTargetNodeInfo.getNode()), defaultSupportAdapter)) != null) {
                        if (defaultSupportAdapter instanceof IDElementAdapter) {
                            Label label = conflictingNode.getAfferentBranch().getLabels().get(((IDElementAdapter)defaultSupportAdapter).getID());
                            if (label != null) {
                                selection.add(label);
                            } else {
                                selection.add(conflictingNode.getAfferentBranch());
                            }
                        } else {
                            selection.add(conflictingNode.getAfferentBranch());
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void selectionChanged(ChangeEvent e) {
        if (!this.isUpdating) {
            this.isUpdating = true;
            try {
                TreeViewPanel source = (TreeViewPanel)e.getSource();
                for (TreeViewPanel target : this.treeSource) {
                    this.selectAccordingNodes(source, target);
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    @Override
    public void zoomChanged(ChangeEvent e) {
    }

    @Override
    public void sizeChanged(ChangeEvent e) {
    }

    @Override
    public void changeHappened(DocumentChangeEvent e) {
        DocumentChangeType changeType;
        if (e.getEdit() != null && ((changeType = e.getEdit().getChangeType()) == DocumentChangeType.ROOT_POSITION || changeType == DocumentChangeType.TOPOLOGICAL_BY_RENAMING || changeType == DocumentChangeType.TOPOLOGICAL_BY_OBJECT_CHANGE)) {
            this.reset();
        }
    }

    public TopologicalCalculator getTopologicalCalculator() {
        return this.topologicalCalculator;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (e.getChild() instanceof TreeInternalFrame) {
            TreeInternalFrame addedFrame = (TreeInternalFrame)e.getChild();
            addedFrame.getTreeViewPanel().addTreeViewPanelListener(this);
            addedFrame.getTreeViewPanel().getDocument().addView(this);
            this.reset();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        ((TreeInternalFrame)e.getChild()).getTreeViewPanel().removeTreeViewPanelListener(this);
        ((TreeInternalFrame)e.getChild()).getTreeViewPanel().getDocument().removeView(this);
    }
}

