/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.mainframe;

import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.actions.ActionManagement;
import info.bioinfweb.treegraph.gui.mainframe.MainFrame;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolBarPanel
extends JPanel {
    private MainFrame mainFrame = null;
    private ToolBarOrientation orientation = ToolBarOrientation.VERTICAL;
    private JToolBar upperToolBar = null;
    private JToolBar lowerToolBar = null;
    private GridBagConstraints editFormatsGBC = new GridBagConstraints();
    private GridBagConstraints fileViewWindowGBC = new GridBagConstraints();

    public ToolBarPanel(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.setLayout(new GridBagLayout());
        this.fileViewWindowGBC.fill = 0;
        this.fileViewWindowGBC.gridx = 0;
        this.fileViewWindowGBC.gridy = 0;
        this.fileViewWindowGBC.anchor = 17;
        this.add((Component)this.getUpperToolBar(), this.fileViewWindowGBC);
        this.editFormatsGBC.fill = 2;
        this.editFormatsGBC.gridx = 0;
        this.editFormatsGBC.gridy = 1;
        this.editFormatsGBC.weightx = 2.0;
        this.editFormatsGBC.anchor = 17;
        this.add((Component)this.getLowerToolBar(), this.editFormatsGBC);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = (int)ToolBarPanel.this.getUpperToolBar().getPreferredSize().getWidth() + (int)ToolBarPanel.this.getLowerToolBar().getPreferredSize().getWidth();
                if (ToolBarPanel.this.getWidth() >= width) {
                    ToolBarPanel.this.setOrientation(ToolBarOrientation.HORIZONTAL);
                } else {
                    ToolBarPanel.this.setOrientation(ToolBarOrientation.VERTICAL);
                }
            }
        });
    }

    public ToolBarOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ToolBarOrientation alignment) {
        if (alignment == null) {
            throw new NullPointerException("Alignment cannnot be null.");
        }
        if (!this.orientation.equals((Object)alignment)) {
            this.orientation = alignment;
            this.removeAll();
            if (alignment.equals((Object)ToolBarOrientation.VERTICAL)) {
                this.editFormatsGBC.gridx = 0;
                this.editFormatsGBC.gridy = 1;
            } else {
                this.editFormatsGBC.gridx = 1;
                this.editFormatsGBC.gridy = 0;
            }
            this.add((Component)this.getUpperToolBar(), this.fileViewWindowGBC);
            this.add((Component)this.getLowerToolBar(), this.editFormatsGBC);
            this.mainFrame.validate();
        }
    }

    private ActionManagement getActionManagement() {
        return this.mainFrame.getActionManagement();
    }

    private JToolBar getUpperToolBar() {
        if (this.upperToolBar == null) {
            this.upperToolBar = new JToolBar();
            this.upperToolBar.setFloatable(false);
            this.upperToolBar.setRollover(true);
            this.upperToolBar.add(this.getActionManagement().get("file.newDocument"));
            this.upperToolBar.add(this.getActionManagement().get("file.open"));
            this.upperToolBar.add(this.getActionManagement().get("file.save"));
            this.upperToolBar.add(this.getActionManagement().get("file.exportPDF"));
            this.upperToolBar.addSeparator();
            JToggleButton button = new JToggleButton(this.getActionManagement().get("select.synchronizeTreeSelection"));
            button.setText("");
            this.upperToolBar.add(button);
            this.upperToolBar.addSeparator();
            this.upperToolBar.add(this.getActionManagement().get("edit.undo"));
            this.upperToolBar.add(this.getActionManagement().get("edit.redo"));
            this.upperToolBar.addSeparator();
            this.upperToolBar.add(this.getActionManagement().get("edit.copyElement"));
            this.upperToolBar.add(this.getActionManagement().get("edit.cut"));
            this.upperToolBar.add(this.getActionManagement().get("edit.paste"));
            this.upperToolBar.add(this.getActionManagement().get("edit.delete"));
            this.upperToolBar.addSeparator();
            this.upperToolBar.add(this.getActionManagement().get("edit.moveSubtreeUp"));
            this.upperToolBar.add(this.getActionManagement().get("edit.moveSubtreeDown"));
            this.upperToolBar.addSeparator();
        }
        return this.upperToolBar;
    }

    private JToolBar getLowerToolBar() {
        if (this.lowerToolBar == null) {
            this.lowerToolBar = new JToolBar();
            this.lowerToolBar.setFloatable(false);
            this.lowerToolBar.setRollover(true);
            this.lowerToolBar.add(this.getActionManagement().get("format.editDocumentFormats"));
            this.lowerToolBar.add(this.getActionManagement().get("format.showRooted"));
            this.lowerToolBar.add(this.getActionManagement().get("format.showScaleBar"));
            this.lowerToolBar.addSeparator();
            this.lowerToolBar.add(this.getActionManagement().get("view.setZoomToOriginal"));
            this.lowerToolBar.add(this.getActionManagement().get("view.fitZoomToWidth"));
            this.lowerToolBar.add(this.getActionManagement().get("view.fitZoomToWidthHeight"));
            this.lowerToolBar.addSeparator();
            PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
            int n = positionPaintTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PositionPaintType type = positionPaintTypeArray[n2];
                this.lowerToolBar.add(this.getActionManagement().get("view.setPainterID_" + PositionPaintFactory.getInstance().getName(type)));
                ++n2;
            }
            this.lowerToolBar.addSeparator();
            this.lowerToolBar.add(this.getActionManagement().get("window.previousDocument"));
            this.lowerToolBar.add(this.getActionManagement().get("window.nextDocument"));
            this.lowerToolBar.addSeparator();
            this.lowerToolBar.add(this.getActionManagement().get("help.contents"));
        }
        return this.lowerToolBar;
    }

    public static enum ToolBarOrientation {
        HORIZONTAL,
        VERTICAL;

    }
}

