/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.mainframe;

import info.bioinfweb.commons.log.ApplicationLogger;
import info.bioinfweb.commons.log.ApplicationLoggerDialog;
import info.bioinfweb.commons.swing.ExtendedDesktopPane;
import info.bioinfweb.treegraph.Main;
import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.io.DocumentReader;
import info.bioinfweb.treegraph.document.io.ReadWriteFactory;
import info.bioinfweb.treegraph.document.io.ReadWriteParameterMap;
import info.bioinfweb.treegraph.document.nodebranchdata.NewTextLabelAdapter;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintFactory;
import info.bioinfweb.treegraph.graphics.positionpaint.PositionPaintType;
import info.bioinfweb.treegraph.gui.CurrentDirectoryModel;
import info.bioinfweb.treegraph.gui.actions.ActionManagement;
import info.bioinfweb.treegraph.gui.actions.window.SelectFrameAction;
import info.bioinfweb.treegraph.gui.dialogs.AboutDialog;
import info.bioinfweb.treegraph.gui.mainframe.ToolBarPanel;
import info.bioinfweb.treegraph.gui.mainframe.TreeSelectionSynchronizer;
import info.bioinfweb.treegraph.gui.mainframe.TreeViewPanelIterable;
import info.bioinfweb.treegraph.gui.treeframe.TreeInternalFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MainFrame
extends JFrame
implements Runnable {
    private static final long serialVersionUID = 1L;
    private static final int WINDOW_MENU_ITEMS_COUNT = 5;
    private static MainFrame firstInstance = null;
    private TreeSelectionSynchronizer treeSelectionSynchronizer = new TreeSelectionSynchronizer(new TreeViewPanelIterable());
    private ActionManagement actionManagement = new ActionManagement(this);
    private WindowListener windowListener = null;
    private JMenuBar mainMenu = null;
    private JMenu fileMenu = null;
    private JMenu editMenu = null;
    private JMenu viewMenu = null;
    private JMenu helpMenu = null;
    private JPanel jContentPane = null;
    private ExtendedDesktopPane desktopPane = null;
    private JMenu windowMenu = null;
    private JMenu formatMenu = null;
    private JMenu selectMenu = null;
    private JPanel toolBarPanel = null;
    private JMenu undoMenu = null;
    private JMenu redoMenu = null;
    private JMenu newMenu = null;
    private JMenu nodeBranchDataMenu = null;
    private ApplicationLoggerDialog readWriteLogDialog = new ApplicationLoggerDialog((Frame)this);
    private AboutDialog aboutDialog = null;

    private MainFrame() {
        this.readWriteLogDialog.setTitle("Warnings occurred when the file was opened");
        this.initialize();
    }

    public static MainFrame getInstance() {
        if (firstInstance == null) {
            firstInstance = new MainFrame();
        }
        return firstInstance;
    }

    public ApplicationLoggerDialog getReadWriteLogDialog() {
        return this.readWriteLogDialog;
    }

    public AboutDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this);
        }
        return this.aboutDialog;
    }

    private void openInitialFile() {
        File file = Main.getInstance().getCmdProcessor().getInitialFile();
        if (file != null) {
            if (file.canRead()) {
                DocumentReader reader = ReadWriteFactory.getInstance().getReader(file);
                if (reader != null) {
                    try {
                        ReadWriteParameterMap parameterMap = new ReadWriteParameterMap();
                        parameterMap.putApplicationLogger((ApplicationLogger)this.getReadWriteLogDialog());
                        parameterMap.put("internalNodeNamesAdapter", new NewTextLabelAdapter("internalNodeNames", new DecimalFormat()));
                        this.addInternalFrame(reader.read(file, parameterMap));
                        CurrentDirectoryModel.getInstance().setCurrentDirectory(file.getParentFile());
                        this.getReadWriteLogDialog().display();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "The error \"" + e.getMessage() + "\" occured when trying to open the file \"" + file.getAbsolutePath() + "\"", "Error", 0);
                    }
                } else {
                    JOptionPane.showMessageDialog(this, "The file \"" + file.getAbsolutePath() + "\" does not have a supported format.", "Format error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "The file \"" + file.getAbsolutePath() + "\" cannot be opened.", "File error", 0);
            }
        }
    }

    @Override
    public void run() {
        this.setVisible(true);
        this.openInitialFile();
    }

    public void close() {
        this.processWindowEvent(new WindowEvent(this, 201));
    }

    public void addInternalFrame(JInternalFrame iFrame) {
        this.getDesktopPane().add((Component)iFrame);
        try {
            iFrame.setMaximum(true);
            iFrame.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    public TreeInternalFrame addInternalFrame(Document document) {
        TreeInternalFrame result = new TreeInternalFrame(document);
        result.setVisible(true);
        this.addInternalFrame(result);
        return result;
    }

    public void addChildWindowListener(ContainerListener listener) {
        this.getDesktopPane().addContainerListener(listener);
    }

    public void removeChildWindowListener(ContainerListener listener) {
        this.getDesktopPane().removeContainerListener(listener);
    }

    public TreeInternalFrame getActiveTreeFrame() {
        if (this.getDesktopPane().getSelectedFrame() != null && this.getDesktopPane().getSelectedFrame() instanceof TreeInternalFrame) {
            return (TreeInternalFrame)this.getDesktopPane().getSelectedFrame();
        }
        return null;
    }

    public Iterator<TreeInternalFrame> treeFrameIterator() {
        final JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        return new Iterator<TreeInternalFrame>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < frames.length;
            }

            @Override
            public TreeInternalFrame next() {
                ++this.pos;
                return (TreeInternalFrame)frames[this.pos - 1];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This iterator does not support removing elements.");
            }
        };
    }

    public int getTreeFrameCount() {
        return this.getDesktopPane().getAllFrames().length;
    }

    public JInternalFrame selectFrame(boolean forward) {
        return this.getDesktopPane().selectFrame(forward);
    }

    public TreeInternalFrame getInternalFrameByFile(File file) {
        JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        int i = 0;
        while (i < frames.length) {
            Document doc;
            if (frames[i] instanceof TreeInternalFrame && (doc = ((TreeInternalFrame)frames[i]).getDocument()).hasFile() && file.equals(doc.getFile())) {
                return (TreeInternalFrame)frames[i];
            }
            ++i;
        }
        return null;
    }

    public void tileInternalFramesVertical() {
        this.getDesktopPane().tileVertical();
    }

    public void tileInternalFramesHorizontal() {
        this.getDesktopPane().tileHorizontal();
    }

    public void cascadeInternalFrames() {
        this.getDesktopPane().cascade();
    }

    public TreeSelectionSynchronizer getTreeSelectionSynchronizer() {
        return this.treeSelectionSynchronizer;
    }

    public ActionManagement getActionManagement() {
        return this.actionManagement;
    }

    private void updateWindowMenu() {
        while (this.getWindowMenu().getItemCount() > 5) {
            this.getWindowMenu().remove(this.getWindowMenu().getItemCount() - 1);
        }
        JInternalFrame[] frames = this.getDesktopPane().getAllFrames();
        if (frames.length > 0) {
            this.getWindowMenu().addSeparator();
            int i = 0;
            while (i < frames.length) {
                this.getWindowMenu().add((Action)((Object)new SelectFrameAction(frames[i], i)));
                ++i;
            }
        }
    }

    public void updateMenues() {
        this.updateWindowMenu();
        this.getActionManagement().refreshActionStatus();
    }

    private void initialize() {
        this.setSize(800, 600);
        this.setExtendedState(6);
        this.setContentPane(this.getJContentPane());
        this.setJMenuBar(this.getMainMenu());
        this.setTitle("TreeGraph 2");
        this.addWindowListener(this.getWindowListener());
        this.setDefaultCloseOperation(0);
        this.loadIcons();
        this.updateMenues();
    }

    private void loadIcons() {
        Vector<BufferedImage> icons = new Vector<BufferedImage>(7, 1);
        try {
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph16.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph20.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph22.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph24.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph32.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph48.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph64.png")));
            icons.add(ImageIO.read(MainFrame.class.getResource("/resources/symbols/TreeGraph256.png")));
            this.setIconImages(icons);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "The application symbols could not be loaded.", "Error", 0);
        }
    }

    private WindowListener getWindowListener() {
        if (this.windowListener == null) {
            this.windowListener = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    JInternalFrame[] frames = MainFrame.this.getDesktopPane().getAllFrames();
                    int i = 0;
                    while (i < frames.length) {
                        frames[i].doDefaultCloseAction();
                        if (!frames[i].isClosed()) {
                            return;
                        }
                        ++i;
                    }
                    System.exit(0);
                }
            };
        }
        return this.windowListener;
    }

    private JMenuBar getMainMenu() {
        if (this.mainMenu == null) {
            this.mainMenu = new JMenuBar();
            this.mainMenu.add(this.getFileMenu());
            this.mainMenu.add(this.getSelectMenu());
            this.mainMenu.add(this.getEditMenu());
            this.mainMenu.add(this.getFormatMenu());
            this.mainMenu.add(this.getViewMenu());
            this.mainMenu.add(this.getWindowMenu());
            this.mainMenu.add(this.getHelpMenu());
        }
        return this.mainMenu;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic(70);
            this.fileMenu.add(this.getActionManagement().get("file.newDocument"));
            this.fileMenu.add(this.getActionManagement().get("file.open"));
            this.fileMenu.add(this.getActionManagement().get("file.save"));
            this.fileMenu.add(this.getActionManagement().get("file.saveAs"));
            this.fileMenu.add(this.getActionManagement().get("file.close"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getActionManagement().get("file.addSupportValues"));
            this.fileMenu.add(this.getActionManagement().get("file.importTable"));
            this.fileMenu.add(this.getActionManagement().get("file.importBayesTraitsData"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getActionManagement().get("file.exportGraphic"));
            this.fileMenu.add(this.getActionManagement().get("file.exportTreeFormat"));
            this.fileMenu.add(this.getActionManagement().get("file.exportTable"));
            this.fileMenu.add(this.getActionManagement().get("file.generateBayesTraitsCommands"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getActionManagement().get("file.createBranchLabelCaptionDocument"));
            this.fileMenu.add(this.getActionManagement().get("file.exportPieChartLabelColors"));
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getActionManagement().get("file.exit"));
        }
        return this.fileMenu;
    }

    private JMenu getEditMenu() {
        if (this.editMenu == null) {
            this.editMenu = new JMenu("Edit");
            this.editMenu.setMnemonic(69);
            this.editMenu.add(this.getUndoMenu());
            this.editMenu.add(this.getRedoMenu());
            this.editMenu.addSeparator();
            this.editMenu.add(this.getNewMenu());
            this.editMenu.add(this.getActionManagement().get("edit.copyElement"));
            this.editMenu.add(this.getActionManagement().get("edit.copyAllLabels"));
            this.editMenu.add(this.getActionManagement().get("edit.cut"));
            this.editMenu.add(this.getActionManagement().get("edit.paste"));
            this.editMenu.add(this.getActionManagement().get("edit.delete"));
            this.editMenu.addSeparator();
            this.editMenu.add(this.getNodeBranchDataMenu());
            this.editMenu.add(this.getActionManagement().get("edit.editText"));
            this.editMenu.add(this.getActionManagement().get("edit.branchLength"));
            this.editMenu.add(this.getActionManagement().get("edit.changeLabelID"));
            this.editMenu.add(this.getActionManagement().get("edit.pieChartIDs"));
            this.editMenu.addSeparator();
            this.editMenu.add(this.getActionManagement().get("edit.search"));
            this.editMenu.add(this.getActionManagement().get("edit.replaceInNodeData"));
            this.editMenu.addSeparator();
            this.editMenu.add(this.getActionManagement().get("edit.moveSubtreeUp"));
            this.editMenu.add(this.getActionManagement().get("edit.moveSubtreeDown"));
            this.editMenu.add(this.getActionManagement().get("edit.ladderizeUp"));
            this.editMenu.add(this.getActionManagement().get("edit.ladderizeDown"));
            this.editMenu.add(this.getActionManagement().get("edit.sortLeaves"));
            this.editMenu.add(this.getActionManagement().get("edit.reroot"));
            this.editMenu.add(this.getActionManagement().get("edit.rerootByLeafSet"));
            this.editMenu.addSeparator();
            this.editMenu.add(this.getActionManagement().get("edit.deleteSubelements"));
            this.editMenu.add(this.getActionManagement().get("edit.collapseNode"));
            this.editMenu.add(this.getActionManagement().get("edit.collapseNodesBySupport"));
            this.editMenu.add(this.getActionManagement().get("edit.separateBranch"));
        }
        return this.editMenu;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.setText("View");
            this.viewMenu.setMnemonic(86);
            this.viewMenu.add(this.getActionManagement().get("view.setZoomToOriginal"));
            this.viewMenu.add(this.getActionManagement().get("view.fitZoomToWidthHeight"));
            this.viewMenu.add(this.getActionManagement().get("view.fitZoomToWidth"));
            this.viewMenu.add(this.getActionManagement().get("view.fitZoomToHeight"));
            this.viewMenu.add(this.getActionManagement().get("view.setUserZoom"));
            this.viewMenu.addSeparator();
            PositionPaintType[] positionPaintTypeArray = PositionPaintType.values();
            int n = positionPaintTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PositionPaintType type = positionPaintTypeArray[n2];
                this.viewMenu.add(this.getActionManagement().get("view.setPainterID_" + PositionPaintFactory.getInstance().getName(type)));
                ++n2;
            }
        }
        return this.viewMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.setMnemonic(72);
            this.helpMenu.add(this.getActionManagement().get("help.index"));
            this.helpMenu.add(this.getActionManagement().get("help.contents"));
            this.helpMenu.add(this.getActionManagement().get("help.aboutMenu"));
            this.helpMenu.add(this.getActionManagement().get("help.researchGate"));
            this.helpMenu.add(this.getActionManagement().get("help.issues"));
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.getActionManagement().get("help.homepage"));
            this.helpMenu.add(this.getActionManagement().get("help.about"));
            this.helpMenu.add(this.getActionManagement().get("help.privacyPolicy"));
            this.helpMenu.addSeparator();
            this.helpMenu.add(this.getActionManagement().get("help.bioinfweb"));
            this.helpMenu.add(this.getActionManagement().get("help.twitter"));
        }
        return this.helpMenu;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToolBarPanel(), "First");
            this.jContentPane.add((Component)this.getDesktopPane(), "Center");
        }
        return this.jContentPane;
    }

    private ExtendedDesktopPane getDesktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new ExtendedDesktopPane();
        }
        return this.desktopPane;
    }

    private JMenu getWindowMenu() {
        if (this.windowMenu == null) {
            this.windowMenu = new JMenu();
            this.windowMenu.setText("Window");
            this.windowMenu.setMnemonic(87);
            this.windowMenu.add(this.getActionManagement().get("window.preferences"));
            this.windowMenu.addSeparator();
            this.windowMenu.add(this.getActionManagement().get("window.tileVertical"));
            this.windowMenu.add(this.getActionManagement().get("window.tileHorizontal"));
            this.windowMenu.add(this.getActionManagement().get("window.cascade"));
        }
        return this.windowMenu;
    }

    private JMenu getFormatMenu() {
        if (this.formatMenu == null) {
            this.formatMenu = new JMenu();
            this.formatMenu.setText("Format");
            this.formatMenu.setMnemonic(79);
            this.formatMenu.add(this.getActionManagement().get("format.editDocumentFormats"));
            this.formatMenu.add(this.getActionManagement().get("format.editElementFormats"));
            this.formatMenu.add(this.getActionManagement().get("format.scaleBranchLengths"));
            this.formatMenu.add(this.getActionManagement().get("format.reanchorLegend"));
            this.formatMenu.add(this.getActionManagement().get("format.autoPositionLabels"));
            this.formatMenu.addSeparator();
            this.formatMenu.add(this.getActionManagement().get("format.colorsNodeData"));
            this.formatMenu.add(this.getActionManagement().get("format.branchWidthsNodeData"));
            this.formatMenu.add(this.getActionManagement().get("format.scaleDistanceValues"));
        }
        return this.formatMenu;
    }

    private JMenu getSelectMenu() {
        if (this.selectMenu == null) {
            this.selectMenu = new JMenu();
            this.selectMenu.setText("Select");
            this.selectMenu.setMnemonic(83);
            this.selectMenu.add(this.getActionManagement().get("select.all"));
            this.selectMenu.add(this.getActionManagement().get("select.invert"));
            this.selectMenu.add(this.getActionManagement().get("select.wholeSubtree"));
            this.selectMenu.add(this.getActionManagement().get("edit.search"));
            this.selectMenu.addSeparator();
            this.selectMenu.add(this.getActionManagement().get("select.typeInDocument"));
            this.selectMenu.add(this.getActionManagement().get("select.typeInSubtree"));
            this.selectMenu.addSeparator();
            this.selectMenu.add(this.getActionManagement().get("select.leavesInDocument"));
            this.selectMenu.add(this.getActionManagement().get("select.leavesInSubtree"));
            this.selectMenu.addSeparator();
            this.selectMenu.add(this.getActionManagement().get("select.labelsWithID"));
            this.selectMenu.add(this.getActionManagement().get("select.labelsInSubtree"));
            this.selectMenu.addSeparator();
            this.selectMenu.add(this.getActionManagement().get("select.allLegends"));
            this.selectMenu.add(this.getActionManagement().get("select.legendsWithPosIndex"));
            this.selectMenu.add(this.getActionManagement().get("select.legendsInSubtree"));
            this.selectMenu.addSeparator();
            this.selectMenu.add(new JCheckBoxMenuItem(this.getActionManagement().get("select.synchronizeTreeSelection")));
            this.selectMenu.add(this.getActionManagement().get("select.synchronizeTreeSelectionOptions"));
        }
        return this.selectMenu;
    }

    private JPanel getToolBarPanel() {
        if (this.toolBarPanel == null) {
            this.toolBarPanel = new ToolBarPanel(this);
        }
        return this.toolBarPanel;
    }

    public JMenu getUndoMenu() {
        if (this.undoMenu == null) {
            this.undoMenu = new JMenu();
            this.undoMenu.setText("Undo");
            this.undoMenu.setMnemonic(85);
            this.undoMenu.setIcon(new ImageIcon(MainFrame.class.getResource("/resources/symbols/Undo16.png")));
        }
        return this.undoMenu;
    }

    public JMenu getRedoMenu() {
        if (this.redoMenu == null) {
            this.redoMenu = new JMenu();
            this.redoMenu.setText("Redo");
            this.redoMenu.setMnemonic(82);
            this.redoMenu.setIcon(new ImageIcon(MainFrame.class.getResource("/resources/symbols/Redo16.png")));
        }
        return this.redoMenu;
    }

    private JMenu getNewMenu() {
        if (this.newMenu == null) {
            this.newMenu = new JMenu();
            this.newMenu.setText("New");
            this.newMenu.setMnemonic(78);
            this.newMenu.add(this.getActionManagement().get("edit.newNode"));
            this.newMenu.add(this.getActionManagement().get("edit.newTextLabel"));
            this.newMenu.add(this.getActionManagement().get("edit.newIconLabels"));
            this.newMenu.add(this.getActionManagement().get("edit.newPieChartLabels"));
            this.newMenu.add(this.getActionManagement().get("edit.newLegend"));
        }
        return this.newMenu;
    }

    private JMenu getNodeBranchDataMenu() {
        if (this.nodeBranchDataMenu == null) {
            this.nodeBranchDataMenu = new JMenu();
            this.nodeBranchDataMenu.setText("Node/branch data");
            this.nodeBranchDataMenu.setMnemonic(68);
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.columnToDecimalType"));
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.columnToTextType"));
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.renameID"));
            this.nodeBranchDataMenu.addSeparator();
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.copyColumn"));
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.deleteColumn"));
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.deleteOutsideInterval"));
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.calculate"));
            this.nodeBranchDataMenu.addSeparator();
            this.nodeBranchDataMenu.add(this.getActionManagement().get("edit.defaultDocumentAdapters"));
        }
        return this.nodeBranchDataMenu;
    }
}

