/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.specialformats;

import info.bioinfweb.commons.swing.DecimalInput;
import info.bioinfweb.treegraph.document.Branch;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.undo.format.ScaleDistanceValuesEdit;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.DistanceAdapterListModel;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.SpecialFormatsDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ScaleDistanceValuesDialog
extends SpecialFormatsDialog {
    public static final float DEFAULT_SCALE = 1.0f;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel scalePanel = null;
    private DecimalInput scaleInput = null;

    public ScaleDistanceValuesDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    @Override
    protected DistanceAdapterListModel createTargetListModel() {
        return new DistanceAdapterListModel();
    }

    @Override
    protected DistanceAdapterListModel getTargetListModel() {
        return (DistanceAdapterListModel)super.getTargetListModel();
    }

    @Override
    protected boolean customizeTarget() {
        Node root = this.getSelection().getFirstElementOfType(Node.class);
        if (root == null && this.getSelection().containsType(Branch.class)) {
            root = this.getSelection().getFirstElementOfType(Branch.class).getTargetNode();
        }
        if (root != null) {
            this.getTargetListModel().setAdapters(this.getDocument().getTree(), root, true);
            this.getTargetList().setSelectionInterval(0, this.getTargetListModel().getSize() - 1);
        }
        return root != null;
    }

    protected boolean apply() {
        boolean result;
        float factor = this.scaleInput.parseFloat();
        boolean bl = result = factor > 0.0f;
        if (result) {
            Vector<DistanceAdapter> adapters = new Vector<DistanceAdapter>();
            int[] selection = this.getTargetList().getSelectedIndices();
            int i = 0;
            while (i < selection.length) {
                adapters.add(this.getTargetListModel().getElementAt(selection[i]));
                ++i;
            }
            Node root = this.getSelection().getFirstElementOfType(Node.class);
            if (root == null) {
                root = this.getSelection().getFirstElementOfType(Branch.class).getTargetNode();
            }
            this.getDocument().executeEdit(new ScaleDistanceValuesEdit(this.getDocument(), root, factor, adapters.toArray(new DistanceAdapter[adapters.size()])));
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "The scale factor must be greater than zero.", "Invalid scale factor", 0);
        }
        return result;
    }

    private void initialize() {
        this.setHelpCode(42);
        this.setMinimumSize(new Dimension(300, 100));
        this.setContentPane(this.getJContentPane());
        this.setTitle("Scale distance values");
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getScalePanel(), null);
            this.jContentPane.add((Component)this.getTargetPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getScalePanel() {
        if (this.scalePanel == null) {
            this.scalePanel = new JPanel();
            this.scalePanel.setLayout(new GridBagLayout());
            this.scalePanel.setBorder(BorderFactory.createTitledBorder(null, "Scale factor", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.scaleInput = new DecimalInput("", this.scalePanel, 0, "#.#######");
            this.scaleInput.setValue(1.0f);
            this.scalePanel.setAlignmentY(0.0f);
            this.scalePanel.setMaximumSize(new Dimension(this.scalePanel.getMaximumSize().width, this.scalePanel.getMinimumSize().height));
        }
        return this.scalePanel;
    }

    public DecimalInput getScaleInput() {
        this.getScalePanel();
        return this.scaleInput;
    }
}

