/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.specialformats;

import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.undo.format.DistanceValuesByNodeBranchDataEdit;
import info.bioinfweb.treegraph.gui.dialogs.DistanceValueInput;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.DistanceAdapterListModel;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.FormatsByNodeBranchDataDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class DistanceValuesByNodeBranchDataDialog
extends FormatsByNodeBranchDataDialog {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_MIN_WIDTH_IN_MM = 0.3;
    public static final double DEFAULT_MAX_WIDTH_IN_MM = 10.0;
    private JPanel jContentPane = null;
    private JPanel distancesPanel = null;
    private DistanceValueInput minWidthInput;
    private DistanceValueInput maxWidthInput;
    private JCheckBox changeUndefinedCheckBox = null;
    private JCheckBox inheritToTerminalsCheckBox = null;

    public DistanceValuesByNodeBranchDataDialog(Frame owner) {
        super(owner, 40);
        this.setHelpCode(39);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean customizeTarget() {
        this.getTargetListModel().setAdapters(this.getDocument().getTree(), false);
        if (this.getTargetListModel().getSize() >= 1) {
            this.getTargetList().setSelectionInterval(0, 0);
        }
        return true;
    }

    protected boolean apply() {
        Vector<DistanceAdapter> adapters = new Vector<DistanceAdapter>();
        int[] selection = this.getTargetList().getSelectedIndices();
        int i = 0;
        while (i < selection.length) {
            adapters.add(this.getTargetListModel().getElementAt(selection[i]));
            ++i;
        }
        this.getDocument().executeEdit(new DistanceValuesByNodeBranchDataEdit(this.getDocument(), this.getSourceComboBoxModel().getSelectedItem(), this.getMinWidthInput().parseFloat(), this.getMaxWidthInput().parseFloat(), this.getChangeUndefinedCheckBox().isSelected(), this.getInheritToTerminalsCheckBox().isSelected(), adapters.toArray(new DistanceAdapter[adapters.size()])));
        return true;
    }

    private void initialize() {
        this.setTitle("Set distance values by node/branch data");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected ListModel createTargetListModel() {
        return new DistanceAdapterListModel();
    }

    @Override
    protected DistanceAdapterListModel getTargetListModel() {
        return (DistanceAdapterListModel)super.getTargetListModel();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getSourcePanel(), null);
            this.jContentPane.add((Component)this.getDistancesPanel(), null);
            this.jContentPane.add((Component)this.getTargetPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getDistancesPanel() {
        if (this.distancesPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 6;
            GridBagConstraints undefinedGBC = new GridBagConstraints();
            undefinedGBC.gridx = 0;
            undefinedGBC.anchor = 17;
            undefinedGBC.gridwidth = 3;
            undefinedGBC.gridy = 5;
            this.distancesPanel = new JPanel();
            this.distancesPanel.setLayout(new GridBagLayout());
            this.distancesPanel.setBorder(BorderFactory.createTitledBorder(null, "Distance values", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.distancesPanel.add((Component)this.getChangeUndefinedCheckBox(), undefinedGBC);
            this.distancesPanel.add((Component)this.getInheritToTerminalsCheckBox(), gridBagConstraints);
            this.minWidthInput = new DistanceValueInput("Minimum value", this.distancesPanel, 1);
            this.minWidthInput.setValue(0.3);
            this.maxWidthInput = new DistanceValueInput("Maximum value", this.distancesPanel, 3);
            this.maxWidthInput.setValue(10.0);
            this.distancesPanel.setMaximumSize(new Dimension(this.distancesPanel.getMaximumSize().width, this.distancesPanel.getMinimumSize().height));
        }
        return this.distancesPanel;
    }

    private DistanceValueInput getMaxWidthInput() {
        this.getDistancesPanel();
        return this.maxWidthInput;
    }

    private DistanceValueInput getMinWidthInput() {
        this.getDistancesPanel();
        return this.minWidthInput;
    }

    private JCheckBox getChangeUndefinedCheckBox() {
        if (this.changeUndefinedCheckBox == null) {
            this.changeUndefinedCheckBox = new JCheckBox();
            this.changeUndefinedCheckBox.setText("Set undefined nodes to minimal width");
            this.changeUndefinedCheckBox.setSelected(true);
        }
        return this.changeUndefinedCheckBox;
    }

    private JCheckBox getInheritToTerminalsCheckBox() {
        if (this.inheritToTerminalsCheckBox == null) {
            this.inheritToTerminalsCheckBox = new JCheckBox();
            this.inheritToTerminalsCheckBox.setText("Set parent value to terminals");
        }
        return this.inheritToTerminalsCheckBox;
    }
}

