/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.specialformats;

import info.bioinfweb.treegraph.document.GraphicalLabel;
import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.Tree;
import info.bioinfweb.treegraph.document.format.adapters.distance.BranchLineWidthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.BranchMinLengthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.BranchSpaceAboveAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.BranchSpaceBelowAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.CornerRadiusAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.DistanceAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelHeightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelLineWidthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelMarginBottomAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelMarginLeftAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelMarginRightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelMarginTopAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelTextHeightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LabelWidthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LeafMarginBottomAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LeafMarginLeftAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LeafMarginRightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LeafMarginTopAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendLineWidthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendMarginBottomAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendMarginLeftAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendMarginRightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendMarginTopAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendSpacingAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.LegendTextHeightAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.NodeLineWidthAdapter;
import info.bioinfweb.treegraph.document.format.adapters.distance.NodeTextHeightAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import info.bioinfweb.treegraph.document.tools.TreeSerializer;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class DistanceAdapterListModel
extends AbstractListModel
implements ListModel {
    private List<DistanceAdapter> adapters = new Vector<DistanceAdapter>();

    public void setAdapters(Tree tree, boolean includeLegendFormats) {
        this.setAdapters(tree, tree.getPaintStart(), includeLegendFormats);
    }

    public void setAdapters(Tree tree, Node root, boolean includeLegendFormats) {
        if (!this.adapters.isEmpty()) {
            int end = this.getSize() - 1;
            this.adapters.clear();
            this.fireIntervalRemoved(this, 0, end);
        }
        this.adapters.add(new BranchLineWidthAdapter());
        this.adapters.add(new BranchMinLengthAdapter());
        this.adapters.add(new BranchSpaceAboveAdapter());
        this.adapters.add(new BranchSpaceBelowAdapter());
        this.adapters.add(new NodeLineWidthAdapter());
        this.adapters.add(new NodeTextHeightAdapter());
        this.adapters.add(new CornerRadiusAdapter());
        this.adapters.add(new LeafMarginLeftAdapter());
        this.adapters.add(new LeafMarginRightAdapter());
        this.adapters.add(new LeafMarginTopAdapter());
        this.adapters.add(new LeafMarginBottomAdapter());
        String[] ids = IDManager.getLabelIDs(root, TextLabel.class);
        int i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelTextHeightAdapter(ids[i]));
            ++i;
        }
        ids = IDManager.getLabelIDs(root, GraphicalLabel.class);
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelWidthAdapter(ids[i]));
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelHeightAdapter(ids[i]));
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelLineWidthAdapter(ids[i]));
            ++i;
        }
        ids = IDManager.getLabelIDs(root, Label.class);
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelMarginLeftAdapter(ids[i]));
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelMarginRightAdapter(ids[i]));
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelMarginTopAdapter(ids[i]));
            ++i;
        }
        i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelMarginBottomAdapter(ids[i]));
            ++i;
        }
        if (includeLegendFormats && TreeSerializer.getLegendsInSubtree(tree, root).length > 0) {
            this.adapters.add(new LegendLineWidthAdapter());
            this.adapters.add(new LegendTextHeightAdapter());
            this.adapters.add(new LegendSpacingAdapter());
            this.adapters.add(new LegendMarginLeftAdapter());
            this.adapters.add(new LegendMarginRightAdapter());
            this.adapters.add(new LegendMarginTopAdapter());
            this.adapters.add(new LegendMarginBottomAdapter());
        }
        this.fireIntervalAdded(this, 0, this.getSize() - 1);
    }

    public DistanceAdapter getElementAt(int pos) {
        return this.adapters.get(pos);
    }

    @Override
    public int getSize() {
        return this.adapters.size();
    }
}

