/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.specialformats;

import info.bioinfweb.treegraph.document.format.adapters.color.ColorAdapter;
import info.bioinfweb.treegraph.document.undo.format.ColorsByNodeBranchDataEdit;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.ColorAdapterListModel;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.ColorPreviewPanel;
import info.bioinfweb.treegraph.gui.dialogs.specialformats.FormatsByNodeBranchDataDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class ColorsByNodeBranchDataDialog
extends FormatsByNodeBranchDataDialog {
    private static final long serialVersionUID = 1L;
    private ColorsByNodeBranchDataDialog self = this;
    private JPanel jContentPane = null;
    private JPanel colorPanel = null;
    private JPanel minMaxPanel = null;
    private JButton minColorButton = null;
    private ColorPreviewPanel colorPreviewPanel = null;
    private JButton maxColorButton = null;
    private JCheckBox changeUndefinedCheckBox = null;
    private JCheckBox inheritToTerminalsCheckBox = null;

    public ColorsByNodeBranchDataDialog(Frame owner) {
        super(owner, 38);
        this.initialize();
        this.setLocationRelativeTo(owner);
    }

    @Override
    protected boolean customizeTarget() {
        this.getTargetListModel().setAdapters(this.getDocument().getTree().getPaintStart());
        if (this.getTargetListModel().getSize() >= 2) {
            this.getTargetList().setSelectionInterval(0, 1);
        }
        return true;
    }

    protected boolean apply() {
        Vector<ColorAdapter> adapters = new Vector<ColorAdapter>();
        int[] selection = this.getTargetList().getSelectedIndices();
        int i = 0;
        while (i < selection.length) {
            adapters.add(this.getTargetListModel().getElementAt(selection[i]));
            ++i;
        }
        this.getDocument().executeEdit(new ColorsByNodeBranchDataEdit(this.getDocument(), this.getSourceComboBoxModel().getSelectedItem(), this.getColorPreviewPanel().getMinColor(), this.getColorPreviewPanel().getMaxColor(), this.getChangeUndefinedCheckBox().isSelected(), this.getInheritToTerminalsCheckBox().isSelected(), adapters.toArray(new ColorAdapter[adapters.size()])));
        return true;
    }

    private void initialize() {
        this.setHelpCode(37);
        this.setTitle("Set colors by node/branch data");
        this.setContentPane(this.getJContentPane());
        this.pack();
    }

    @Override
    protected ColorAdapterListModel createTargetListModel() {
        return new ColorAdapterListModel();
    }

    @Override
    protected ColorAdapterListModel getTargetListModel() {
        return (ColorAdapterListModel)super.getTargetListModel();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getSourcePanel(), null);
            this.jContentPane.add((Component)this.getColorPanel(), null);
            this.jContentPane.add((Component)this.getTargetPanel(), null);
            this.jContentPane.add((Component)this.getButtonsPanel(), null);
        }
        return this.jContentPane;
    }

    private JPanel getColorPanel() {
        if (this.colorPanel == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 0;
            gridBagConstraints31.gridwidth = 2;
            gridBagConstraints31.anchor = 17;
            gridBagConstraints31.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = -1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridwidth = 2;
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridy = 1;
            this.colorPanel = new JPanel();
            this.colorPanel.setLayout(new GridBagLayout());
            this.colorPanel.setBorder(BorderFactory.createTitledBorder(null, "Color", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.colorPanel.add((Component)this.getMinMaxPanel(), gridBagConstraints11);
            this.colorPanel.add((Component)this.getChangeUndefinedCheckBox(), gridBagConstraints31);
            this.colorPanel.add((Component)this.getInheritToTerminalsCheckBox(), gridBagConstraints4);
            this.colorPanel.setMaximumSize(new Dimension(this.colorPanel.getMaximumSize().width, this.colorPanel.getMinimumSize().height));
        }
        return this.colorPanel;
    }

    private JPanel getMinMaxPanel() {
        if (this.minMaxPanel == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints3.weightx = 1.0;
            this.minMaxPanel = new JPanel();
            this.minMaxPanel.setLayout(new GridBagLayout());
            this.minMaxPanel.add((Component)this.getMinColorButton(), new GridBagConstraints());
            this.minMaxPanel.add((Component)this.getColorPreviewPanel(), gridBagConstraints3);
            this.minMaxPanel.add((Component)this.getMaxColorButton(), new GridBagConstraints());
        }
        return this.minMaxPanel;
    }

    private JButton getMinColorButton() {
        if (this.minColorButton == null) {
            this.minColorButton = new JButton();
            this.minColorButton.setText("Minimum...");
            this.minColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = JColorChooser.showDialog((Component)((Object)ColorsByNodeBranchDataDialog.this.self), "Minimal color", ColorsByNodeBranchDataDialog.this.getColorPreviewPanel().getMinColor());
                    if (color != null) {
                        ColorsByNodeBranchDataDialog.this.getColorPreviewPanel().setMinColor(color);
                    }
                }
            });
        }
        return this.minColorButton;
    }

    private ColorPreviewPanel getColorPreviewPanel() {
        if (this.colorPreviewPanel == null) {
            this.colorPreviewPanel = new ColorPreviewPanel();
        }
        return this.colorPreviewPanel;
    }

    private JButton getMaxColorButton() {
        if (this.maxColorButton == null) {
            this.maxColorButton = new JButton();
            this.maxColorButton.setText("Maximum...");
            this.maxColorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color color = JColorChooser.showDialog((Component)((Object)ColorsByNodeBranchDataDialog.this.self), "Maxmal color", ColorsByNodeBranchDataDialog.this.getColorPreviewPanel().getMaxColor());
                    if (color != null) {
                        ColorsByNodeBranchDataDialog.this.getColorPreviewPanel().setMaxColor(color);
                    }
                }
            });
        }
        return this.maxColorButton;
    }

    private JCheckBox getChangeUndefinedCheckBox() {
        if (this.changeUndefinedCheckBox == null) {
            this.changeUndefinedCheckBox = new JCheckBox();
            this.changeUndefinedCheckBox.setText("Set undefined to minmal color");
        }
        return this.changeUndefinedCheckBox;
    }

    private JCheckBox getInheritToTerminalsCheckBox() {
        if (this.inheritToTerminalsCheckBox == null) {
            this.inheritToTerminalsCheckBox = new JCheckBox();
            this.inheritToTerminalsCheckBox.setText("Set parent color to terminals");
        }
        return this.inheritToTerminalsCheckBox;
    }
}

