/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.specialformats;

import info.bioinfweb.treegraph.document.Label;
import info.bioinfweb.treegraph.document.Node;
import info.bioinfweb.treegraph.document.TextLabel;
import info.bioinfweb.treegraph.document.format.adapters.color.BranchLineColorAdapter;
import info.bioinfweb.treegraph.document.format.adapters.color.ColorAdapter;
import info.bioinfweb.treegraph.document.format.adapters.color.LabelLineColorAdapter;
import info.bioinfweb.treegraph.document.format.adapters.color.LabelTextColorAdapter;
import info.bioinfweb.treegraph.document.format.adapters.color.NodeLineColorAdapter;
import info.bioinfweb.treegraph.document.format.adapters.color.NodeTextColorAdapter;
import info.bioinfweb.treegraph.document.tools.IDManager;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;

public class ColorAdapterListModel
extends AbstractListModel<ColorAdapter>
implements ListModel<ColorAdapter> {
    private List<ColorAdapter> adapters = new Vector<ColorAdapter>();

    public void setAdapters(Node root) {
        if (!this.adapters.isEmpty()) {
            int end = this.getSize() - 1;
            this.adapters.clear();
            this.fireIntervalRemoved(this, 0, end);
        }
        this.adapters.add(new BranchLineColorAdapter());
        this.adapters.add(new NodeLineColorAdapter());
        this.adapters.add(new NodeTextColorAdapter());
        String[] ids = IDManager.getLabelIDs(root, Label.class);
        List<String> textLabelIDs = IDManager.getLabelIDListFromSubtree(root, TextLabel.class);
        int i = 0;
        while (i < ids.length) {
            this.adapters.add(new LabelLineColorAdapter(ids[i]));
            if (textLabelIDs.contains(ids[i])) {
                this.adapters.add(new LabelTextColorAdapter(ids[i]));
            }
            ++i;
        }
        this.fireIntervalAdded(this, 0, this.getSize() - 1);
    }

    @Override
    public ColorAdapter getElementAt(int pos) {
        return this.adapters.get(pos);
    }

    @Override
    public int getSize() {
        return this.adapters.size();
    }
}

