/*
 * Decompiled with CFR 0.152.
 */
package info.bioinfweb.treegraph.gui.dialogs.nodebranchdatainput;

import info.bioinfweb.treegraph.document.Document;
import info.bioinfweb.treegraph.document.PieChartLabel;
import info.bioinfweb.treegraph.gui.dialogs.DataIDComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PieChartSectionDataList
extends JPanel {
    private DataIDComboBox listIDComboBox = null;
    private JList<PieChartLabel.SectionData> idList = null;
    private JButton addButton = null;
    private JButton replaceButton = null;
    private JButton removeButton = null;
    private JButton clearButton;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JScrollPane idListScrollPane = null;
    private JTextField captionTextField;
    private JPanel buttonsPanel;
    private JLabel lblDataSource;
    private JLabel lblCaption;

    public PieChartSectionDataList() {
        this.initialize();
        this.refreshGUIStatus();
    }

    public void setIDs(Document document) {
        this.listIDComboBox.setIDs(document);
        this.refreshGUIStatus();
    }

    @Override
    public boolean isEnabled() {
        return this.getIDList().isEnabled();
    }

    @Override
    public void setEnabled(boolean flag) {
        this.getListIDComboBox().setEnabled(flag);
        this.getCaptionTextField().setEditable(flag);
        this.getIDList().setEnabled(flag);
        this.refreshGUIStatus();
    }

    public void refreshGUIStatus() {
        PieChartLabel.SectionData data = this.getIDList().getSelectedValue();
        if (data != null) {
            this.getListIDComboBox().setSelectedItem(data.getValueColumnID());
            this.getCaptionTextField().setText(data.getCaption());
        }
        if (this.isEnabled()) {
            boolean notEmpty = !this.getListModel().isEmpty();
            this.getRemoveButton().setEnabled(notEmpty);
            this.getClearButton().setEnabled(notEmpty);
            this.getReplaceButton().setEnabled(notEmpty);
            this.getClearButton().setEnabled(notEmpty);
            this.getMoveUpButton().setEnabled(this.getIDList().getSelectedIndex() > 0);
            this.getMoveDownButton().setEnabled(this.getIDList().getSelectedIndex() < this.getListModel().size() - 1);
        } else {
            this.getAddButton().setEnabled(false);
            this.getRemoveButton().setEnabled(false);
            this.getReplaceButton().setEnabled(false);
            this.getClearButton().setEnabled(false);
            this.getMoveUpButton().setEnabled(false);
            this.getMoveDownButton().setEnabled(false);
        }
    }

    private DefaultListModel<PieChartLabel.SectionData> getListModel() {
        return (DefaultListModel)this.getIDList().getModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.idList.getSelectionModel();
    }

    public boolean containsIDsToAdd() {
        return ((DefaultComboBoxModel)this.getListIDComboBox().getModel()).getSize() > 0;
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 1.0};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_lblDataSource = new GridBagConstraints();
        gbc_lblDataSource.insets = new Insets(0, 0, 5, 5);
        gbc_lblDataSource.anchor = 17;
        gbc_lblDataSource.gridx = 0;
        gbc_lblDataSource.gridy = 0;
        this.add((Component)this.getLblDataSource(), gbc_lblDataSource);
        GridBagConstraints listIDComboBoxGBC = new GridBagConstraints();
        listIDComboBoxGBC.fill = 2;
        listIDComboBoxGBC.gridy = 0;
        listIDComboBoxGBC.weightx = 1.0;
        listIDComboBoxGBC.insets = new Insets(2, 2, 5, 5);
        listIDComboBoxGBC.gridx = 1;
        this.add((Component)this.getListIDComboBox(), listIDComboBoxGBC);
        GridBagConstraints gbc_buttonsPanel = new GridBagConstraints();
        gbc_buttonsPanel.anchor = 11;
        gbc_buttonsPanel.gridheight = 3;
        gbc_buttonsPanel.insets = new Insets(0, 0, 5, 5);
        gbc_buttonsPanel.gridx = 2;
        gbc_buttonsPanel.gridy = 0;
        this.add((Component)this.getButtonsPanel(), gbc_buttonsPanel);
        GridBagConstraints gbc_lblCaption = new GridBagConstraints();
        gbc_lblCaption.insets = new Insets(0, 0, 5, 5);
        gbc_lblCaption.anchor = 17;
        gbc_lblCaption.gridx = 0;
        gbc_lblCaption.gridy = 1;
        this.add((Component)this.getLblCaption(), gbc_lblCaption);
        GridBagConstraints gbc_captionTextField = new GridBagConstraints();
        gbc_captionTextField.insets = new Insets(0, 0, 5, 5);
        gbc_captionTextField.fill = 2;
        gbc_captionTextField.gridx = 1;
        gbc_captionTextField.gridy = 1;
        this.add((Component)this.getCaptionTextField(), gbc_captionTextField);
        GridBagConstraints listScrollPaneGBC = new GridBagConstraints();
        listScrollPaneGBC.gridwidth = 2;
        listScrollPaneGBC.fill = 1;
        listScrollPaneGBC.gridy = 2;
        listScrollPaneGBC.weightx = 1.0;
        listScrollPaneGBC.weighty = 1.0;
        listScrollPaneGBC.insets = new Insets(2, 2, 0, 5);
        listScrollPaneGBC.gridx = 0;
        this.add((Component)this.getIdListScrollPane(), listScrollPaneGBC);
    }

    protected DataIDComboBox getListIDComboBox() {
        if (this.listIDComboBox == null) {
            this.listIDComboBox = new DataIDComboBox(false);
        }
        return this.listIDComboBox;
    }

    protected JList<PieChartLabel.SectionData> getIDList() {
        if (this.idList == null) {
            this.idList = new JList(new DefaultListModel());
            this.idList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    PieChartSectionDataList.this.refreshGUIStatus();
                }
            });
            this.idList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        if (PieChartSectionDataList.this.getIDList().getSelectedValue() != null) {
                            PieChartSectionDataList.this.getListIDComboBox().setSelectedItem(PieChartSectionDataList.this.getIDList().getSelectedValue());
                        }
                        PieChartSectionDataList.this.getReplaceButton().setEnabled(!PieChartSectionDataList.this.getListModel().isEmpty());
                        PieChartSectionDataList.this.getRemoveButton().setEnabled(!PieChartSectionDataList.this.getListModel().isEmpty());
                    }
                }
            });
        }
        return this.idList;
    }

    private PieChartLabel.SectionData getSelectedSectionData() {
        return new PieChartLabel.SectionData(this.getListIDComboBox().getSelectedItem(), this.getCaptionTextField().getText());
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PieChartSectionDataList.this.getListModel().addElement(PieChartSectionDataList.this.getSelectedSectionData());
                }
            });
        }
        return this.addButton;
    }

    private JButton getReplaceButton() {
        if (this.replaceButton == null) {
            this.replaceButton = new JButton();
            this.replaceButton.setText("Replace");
            this.replaceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PieChartSectionDataList.this.getListModel().set(PieChartSectionDataList.this.getIDList().getSelectedIndex(), PieChartSectionDataList.this.getSelectedSectionData());
                }
            });
        }
        return this.replaceButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton();
            this.removeButton.setText("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PieChartSectionDataList.this.getListModel().remove(PieChartSectionDataList.this.getIDList().getSelectedIndex());
                }
            });
        }
        return this.removeButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton("Clear");
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PieChartSectionDataList.this.getListModel().clear();
                }
            });
        }
        return this.clearButton;
    }

    private JButton getMoveDownButton() {
        if (this.moveDownButton == null) {
            this.moveDownButton = new JButton("Move down");
            this.moveDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PieChartSectionDataList.this.getIDList().getSelectedIndex();
                    PieChartLabel.SectionData data = (PieChartLabel.SectionData)PieChartSectionDataList.this.getListModel().remove(index);
                    PieChartSectionDataList.this.getListModel().add(index + 1, data);
                    PieChartSectionDataList.this.getIDList().setSelectedIndex(index + 1);
                }
            });
        }
        return this.moveDownButton;
    }

    private JButton getMoveUpButton() {
        if (this.moveUpButton == null) {
            this.moveUpButton = new JButton("Move up");
            this.moveUpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PieChartSectionDataList.this.getIDList().getSelectedIndex();
                    PieChartLabel.SectionData data = (PieChartLabel.SectionData)PieChartSectionDataList.this.getListModel().remove(index);
                    PieChartSectionDataList.this.getListModel().add(index - 1, data);
                    PieChartSectionDataList.this.getIDList().setSelectedIndex(index - 1);
                }
            });
        }
        return this.moveUpButton;
    }

    private JScrollPane getIdListScrollPane() {
        if (this.idListScrollPane == null) {
            this.idListScrollPane = new JScrollPane(this.getIDList());
        }
        return this.idListScrollPane;
    }

    public List<PieChartLabel.SectionData> getSectionDataList() {
        ArrayList<PieChartLabel.SectionData> result = new ArrayList<PieChartLabel.SectionData>();
        int i = 0;
        while (i < this.getListModel().size()) {
            result.add(this.getListModel().get(i));
            ++i;
        }
        return result;
    }

    public void setSectionDataList(List<PieChartLabel.SectionData> list) {
        this.getListModel().clear();
        for (PieChartLabel.SectionData sectionData : list) {
            this.getListModel().addElement(sectionData);
        }
        if (!this.getListModel().isEmpty()) {
            this.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    private JTextField getCaptionTextField() {
        if (this.captionTextField == null) {
            this.captionTextField = new JTextField();
            this.captionTextField.setColumns(10);
        }
        return this.captionTextField;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc_addButton = new GridBagConstraints();
            gbc_addButton.fill = 2;
            gbc_addButton.insets = new Insets(0, 0, 3, 0);
            gbc_addButton.gridx = 0;
            gbc_addButton.gridy = 0;
            this.buttonsPanel.add((Component)this.getAddButton(), gbc_addButton);
            GridBagConstraints gbc_replaceButton = new GridBagConstraints();
            gbc_replaceButton.fill = 2;
            gbc_replaceButton.insets = new Insets(0, 0, 3, 0);
            gbc_replaceButton.gridx = 0;
            gbc_replaceButton.gridy = 1;
            this.buttonsPanel.add((Component)this.getReplaceButton(), gbc_replaceButton);
            GridBagConstraints gbc_removeButton = new GridBagConstraints();
            gbc_removeButton.fill = 2;
            gbc_removeButton.insets = new Insets(0, 0, 3, 0);
            gbc_removeButton.gridx = 0;
            gbc_removeButton.gridy = 2;
            this.buttonsPanel.add((Component)this.getRemoveButton(), gbc_removeButton);
            GridBagConstraints gbc_clearButton = new GridBagConstraints();
            gbc_clearButton.fill = 2;
            gbc_clearButton.insets = new Insets(0, 0, 3, 0);
            gbc_clearButton.gridx = 0;
            gbc_clearButton.gridy = 3;
            this.buttonsPanel.add((Component)this.getClearButton(), gbc_clearButton);
            GridBagConstraints gbc_moveUpButton = new GridBagConstraints();
            gbc_moveUpButton.fill = 2;
            gbc_moveUpButton.insets = new Insets(0, 0, 3, 0);
            gbc_moveUpButton.gridx = 0;
            gbc_moveUpButton.gridy = 4;
            this.buttonsPanel.add((Component)this.getMoveUpButton(), gbc_moveUpButton);
            GridBagConstraints gbc_moveDownButton = new GridBagConstraints();
            gbc_moveDownButton.fill = 2;
            gbc_moveDownButton.gridx = 0;
            gbc_moveDownButton.gridy = 5;
            this.buttonsPanel.add((Component)this.getMoveDownButton(), gbc_moveDownButton);
        }
        return this.buttonsPanel;
    }

    private JLabel getLblDataSource() {
        if (this.lblDataSource == null) {
            this.lblDataSource = new JLabel("Data source: ");
        }
        return this.lblDataSource;
    }

    private JLabel getLblCaption() {
        if (this.lblCaption == null) {
            this.lblCaption = new JLabel("Caption: ");
        }
        return this.lblCaption;
    }
}

